-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Environmental.Relay_Controller;
with Jpats_Environmental.Container;

with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;


procedure Jpats_Environmental.Relay_Controller_Ctd is

   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr                    renames Container;
   package Relays                  renames Ctnr.Relay_Collection;
   package Ele                     renames Jpats_Electrical;
   package Ele_T                   renames Jpats_Electrical_Types;
   package Env_T                   renames Jpats_Environmental_Types;
   package Ac_Over_Pressure_Switch renames Ctnr.Ac_Over_Pressure_Switch;
   package Thermal_Time_Delay      renames Ctnr.Thermal_Time_Delay;
   package Oat_Switch              renames Ctnr.Oat_Switch;
   package Altitude_Switch         renames Ctnr.Altitude_Switch;
   package Ldg_Gear                renames Jpats_Landing_Gear;
   package Ldg_Gear_T              renames Jpats_Landing_Gear_Types;
   package High_Temp_Sw            renames Ctnr.Obogs_High_Temperature_Switch;


   The_Relays              : Relays.Instance                  renames Ctnr.This_Subsystem.The_Relays;
   The_Ac_Over_Pressure_Sw : Ac_Over_Pressure_Switch.Instance renames Ctnr.This_Subsystem.The_Ac_Over_Pressure_Switch;
   The_Thermal_Time_Delay  : Thermal_Time_Delay.Instance      renames Ctnr.This_Subsystem.The_Thermal_Time_Delay;
   The_Oat_Switch          : Oat_Switch.Instance              renames Ctnr.This_Subsystem.The_Oat_Switch;
   The_Alt_Sw              : Altitude_Switch.Instance         renames Ctnr.This_Subsystem.The_Cockpit_Altitude_Switch;
   The_Obogs_High_Temp_Sw  : High_Temp_Sw.Instance            renames Ctnr.This_Subsystem.The_Obogs_High_Temperature_Switch;

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..22) := (others => false);
begin
   Relay_Controller.Initialize;

   Test_Case_1 (1) := (Relays.Is_Open (The_Relays, Env_T.Defog_Select_Relay) and
                       not Relays.Is_Closed (The_Relays, Env_T.Defog_Select_Relay));
   Test_Case_1 (2) := Relays.Load (The_Relays, Env_T.Defog_Select_Relay) = 0.0;


   Test_Case_1 (3) := (Relays.Is_Open (The_Relays, Env_T.Condensor_Blower_Relay) and
                       not Relays.Is_Closed (The_Relays, Env_T.Condensor_Blower_Relay));
   Test_Case_1 (4) := Relays.Load (The_Relays, Env_T.Condensor_Blower_Relay) = 0.0;


   Test_Case_1 (5) := (Relays.Is_Open (The_Relays, Env_T.Ejector_Valve_Relay_1) and
                       not Relays.Is_Closed (The_Relays, Env_T.Ejector_Valve_Relay_1));
   Test_Case_1 (6) := Relays.Load (The_Relays, Env_T.Ejector_Valve_Relay_1) = 0.0;


   Test_Case_1 (7) := (Relays.Is_Open (The_Relays, Env_T.Ejector_Valve_Relay_2) and
                       not Relays.Is_Closed (The_Relays, Env_T.Ejector_Valve_Relay_2));
   Test_Case_1 (8) := Relays.Load (The_Relays, Env_T.Ejector_Valve_Relay_2) = 0.0;


   Test_Case_1 (9) := (Relays.Is_Open (The_Relays, Env_T.Bleed_Air_Flow_Relay_1) and
                       not Relays.Is_Closed (The_Relays, Env_T.Bleed_Air_Flow_Relay_1));
   Test_Case_1 (10) := Relays.Load (The_Relays, Env_T.Bleed_Air_Flow_Relay_1) = 0.0;


   Test_Case_1 (11) := (Relays.Is_Open (The_Relays, Env_T.Bleed_Air_Flow_Relay_2) and
                        not Relays.Is_Closed (The_Relays, Env_T.Bleed_Air_Flow_Relay_2));
   Test_Case_1 (12) := Relays.Load (The_Relays, Env_T.Bleed_Air_Flow_Relay_2) = 0.0;


   Test_Case_1 (13) := (Relays.Is_Open (The_Relays, Env_T.Ram_Air_Valve_Relay) and
                        not Relays.Is_Closed (The_Relays, Env_T.Ram_Air_Valve_Relay));
   Test_Case_1 (14) := Relays.Load (The_Relays, Env_T.Ram_Air_Valve_Relay) = 0.0;


   Test_Case_1 (15) := (Relays.Is_Open (The_Relays, Env_T.Auto_Pressure_Relay) and
                        not Relays.Is_Closed (The_Relays, Env_T.Auto_Pressure_Relay));
   Test_Case_1 (16) := Relays.Load (The_Relays, Env_T.Auto_Pressure_Relay) = 0.0;


   Test_Case_1 (17) := (Relays.Is_Open (The_Relays, Env_T.Cool_Command_Relay) and
                        not Relays.Is_Closed (The_Relays, Env_T.Cool_Command_Relay));
   Test_Case_1 (18) := Relays.Load (The_Relays, Env_T.Cool_Command_Relay) = 0.0;


   Test_Case_1 (19) := (Relays.Is_Open (The_Relays, Env_T.Heat_Exchanger_Blower_Relay) and
                        not Relays.Is_Closed (The_Relays, Env_T.Heat_Exchanger_Blower_Relay));
   Test_Case_1 (20) := Relays.Load (The_Relays, Env_T.Heat_Exchanger_Blower_Relay) = 0.0;


   Test_Case_1 (21) := (Relays.Is_Open (The_Relays, Env_T.Obogs_Duct_Temp_Sense_Relay) and
                        not Relays.Is_Closed (The_Relays, Env_T.Obogs_Duct_Temp_Sense_Relay));
   Test_Case_1 (22) := Relays.Load (The_Relays, Env_T.Obogs_Duct_Temp_Sense_Relay) = 0.0;


   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;
Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..2) := (others => false);
   Iconst : constant Float := 0.066667;
begin
   Relay_Controller.Initialize;
   Io.Defog_Select_Sw_On := True;
   for I in 1..1000 loop
      Relay_Controller.Update (Iconst);
   end loop;
   Test_Case_2 (1) := (not Relays.Is_Open (The_Relays, Env_T.Defog_Select_Relay) and
                       Relays.Is_Closed (The_Relays, Env_T.Defog_Select_Relay));
   Test_Case_2 (2) := Relays.Load (The_Relays, Env_T.Defog_Select_Relay) = 0.1;
   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Environmental.Relay_Controller_Ctd;
