-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Environmental.Pneumatics_Controller;
with Jpats_Environmental.Container;

with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Powerplant;

procedure Jpats_Environmental.Pneumatics_Controller_Ctd is

   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr                     renames Container;
   package Ele                      renames Jpats_Electrical;
   package Ele_T                    renames Jpats_Electrical_Types;
   package Flow_Control_Valve       renames Ctnr.Bi_Level_Flow_Control_Valve;
   package Relays                   renames Ctnr.Relay_Collection;
   package Env_T                    renames Jpats_Environmental_Types;
   package Cockpit                  renames Ctnr.Cockpit_Pressure_Vessel;
   package Pwrplnt                  renames Jpats_Powerplant;
   package Bleed_Air_Solenoid_Valve renames Ctnr.Bleed_Air_Solenoid_Valve;
   package Pneu_Relief_Vlv              renames Ctnr.Pneumatic_Pressure_Relief_Valve;
   package Pneu_Reg_Vlv                renames Ctnr.Pneumatic_Regulator;


   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

   The_Relays  : Relays.Instance  renames Ctnr.This_Subsystem.The_Relays;
   The_Cockpit : Cockpit.Instance renames Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel;
   The_Bleed_Air_Solenoid_Valve : Bleed_Air_Solenoid_Valve.Instance renames Ctnr.This_Subsystem.The_Bleed_Air_Solenoid_Valve;
   The_Flow_Control_Valve       : Flow_Control_Valve.Instance       renames Ctnr.This_Subsystem.The_Flow_Control_Valve;
   The_Pneu_Reg_Vlv             : Pneu_Reg_Vlv.Instance   renames Ctnr.This_Subsystem.The_Pneumatic_Regulator;
   The_Pneu_Relief_Vlv          : Pneu_Relief_Vlv.Instance renames Ctnr.This_Subsystem.The_Pneumatic_Pressure_Relief_Valve;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..20) := (others => false);
begin
   Pneumatics_Controller.Initialize;
   Test_Case_1 (1) := Cockpit.Pressure_Altitude (The_Cockpit) = 0.0;
   Test_Case_1 (2) := Cockpit.Pressure_Altitude_Last_Pass (The_Cockpit) = 0.0;
   Test_Case_1 (3) := Cockpit.Differential_Pressure (The_Cockpit) = 0.0;
   Test_Case_1 (4) := Cockpit.Temperature (The_Cockpit) = 0.0;
   Test_Case_1 (5) := Cockpit.Bleed_Pressure (The_Cockpit) = 0.0;
   Test_Case_1 (6) := Cockpit.Air_Mass (The_Cockpit) = 0.0;
   Test_Case_1 (7) := Cockpit.Air_Pressure (The_Cockpit) = 0.0;
   Test_Case_1 (8) := Cockpit.Rate_Of_Climb (The_Cockpit) = 0.0;
   Test_Case_1 (9) := Cockpit.Flow_In (The_Cockpit) = 0.0;
   Test_Case_1 (10) := Cockpit.Cockpit_Volume (The_Cockpit) = 160704.0;
   Test_Case_1 (11) := (not Bleed_Air_Solenoid_Valve.Is_Open(The_Bleed_Air_Solenoid_Valve) and
                        Bleed_Air_Solenoid_Valve.Is_Closed (The_Bleed_Air_Solenoid_Valve));
   Test_Case_1 (12) := Bleed_Air_Solenoid_Valve.Load (The_Bleed_Air_Solenoid_Valve) = 0.0;
   Test_Case_1 (13) := not Flow_Control_Valve.Is_High (The_Flow_Control_Valve);
   Test_Case_1 (14) := not Flow_Control_Valve.Is_Low (The_Flow_Control_Valve);
   Test_Case_1 (15) := Flow_Control_Valve.Is_Closed (The_Flow_Control_Valve);
   Test_Case_1 (16) := Flow_Control_Valve.Load (The_Flow_Control_Valve) = 0.0;
   Test_Case_1 (17) := Flow_Control_Valve.Restriction_Factor (The_Flow_Control_Valve) = 0.0;
   Test_Case_1 (18) := Pneu_Reg_Vlv.Pressure (The_Pneu_Reg_Vlv) = 0.0;
   Test_Case_1 (19) := not Pneu_Relief_Vlv.Is_Open (The_Pneu_Relief_Vlv) and Pneu_Relief_Vlv.Is_Closed (The_Pneu_Relief_Vlv);
   Test_Case_1 (20) := Pneu_Relief_Vlv.Quantity_Out (The_Pneu_Relief_Vlv) = 0.0;


   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;


Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..3) := (others => false);
   Iconst : constant Float := 0.06666667;
begin

   Pneumatics_Controller.Initialize;

   Io.Ecs_Bleed_Air_Inflow_Hi_Sw := True;
   Io.Ecs_Bleed_Air_Inflow_Off_Sw := False;
   Relays.Open_Relay (The_Relays, Env_T.Bleed_Air_Flow_Relay_2);

   for I in 1..1000 loop
      Pneumatics_Controller.Update (Iconst);
   end loop;

   Test_Case_2 (1) := Flow_Control_Valve.Is_High (The_Flow_Control_Valve);
   Test_Case_2 (2) := not Flow_Control_Valve.Is_Low (The_Flow_Control_Valve);
   Test_Case_2 (3) := not Flow_Control_Valve.Is_Closed (The_Flow_Control_Valve);

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Environmental.Pneumatics_Controller_Ctd;
