-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Environmental.Obogs_Controller;
with Jpats_Environmental.Container;

with Jpats_Electrical;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;
with Temperature_Types;
with Jpats_Electrical_Types;

procedure Jpats_Environmental.Obogs_Controller_Ctd is

   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr         renames Container;
   package Ele          renames Jpats_Electrical;
   package Concentrator renames Ctnr.Concentrator;
   package Regulator    renames Ctnr.Obogs_Regulator;
   package High_Temp_Sw renames Ctnr.Obogs_High_Temperature_Switch;
   package Low_Press_Sw renames Ctnr.Obogs_Low_Pressure_Switch;
   package Gear         renames Jpats_Landing_Gear;
   package Gear_T       renames Jpats_Landing_Gear_Types;
   package Cockpit      renames Ctnr.Cockpit_Pressure_Vessel;
   package Sov          renames Ctnr.Obogs_Shutoff_Valve;
   package Temp         renames Temperature_Types;

   The_Cockpit      : Cockpit.Instance      renames Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel;
   The_Concentrator : Concentrator.Instance renames Ctnr.This_Subsystem.The_Obogs_Concentrator;
   The_Regulator    : Regulator.Instance    renames Ctnr.This_Subsystem.The_Obogs_Regulator;
   The_Low_Press_Sw : Low_Press_Sw.Instance renames Ctnr.This_Subsystem.The_Obogs_Low_Pressure_Switch;
   The_High_Temp_Sw : High_Temp_Sw.Instance renames Ctnr.This_Subsystem.The_Obogs_High_Temperature_Switch;
   The_Sov          : Sov.Instance          renames Ctnr.This_Subsystem.The_Obogs_Shutoff_Valve;

   Obogs_Cb : constant Boolean := Ele.Is_Powered (Jpats_Electrical_Types.Obogs_Cb);

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..16) := (others => false);
begin

   Obogs_Controller.Initialize;

   Test_Case_1 (1) := Concentrator.Oxygen_Concentration (The_Concentrator) = 0.0;
   Test_Case_1 (2) := Concentrator.Pressure (The_Concentrator) = 0.0;
   Test_Case_1 (3) := not Concentrator.Obogs_Fail_Warn (The_Concentrator);
   Test_Case_1 (4) := not Concentrator.Bit_Out (The_Concentrator);
   Test_Case_1 (5) := not Concentrator.O2_Sel_Out (The_Concentrator);
   Test_Case_1 (6) := Concentrator.Load (The_Concentrator) = 0.0;
   Test_Case_1 (7) := Regulator.Pressure (The_Regulator) = 0.0;
   Test_Case_1 (8) := not Regulator.Power_Out (The_Regulator);
   Test_Case_1 (9) := not Regulator.Bit_Out (The_Regulator);
   Test_Case_1 (10) := not Regulator.O2_Sel_Out (The_Regulator);
   Test_Case_1 (11) := not Regulator.Max_Light (The_Regulator);
   Test_Case_1 (12) := Regulator.Load (The_Regulator) = 0.0;
   Test_Case_1 (13) := Low_Press_Sw.Is_Closed (The_Low_Press_Sw) and not Low_Press_Sw.Is_Open (The_Low_Press_Sw);
   Test_Case_1 (14) := High_Temp_Sw.Is_Closed (The_High_Temp_Sw) and not High_Temp_Sw.Is_Open (The_High_Temp_Sw);
   Test_Case_1 (15) := Sov.Is_Closed (The_Sov) and not Sov.Is_Open (The_Sov);
   Test_Case_1 (16) := Sov.Load (The_Sov) = 0.0;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);

end Test_1;



Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..2) := (others => false);
   Iconst : constant Float := 0.0666667;
begin
   Obogs_Controller.Initialize;
   Io.Oxygen_Supply_On_Sw := True;


   for I in 1..1000 loop
      Obogs_Controller.Update (Iconst);
   end loop;
   Test_Case_2 (1) := Sov.Is_Open (The_Sov);
   Test_Case_2 (2) := Sov.Load (The_Sov) = 3.3;
   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Environmental.Obogs_Controller_Ctd;
