-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Environmental.Cockpit_Pressure_Controller;
with Jpats_Environmental.Container;

with Jpats_Electrical;
with Jpats_Electrical_Types;
with Interpolation_Table.Singly_Indexed;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;

procedure Jpats_Environmental.Cockpit_Pressure_Controller_Ctd is

   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr  renames Container;
   package Ele   renames Jpats_Electrical;
   package Ele_T renames Jpats_Electrical_Types;
   package Cockpit renames Ctnr.Cockpit_Pressure_Vessel;
   package Single renames Interpolation_Table.Singly_Indexed;
   package Alt_Sw renames Ctnr.Altitude_Switch;
   package Gear renames Jpats_Landing_Gear;
   package Gear_T renames Jpats_Landing_Gear_Types;
   package Sol_Dump_Vlv renames Ctnr.Solenoid_Dump_Valve;
   package Control_Vlv renames Ctnr.Control_Valve;
   package Safety_Valve renames Ctnr.Safety_Valve;


   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;


   The_Cockpit : Cockpit.Instance renames Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel;
   The_Alt_Sw : Alt_Sw.Instance renames Ctnr.This_Subsystem.The_Cockpit_Altitude_Switch;
   The_Sol_Dump_Vlv : Sol_Dump_Vlv.Instance renames Ctnr.This_Subsystem.The_Solenoid_Dump_Valve;
   The_Control_Vlv : Control_Vlv.Instance renames Ctnr.This_Subsystem.The_Control_Valve;
   The_Safety_Valve : Safety_Valve.Instance renames Ctnr.This_Subsystem.The_Safety_Valve;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..7) := (others => false);
begin
   Cockpit_Pressure_Controller.Initialize;

   Test_Case_1 (1) := Alt_Sw.Is_Closed (The_Alt_Sw) and not Alt_Sw.Is_Open (The_Alt_Sw);
   Test_Case_1 (2) := Sol_Dump_Vlv.Is_Open (The_Sol_Dump_Vlv) and not Sol_Dump_Vlv.Is_Closed (The_Sol_Dump_Vlv);
   Test_Case_1 (3) := Sol_Dump_Vlv.Load (The_Sol_Dump_Vlv) = 0.0;
   Test_Case_1 (4) := Control_Vlv.Position (The_Control_Vlv) = 10.0;
   Test_Case_1 (5) := Control_Vlv.Area (The_Control_Vlv) = 15.0;
   Test_Case_1 (6) := Safety_Valve.Position (The_Safety_Valve) = 10.0;
   Test_Case_1 (7) := Safety_Valve.Area (The_Safety_Valve) = 15.0;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;
Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..1) := (others => false);
   Iconst : constant Float := 0.066667;
begin
   Cockpit_Pressure_Controller.Initialize;

   for I in 1..1000 loop
      Cockpit_Pressure_Controller.Update (Iconst);
   end loop;

    Test_Case_2 (1) := Safety_Valve.Position (The_Safety_Valve) = 0.0;
--    Test_Case_2 () := ;
--    Test_Case_2 () := ;
--    Test_Case_2 () := ;
--    Test_Case_2 () := ;
--    Test_Case_2 () := ;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Environmental.Cockpit_Pressure_Controller_Ctd;





