-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Environmental.Anti_Gravity_Controller;
with Jpats_Environmental.Container;

with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Powerplant;
with Force_Types;
procedure Jpats_Environmental.Anti_Gravity_Controller_Ctd is

   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr                       renames Container;
   package Ele                        renames Jpats_Electrical;
   package Ele_T                      renames Jpats_Electrical_Types;
   package Anti_Gravity_Shutoff_Valve renames Ctnr.Anti_Gravity_Shutoff_Valve;
   package Anti_Gravity_Valve         renames Ctnr.Anti_Gravity_Valve;
   package Pwrplnt                    renames Jpats_Powerplant;

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

   The_Anti_Gravity_Shutoff_Valve : Anti_Gravity_Shutoff_Valve.Instance renames Ctnr.This_Subsystem.The_Anti_G_Shutoff_Valve;
   The_Anti_Gravity_Valve : Anti_Gravity_Valve.Instance renames Ctnr.This_Subsystem.The_Anti_Gravity_Valve;

   Inflow_Cb : constant Boolean := Ele.Is_Powered (Ele_T.Inflow_Sys_Cb);

   Engine_Bleed_Pressure : constant Force_Types.Psi := Pwrplnt.Bleed_Pressure;

   Shutoff_Valve_Power_In : constant Boolean := Inflow_Cb and Io.Ecs_Bleed_Air_Inflow_Off_Sw;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..6) := (others => false);
begin
   Anti_Gravity_Controller.Initialize;
   Test_Case_1 (1) := Anti_Gravity_Shutoff_Valve.Pressure_Out (The_Anti_Gravity_Shutoff_Valve) = 0.0;
   Test_Case_1 (2) := Anti_Gravity_Shutoff_Valve.Flow_Rate_Out (The_Anti_Gravity_Shutoff_Valve) = 0.0;
   Test_Case_1 (3) := Anti_Gravity_Shutoff_Valve.Load (The_Anti_Gravity_Shutoff_Valve) = 0.0;
   Test_Case_1 (4) := Anti_Gravity_Valve.Pressure_Out (The_Anti_Gravity_Valve) = 0.0;
   Test_Case_1 (5) := Anti_Gravity_Valve.Flow_Rate_Out (The_Anti_Gravity_Valve) = 0.0;
   Test_Case_1 (6) := not Anti_Gravity_Valve.Pressure_Available (The_Anti_Gravity_Valve);

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;
Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..1) := (others => false);
   Iconst : constant Float := 0.066667;
begin
   Anti_Gravity_Controller.Initialize;
   Io.Ecs_Bleed_Air_Inflow_Off_Sw := True;
   Anti_Gravity_Controller.Update (Iconst);
   Test_Case_2 (1) := Anti_Gravity_Shutoff_Valve.Pressure_Out (The_Anti_Gravity_Shutoff_Valve) = 0.0;
   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Environmental.Anti_Gravity_Controller_Ctd;
