-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Environmental.Air_Conditioner_Controller;
with Jpats_Environmental.Container;

with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Environmental_Types;
with Jpats_Powerplant;

procedure Jpats_Environmental.Air_Conditioner_Controller_Ctd is

   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr                                          renames Container;
   package Ele                                           renames Jpats_Electrical;
   package Ele_T                                         renames Jpats_Electrical_Types;
   package Evap_Blwr                                     renames Ctnr.Evaporator_Blower;
   package Condensor_Blwr                                renames Ctnr.Condensor_Blower;
   package Heat_Exchanger_Blwr                           renames Ctnr.Heat_Exchanger_Blower;
   package Relays                                        renames Ctnr.Relay_Collection;
   package Ram_Air_Valve                                 renames Ctnr.Ram_Air_Valve;
   package Env_T                                         renames Jpats_Environmental_Types;
   package Bypass_Valve                                  renames Ctnr.Heat_Exchange_Bypass_Valve;
   package Bypass_Valve_30_Degrees_From_Full_Cold_Switch renames Ctnr.Bypass_Valve_30_Degrees_From_Full_Cold_Switch;
   package Cockpit_Temp_Controller                       renames Ctnr.Cockpit_Temperature_Controller;
   package Cockpit                                       renames Ctnr.Cockpit_Pressure_Vessel;
   package Low_Press_Sw                                  renames Ctnr.Ac_Low_Pressure_Switch;
   package Over_Press_Sw                                 renames Ctnr.Ac_Over_Pressure_Switch;
   package Over_Temp_Sw                                  renames Ctnr.Ac_Over_Temp_Sw;
   package Pwrplnt                                       renames Jpats_Powerplant;


   The_Relays                  : Relays.Instance                  renames Ctnr.This_Subsystem.The_Relays;
   The_Evap_Blwr               : Evap_Blwr.Instance               renames Ctnr.This_Subsystem.The_Evaporator_Blower;
   The_Condensor_Blwr          : Condensor_Blwr.Instance          renames Ctnr.This_Subsystem.The_Condensor_Blower;
   The_Heat_Exchanger_Blwr     : Heat_Exchanger_Blwr.Instance     renames Ctnr.This_Subsystem.The_Heat_Exchanger_Blower;
   The_Ram_Air_Valve           : Ram_Air_Valve.Instance           renames Ctnr.This_Subsystem.The_Ram_Air_Valve;
   The_Bypass_Valve            : Bypass_Valve.Instance            renames Ctnr.This_Subsystem.The_Heat_Exchange_Bypass_Valve;
   The_Cockpit_Temp_Controller : Cockpit_Temp_Controller.Instance renames Ctnr.This_Subsystem.The_Cockpit_Temperature_Controller;
   The_Cockpit                 : Cockpit.Instance                 renames Ctnr.This_Subsystem.The_Cockpit_Pressure_Vessel;
   The_Low_Press_Sw            : Low_Press_Sw.Instance            renames Ctnr.This_Subsystem.The_Ac_Low_Pressure_Switch;
   The_Over_Press_Sw           : Over_Press_Sw.Instance           renames Ctnr.This_Subsystem.The_Ac_Over_Pressure_Switch;
   The_Over_Temp_Sw            : Over_Temp_Sw.Instance            renames Ctnr.This_Subsystem.The_Ac_Over_Temp_Switch;

   The_Bypass_Valve_30_Degrees_From_Full_Cold_Switch :
     Bypass_Valve_30_Degrees_From_Full_Cold_Switch.Instance renames
     Ctnr.This_Subsystem.The_Bypass_Valve_30_Degrees_From_Full_Cold_Switch;

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..26) := (others => false);
begin

   Air_Conditioner_Controller.Initialize;

   Test_Case_1 (1)  := not Evap_Blwr.Is_High (The_Evap_Blwr);
   Test_Case_1 (2)  := not Evap_Blwr.Is_Low (The_Evap_Blwr);
   Test_Case_1 (3)  := Evap_Blwr.Is_Off (The_Evap_Blwr);
   Test_Case_1 (4)  := Evap_Blwr.Load (The_Evap_Blwr) = 0.0;
   Test_Case_1 (5)  := Evap_Blwr.Flow_Rate_Out (The_Evap_Blwr) = 0.0;
   Test_Case_1 (6)  := Condensor_Blwr.Is_Off (The_Condensor_Blwr) and not Condensor_Blwr.Is_On (The_Condensor_Blwr);
   Test_Case_1 (7)  := Condensor_Blwr.Load (The_Condensor_Blwr) = 0.0;
   Test_Case_1 (8)  := Condensor_Blwr.Flow_Rate_Out (The_Condensor_Blwr) = 0.0;
   Test_Case_1 (9)  := Heat_Exchanger_Blwr.Is_Off (The_Heat_Exchanger_Blwr) and not Heat_Exchanger_Blwr.Is_On (The_Heat_Exchanger_Blwr);
   Test_Case_1 (10) := Heat_Exchanger_Blwr.Load (The_Heat_Exchanger_Blwr) = 0.0;
   Test_Case_1 (11) := Heat_Exchanger_Blwr.Flow_Rate_Out (The_Heat_Exchanger_Blwr) = 0.0;
   Test_Case_1 (12) := not Ram_Air_Valve.Is_High (The_Ram_Air_Valve);
   Test_Case_1 (13) := not Ram_Air_Valve.Is_Norm (The_Ram_Air_Valve);
   Test_Case_1 (14) := Ram_Air_Valve.Is_Closed (The_Ram_Air_Valve);
   Test_Case_1 (15) := Ram_Air_Valve.Load (The_Ram_Air_Valve) = 0.0;
   Test_Case_1 (16) := Bypass_Valve.Position (The_Bypass_Valve) = 0.0;
   Test_Case_1 (17) := Bypass_Valve.Load (The_Bypass_Valve) = 0.0;
   Test_Case_1 (18) := Bypass_Valve.Full_Cold (The_Bypass_Valve);
   Test_Case_1 (19) := not Bypass_Valve.Full_Hot (The_Bypass_Valve);
   Test_Case_1 (20) := (not Bypass_Valve_30_Degrees_From_Full_Cold_Switch.Is_Closed (The_Bypass_Valve_30_Degrees_From_Full_Cold_Switch) and
                        Bypass_Valve_30_Degrees_From_Full_Cold_Switch.Is_Open (The_Bypass_Valve_30_Degrees_From_Full_Cold_Switch));
   Test_Case_1 (21) := not Cockpit_Temp_Controller.Increase (The_Cockpit_Temp_Controller);
   Test_Case_1 (22) := not Cockpit_Temp_Controller.Decrease (The_Cockpit_Temp_Controller);
   Test_Case_1 (23) := Cockpit_Temp_Controller.Load (The_Cockpit_Temp_Controller) = 0.0;
   Test_Case_1 (24) := not Low_Press_Sw.Is_Open (The_Low_Press_Sw) and  Low_Press_Sw.Is_Closed (The_Low_Press_Sw);
   Test_Case_1 (25) := not Over_Press_Sw.Is_Open (The_Over_Press_Sw) and Over_Press_Sw.Is_Closed (The_Over_Press_Sw);
   Test_Case_1 (26) := not Over_Temp_Sw.Is_Open (The_Over_Temp_Sw) and Over_Temp_Sw.Is_Closed (The_Over_Temp_Sw);


   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;


Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..1) := (others => false);
   Iconst : constant Float := 0.0666667;
begin
   Air_Conditioner_Controller.Initialize;

   Relays.Close_Relay (The_Relays, Env_T.Heat_Exchanger_Blower_Relay);

   Air_Conditioner_Controller.Update (Iconst);

   Test_Case_2 (1) := Heat_Exchanger_Blwr.Is_On (The_Heat_Exchanger_Blwr);

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Environmental.Air_Conditioner_Controller_Ctd;
