-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Bypass_Valve_G;

procedure Bypass_Valve_G_Ctd is


begin

   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      In_First_Quarter_Timer  : Float := 0.0;
      In_Second_Quarter_Timer : Float := 0.0;
      In_Third_Quarter_Timer  : Float := 0.0;
      In_Fourth_Quarter_Timer : Float := 0.0;

      In_First_Quarter_Timer_Latch  : Boolean := True;
      In_Second_Quarter_Timer_Latch : Boolean := True;
      In_Third_Quarter_Timer_Latch  : Boolean := True;
      In_Fourth_Quarter_Timer_Latch : Boolean := True;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      subtype Valve_Position is Float range 0.0..10.0;

      package Bypass_Vlv is new Bypass_Valve_G
        (Current_Type  => Float,
         Position_Type => Valve_Position);

      A_Bypass_Vlv : Bypass_Vlv.Instance;


      Test_1  : Boolean; Test_10 : Boolean; Test_19 : Boolean; Test_28 : Boolean;
      Test_2  : Boolean; Test_11 : Boolean; Test_20 : Boolean; Test_29 : Boolean;
      Test_3  : Boolean; Test_12 : Boolean; Test_21 : Boolean; Test_30 : Boolean;
      Test_4  : Boolean; Test_13 : Boolean; Test_22 : Boolean; Test_31 : Boolean;
      Test_5  : Boolean; Test_14 : Boolean; Test_23 : Boolean; Test_32 : Boolean;
      Test_6  : Boolean; Test_15 : Boolean; Test_24 : Boolean; Test_33 : Boolean;
      Test_7  : Boolean; Test_16 : Boolean; Test_25 : Boolean; Test_34 : Boolean;
      Test_8  : Boolean; Test_17 : Boolean; Test_26 : Boolean; Test_35 : Boolean;
      Test_9  : Boolean; Test_18 : Boolean; Test_27 : Boolean; Test_36 : Boolean;

   begin

      Bypass_Vlv.Initialize (A_Bypass_Vlv);
      Test_1 := Bypass_Vlv.Position (A_Bypass_Vlv) = 0.0;
      Test_2 := Bypass_Vlv.Load (A_Bypass_Vlv) = 0.0;
      Test_3 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = True;
      Test_4 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Bypass_Vlv.Update
              (An_Instance => A_Bypass_Vlv,
               Iconst      => Iconst,
               Cold_Pin    => False,
               Hot_Pin     => False);

            if In_First_Quarter then
               Test_5 := Bypass_Vlv.Position (A_Bypass_Vlv) = 0.0;
               Test_6 := Bypass_Vlv.Load (A_Bypass_Vlv) = 0.0;
               Test_7 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = True;
               Test_8 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
            end if;
            In_First_Quarter := False;
            In_First_Quarter_Timer  := In_First_Quarter_Timer + Iconst;
            if In_First_Quarter_Timer >= 30.0 and In_First_Quarter_Timer_Latch then
               Test_9  := Bypass_Vlv.Position (A_Bypass_Vlv) = 0.0;
               Test_10 := Bypass_Vlv.Load (A_Bypass_Vlv) = 0.0;
               Test_11 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = True;
               Test_12 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
               Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9);
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
               In_First_Quarter_Timer_Latch := False;
            end if;
         elsif Now < Two_Quarter_Time then

            Bypass_Vlv.Update
              (An_Instance => A_Bypass_Vlv,
               Iconst      => Iconst,
               Cold_Pin    => False,
               Hot_Pin     => True);

            if In_Second_Quarter then
               Test_13 := Bypass_Vlv.Position (A_Bypass_Vlv) >= 0.0;
               Test_14 := Bypass_Vlv.Load (A_Bypass_Vlv) = 2.5;
               Test_15 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = False;
               Test_16 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
            end if;
            In_Second_Quarter := False;
            In_Second_Quarter_Timer  := In_Second_Quarter_Timer + Iconst;
            if In_Second_Quarter_Timer >= 31.0 and In_Second_Quarter_Timer_Latch then
               Test_17 := Bypass_Vlv.Position (A_Bypass_Vlv) = 10.0;
               Test_18 := Bypass_Vlv.Load (A_Bypass_Vlv) = 0.0;
               Test_19 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = False;
               Test_20 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = True;
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
               In_Second_Quarter_Timer_Latch := False;
            end if;
         elsif Now < Three_Quarter_Time then

            Bypass_Vlv.Update
              (An_Instance => A_Bypass_Vlv,
               Iconst      => Iconst,
               Cold_Pin    => True,
               Hot_Pin     => False);

            if In_Third_Quarter then
               Test_21 := Bypass_Vlv.Position (A_Bypass_Vlv) <= 10.0;
               Test_22 := Bypass_Vlv.Load (A_Bypass_Vlv) = 2.5;
               Test_23 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = False;
               Test_24 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
            end if;
            In_Third_Quarter := False;
            In_Third_Quarter_Timer  := In_Third_Quarter_Timer + Iconst;
            if In_Third_Quarter_Timer >= 31.0 and In_Third_Quarter_Timer_Latch then
               Test_25 := Bypass_Vlv.Position (A_Bypass_Vlv) = 0.0;
               Test_26 := Bypass_Vlv.Load (A_Bypass_Vlv) = 0.0;
               Test_27 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = True;
               Test_28 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
               Class_Test_Result_File.Report_Case_Status (Success => Test_26, Number => 26);
               Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);
               Class_Test_Result_File.Report_Case_Status (Success => Test_28, Number => 28);
               In_Third_Quarter_Timer_Latch := False;
            end if;
         else

            Bypass_Vlv.Update
              (An_Instance => A_Bypass_Vlv,
               Iconst      => Iconst,
               Cold_Pin    => True,
               Hot_Pin     => True);

            if In_Fourth_Quarter then
               Test_29 := Bypass_Vlv.Position (A_Bypass_Vlv) = 0.0;
               Test_30 := Bypass_Vlv.Load (A_Bypass_Vlv) = 0.0;
               Test_31 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = True;
               Test_32 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
               Class_Test_Result_File.Report_Case_Status (Success => Test_29, Number => 29);
               Class_Test_Result_File.Report_Case_Status (Success => Test_30, Number => 30);
               Class_Test_Result_File.Report_Case_Status (Success => Test_31, Number => 31);
               Class_Test_Result_File.Report_Case_Status (Success => Test_32, Number => 32);
            end if;
            In_Fourth_Quarter := False;
            In_Fourth_Quarter_Timer := In_Fourth_Quarter_Timer + Iconst;
            if In_Fourth_Quarter_Timer >= 31.0 and In_Fourth_Quarter_Timer_Latch then
               Test_33 := Bypass_Vlv.Position (A_Bypass_Vlv) = 0.0;
               Test_34 := Bypass_Vlv.Load (A_Bypass_Vlv) = 0.0;
               Test_35 := Bypass_Vlv.Full_Cold (A_Bypass_Vlv) = True;
               Test_36 := Bypass_Vlv.Full_Hot (A_Bypass_Vlv) = False;
               Class_Test_Result_File.Report_Case_Status (Success => Test_33, Number => 33);
               Class_Test_Result_File.Report_Case_Status (Success => Test_34, Number => 34);
               Class_Test_Result_File.Report_Case_Status (Success => Test_35, Number => 35);
               Class_Test_Result_File.Report_Case_Status (Success => Test_36, Number => 36);
               In_Fourth_Quarter_Timer_Latch := False;
            end if;
         end if;

      end loop;


   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;


end Bypass_Valve_G_Ctd;
