-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Anti_Gravity_Shutoff_Valve_G;

procedure Anti_Gravity_Shutoff_Valve_G_Ctd is


begin


   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Sov is new Anti_Gravity_Shutoff_Valve_G
        (Current_Type   => Float,
         Powered_Load   => 2.5,
         Pressure_Type  => Float,
         Flow_Rate_Type => Float,
         K_Open         => 1.0,
         K_Closed       => 0.0);

      A_Sov : Sov.Instance;

      Test_1 : Boolean;
      Test_2 : Boolean;
      Test_3 : Boolean;
      Test_4 : Boolean;
      Test_5 : Boolean;
      Test_6 : Boolean;
      Test_7 : Boolean;
      Test_8 : Boolean;
      Test_9 : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;

   begin

      Sov.Initialize (A_Sov);
      Test_1 := Sov.Pressure_Out (A_Sov) = 0.0;
      Test_2 := Sov.Flow_Rate_Out (A_Sov) = 0.0;
      Test_3 := Sov.Load (A_Sov) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Sov.Update
              (An_Instance  => A_Sov,
               Power_In     => False,
               Pressure_In  => 123.0,
               Flow_Rate_In => 456.0);

            if In_First_Quarter then
               Test_4 := Sov.Pressure_Out (A_Sov) = 123.0;
               Test_5 := Sov.Flow_Rate_Out (A_Sov) = 456.0;
               Test_6 := Sov.Load (A_Sov) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then


            Sov.Update
              (An_Instance  => A_Sov,
               Power_In     => True,
               Pressure_In  => 123.0,
               Flow_Rate_In => 456.0);

            if In_Second_Quarter then
               Test_7 := Sov.Pressure_Out (A_Sov) = 0.0;
               Test_8 := Sov.Flow_Rate_Out (A_Sov) = 0.0;
               Test_9 := Sov.Load (A_Sov) = 2.5;
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then


            Sov.Update
              (An_Instance  => A_Sov,
               Power_In     => False,
               Pressure_In  => 130.0,
               Flow_Rate_In => 987.0);

            if In_Third_Quarter then
               Test_10 := Sov.Pressure_Out (A_Sov) = 130.0;
               Test_11 := Sov.Flow_Rate_Out (A_Sov) = 987.0;
               Test_12 := Sov.Load (A_Sov) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
            end if;
            In_Third_Quarter := False;
         else


            Sov.Update
              (An_Instance  => A_Sov,
               Power_In     => False,
               Pressure_In  => 150.0,
               Flow_Rate_In => 321.0);

            if In_Fourth_Quarter then
               Test_13 := Sov.Pressure_Out (A_Sov) = 150.0;
               Test_14 := Sov.Flow_Rate_Out (A_Sov) = 321.0;
               Test_15 := Sov.Load (A_Sov) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;





   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;


end Anti_Gravity_Shutoff_Valve_G_Ctd;
