-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Altitude_Switch_G;

procedure Altitude_Switch_G_Ctd is


begin

   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Alt_Sw is new Altitude_Switch_G
        (Altitude_Type      => Float,
         Altitude_Threshold => 1000.0);

      A_Alt_Sw : Alt_Sw.Instance;

      Test_1 : Boolean;
      Test_2 : Boolean;
      Test_3 : Boolean;
      Test_4 : Boolean;
      Test_5 : Boolean;


   begin

      Alt_Sw.Initialize (A_Alt_Sw);
      Test_1 := not Alt_Sw.Is_Open (A_Alt_Sw) and Alt_Sw.Is_Closed (A_Alt_Sw);
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Alt_Sw.Update
              (An_Instance => A_Alt_Sw,
               Altitude    => 10.0);

            if In_First_Quarter then
               Test_2 := not Alt_Sw.Is_Open (A_Alt_Sw) and Alt_Sw.Is_Closed (A_Alt_Sw);
               Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Alt_Sw.Update
              (An_Instance => A_Alt_Sw,
               Altitude    => 1010.0);

            if In_Second_Quarter then
               Test_3 := Alt_Sw.Is_Open (A_Alt_Sw) and not Alt_Sw.Is_Closed (A_Alt_Sw);
               Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Alt_Sw.Update
              (An_Instance => A_Alt_Sw,
               Altitude    => 1015.0);

            if In_Third_Quarter then
               Test_4 := Alt_Sw.Is_Open (A_Alt_Sw) and not Alt_Sw.Is_Closed (A_Alt_Sw);
               Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
            end if;
            In_Third_Quarter := False;
         else

            Alt_Sw.Update
              (An_Instance => A_Alt_Sw,
               Altitude    => 0.0);

            if In_Fourth_Quarter then
               Test_5 := not Alt_Sw.Is_Open (A_Alt_Sw) and Alt_Sw.Is_Closed (A_Alt_Sw);
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;

   end;


   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;



end Altitude_Switch_G_Ctd;
