-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Ac_Compressor_G;

procedure Ac_Compressor_G_Ctd is


begin

   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Compressor is new Ac_Compressor_G
        (Ampere_Type              => Float,
         Torque_Type              => Float,
         Rpm_Type                 => Float,
         Shaft_Horsepower_Type    => Float,
         Engaged_Load             => 5.5,
         Engaged_Shaft_Horsepower => 17.0);

      A_Compressor : Compressor.Instance;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;
      Test_16 : Boolean;
      Test_17 : Boolean;
      Test_18 : Boolean;
      Test_19 : Boolean;
      Test_20 : Boolean;

   begin

      Compressor.Initialize (A_Compressor);
      Test_1 := not Compressor.Is_On (A_Compressor) and Compressor.Is_Off (A_Compressor);
      Test_2 := Compressor.Load (A_Compressor) = 0.0;
      Test_3 := Compressor.Torque (A_Compressor) = 0.0;
      Test_4 := Compressor.Shaft_Horsepower (A_Compressor) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Compressor.Update
              (An_Instance     => A_Compressor,
               Engage_Demanded => False,
               Engine_Rpm      => 1000.0);

            if In_First_Quarter then
               Test_5 := not Compressor.Is_On (A_Compressor) and Compressor.Is_Off (A_Compressor);
               Test_6 := Compressor.Load (A_Compressor) = 0.0;
               Test_7 := Compressor.Torque (A_Compressor) = 0.0;
               Test_8 := Compressor.Shaft_Horsepower (A_Compressor) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Compressor.Update
              (An_Instance     => A_Compressor,
               Engage_Demanded => True,
               Engine_Rpm      => 2000.0);

            if In_Second_Quarter then
               Test_9  := Compressor.Is_On (A_Compressor) and not Compressor.Is_Off (A_Compressor);
               Test_10 := Compressor.Load (A_Compressor) = 5.5;
               Test_11 := Compressor.Torque (A_Compressor) >= 44.642 and Compressor.Torque (A_Compressor) <= 44.643;
               Test_12 := Compressor.Shaft_Horsepower (A_Compressor) = 17.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Compressor.Update
              (An_Instance     => A_Compressor,
               Engage_Demanded => True,
               Engine_Rpm      => 2500.0);

            if In_Third_Quarter then
               Test_13 := Compressor.Is_On (A_Compressor) and not Compressor.Is_Off (A_Compressor);
               Test_14 := Compressor.Load (A_Compressor) = 5.5;
               Test_15 := Compressor.Torque (A_Compressor) >= 35.7 and Compressor.Torque (A_Compressor) <= 35.8;
               Test_16 := Compressor.Shaft_Horsepower (A_Compressor) = 17.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
            end if;
            In_Third_Quarter := False;
         else

            Compressor.Update
              (An_Instance     => A_Compressor,
               Engage_Demanded => False,
               Engine_Rpm      => 1500.0);

            if In_Fourth_Quarter then
               Test_17 := not Compressor.Is_On (A_Compressor) and Compressor.Is_Off (A_Compressor);
               Test_18 := Compressor.Load (A_Compressor) = 0.0;
               Test_19 := Compressor.Torque (A_Compressor) = 0.0;
               Test_20 := Compressor.Shaft_Horsepower (A_Compressor) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;

   end;


   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;



end Ac_Compressor_G_Ctd;
