-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------



with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Power_Supply.Generator;
with Torque_Types;
with Angle_Types;
with Electrical_Units_Types;


procedure Power_Supply.Generator_Ctd is



begin


   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      package Gen renames Power_Supply.Generator;
      The_Gen : Gen.Instance;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;
      Test_16 : Boolean;
      Test_17 : Boolean;
      Test_18 : Boolean;
      Test_19 : Boolean;
      Test_20 : Boolean;
      Test_21 : Boolean;
      Test_22 : Boolean;
      Test_23 : Boolean;
      Test_24 : Boolean;
      Test_25 : Boolean;

   begin

      Gen.Initialize (The_Gen);
      Test_1 := Power_Supply.Voltage (The_Gen) = 0.0;
      Test_2 := Power_Supply.Load (The_Gen) = 0.0;
      Test_3 := Power_Supply.Power_Available (The_Gen) = False;
      Test_4 := Gen.Starter_Load (The_Gen) = 0.0;
      Test_5 := Gen.Torque (The_Gen) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
      Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);


      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Gen.Update
              (An_Instance     => The_Gen,
               Starter_Engaged => True,
               Voltage_In      => 24.0,
               Gen_Shaft_Rpm   => 0.0);


            if In_First_Quarter then
               Test_6 := Power_Supply.Voltage (The_Gen) = 0.0;
               Test_7 := Power_Supply.Load (The_Gen) = 0.0;
               Test_8 := Power_Supply.Power_Available (The_Gen) = False;
               Test_9 := Gen.Starter_Load (The_Gen) = 0.0;
               Test_10 := Gen.Torque (The_Gen) = 65.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_6 , Number => 6 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_7 , Number => 7 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_8 , Number => 8 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Gen.Update
              (An_Instance     => The_Gen,
               Starter_Engaged => True,
               Voltage_In      => 24.0,
               Gen_Shaft_Rpm   => 1000.0);

            if In_Second_Quarter then
               Test_11 := Power_Supply.Voltage (The_Gen) = 0.0;
               Test_12 := Power_Supply.Load (The_Gen) = 0.0;
               Test_13 := Power_Supply.Power_Available (The_Gen) = False;
               Test_14 := Gen.Starter_Load (The_Gen) >= 2119.0 and Gen.Starter_Load (The_Gen) <= 2119.6;
               Test_15 := Gen.Torque (The_Gen) = 50.87;
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Power_Supply.Set_Load (The_Gen, 300.0);

            Gen.Update
              (An_Instance     => The_Gen,
               Starter_Engaged => False,
               Voltage_In      => 0.0,
               Gen_Shaft_Rpm   => 24375.0);

            if In_Third_Quarter then
               Test_16 := Power_Supply.Voltage (The_Gen) = 28.5;
               Test_17 := Power_Supply.Load (The_Gen) = 300.0;
               Test_18 := Power_Supply.Power_Available (The_Gen) = True;
               Test_19 := Gen.Starter_Load (The_Gen) = 0.0;
               Test_20 := Gen.Torque (The_Gen) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
            end if;
            In_Third_Quarter := False;
         else

            Power_Supply.Set_Load (The_Gen, 400.0);

            Gen.Update
              (An_Instance     => The_Gen,
               Starter_Engaged => False,
               Voltage_In      => 0.0,
               Gen_Shaft_Rpm   => 24375.0);

            if In_Fourth_Quarter then
               Test_21 := Power_Supply.Voltage (The_Gen) = 21.0;
               Test_22 := Power_Supply.Load (The_Gen) = 400.0;
               Test_23 := Power_Supply.Power_Available (The_Gen) = True;
               Test_24 := Gen.Starter_Load (The_Gen) = 0.0;
               Test_25 := Gen.Torque (The_Gen) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;


   end;



   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;

end Power_Supply.Generator_Ctd;

