-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Path_G;

procedure Path_G_Ctd is


begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Path is new Path_G (Float);

      A_Path : Path.Instance;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;

   begin

      Path.Initialize (A_Path);
      Test_1 := not Path.Is_Complete (A_Path);
      Test_2 := Path.Voltage (A_Path) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Path.Update
              (An_Instance => A_Path,
               Completed   => True,
               Voltage     => 28.0);

            if In_First_Quarter then
               Test_3 := Path.Is_Complete (A_Path);
               Test_4 := Path.Voltage (A_Path) = 28.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
               Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Path.Update
              (An_Instance => A_Path,
               Completed   => False,
               Voltage     => 0.0);

            if In_Second_Quarter then
               Test_5 := not Path.Is_Complete (A_Path);
               Test_6 := Path.Voltage (A_Path) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Path.Update
              (An_Instance => A_Path,
               Completed   => True,
               Voltage     => 24.0);

            if In_Third_Quarter then
               Test_7 := Path.Is_Complete (A_Path);
               Test_8 := Path.Voltage (A_Path) = 24.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
            end if;
            In_Third_Quarter := False;
         else

            Path.Update
              (An_Instance => A_Path,
               Completed   => True,
               Voltage     => 10.0);

            if In_Fourth_Quarter then
               Test_9 := Path.Is_Complete (A_Path);
               Test_10 := Path.Voltage (A_Path) = 10.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;

   end;

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      package Path is new Path_G (Float);

      A_Path : Path.Instance;

      Test_11  : Boolean;
      Test_12  : Boolean;
      Test_13  : Boolean;
      Test_14  : Boolean;
      Test_15  : Boolean;
      Test_16  : Boolean;
      Test_17  : Boolean;
      Test_18  : Boolean;

   begin

      Path.Initialize (A_Path);

      while Now < Stop_Time
      loop


         if Now < One_Quarter_Time then

            Path.Complete (A_Path, 28.0);

            if In_First_Quarter then
               Test_11 := Path.Is_Complete (A_Path);
               Test_12 := Path.Voltage (A_Path) = 28.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then


            Path.Incomplete (A_Path);


            if In_Second_Quarter then
               Test_13 := not Path.Is_Complete (A_Path);
               Test_14 := Path.Voltage (A_Path) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Path.Complete (A_Path, 24.0);

            if In_Third_Quarter then
               Test_15 := Path.Is_Complete (A_Path);
               Test_16 := Path.Voltage (A_Path) = 24.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
            end if;
            In_Third_Quarter := False;
         else

            Path.Complete (A_Path, 10.0);

            if In_Fourth_Quarter then
               Test_17 := Path.Is_Complete (A_Path);
               Test_18 := Path.Voltage (A_Path) = 10.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;

   end;


end Path_G_Ctd;
