-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Path_G;
with Path_Collection_G;

procedure Path_Collection_G_Ctd is



begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Path is new Path_G (Float);
      type Pwr_Source_Name_Type is (Batt, Aux_Batt, Gen, Ext_Pwr);
      type Bus_Name_Type is (Bus_A, Bus_B, Bus_C, Bus_D);
      type Path_Array is array (Pwr_Source_Name_Type,Bus_Name_Type) of Path.Instance;
      type Path_Bool_Array is array (Pwr_Source_Name_Type,Bus_Name_Type) of Boolean;
      type Pwr_Source_Vdc_Array is array (Pwr_Source_Name_Type) of Float;

      package Paths is new Path_Collection_G
        (Voltage_Type                       => Float,
         Power_Source_Name_Type             => Pwr_Source_Name_Type,
         Bus_Name_Type                      => Bus_Name_Type,
         Path_Type                          => Path.Instance,
         Array_Of_Path_Type                 => Path_Array,
         Array_Of_Boolean_Type              => Path_Bool_Array,
         Array_Of_Power_Source_Voltage_Type => Pwr_Source_Vdc_Array,
         Complete_A_Path                    => Path.Complete,
         Incomplete_A_Path                  => Path.Incomplete,
         Is_A_Path_Complete                 => Path.Is_Complete,
         A_Path_Voltage                     => Path.Voltage,
         Update_A_Path                      => Path.Update,
         Initialize_A_Path                  => Path.Initialize);

      The_Paths : Paths.Instance;

      Path_Completion : Path_Bool_Array := (others => (others => False));
      The_Vdcs        : Pwr_Source_Vdc_Array := (others => 0.0);

      Test_1  : Boolean; Test_33 : Boolean; Test_65 : Boolean; Test_97  : Boolean; Test_129 : Boolean;
      Test_2  : Boolean; Test_34 : Boolean; Test_66 : Boolean; Test_98  : Boolean; Test_130 : Boolean;
      Test_3  : Boolean; Test_35 : Boolean; Test_67 : Boolean; Test_99  : Boolean; Test_131 : Boolean;
      Test_4  : Boolean; Test_36 : Boolean; Test_68 : Boolean; Test_100 : Boolean; Test_132 : Boolean;
      Test_5  : Boolean; Test_37 : Boolean; Test_69 : Boolean; Test_101 : Boolean; Test_133 : Boolean;
      Test_6  : Boolean; Test_38 : Boolean; Test_70 : Boolean; Test_102 : Boolean; Test_134 : Boolean;
      Test_7  : Boolean; Test_39 : Boolean; Test_71 : Boolean; Test_103 : Boolean; Test_135 : Boolean;
      Test_8  : Boolean; Test_40 : Boolean; Test_72 : Boolean; Test_104 : Boolean; Test_136 : Boolean;
      Test_9  : Boolean; Test_41 : Boolean; Test_73 : Boolean; Test_105 : Boolean; Test_137 : Boolean;
      Test_10 : Boolean; Test_42 : Boolean; Test_74 : Boolean; Test_106 : Boolean; Test_138 : Boolean;
      Test_11 : Boolean; Test_43 : Boolean; Test_75 : Boolean; Test_107 : Boolean; Test_139 : Boolean;
      Test_12 : Boolean; Test_44 : Boolean; Test_76 : Boolean; Test_108 : Boolean; Test_140 : Boolean;
      Test_13 : Boolean; Test_45 : Boolean; Test_77 : Boolean; Test_109 : Boolean; Test_141 : Boolean;
      Test_14 : Boolean; Test_46 : Boolean; Test_78 : Boolean; Test_110 : Boolean; Test_142 : Boolean;
      Test_15 : Boolean; Test_47 : Boolean; Test_79 : Boolean; Test_111 : Boolean; Test_143 : Boolean;
      Test_16 : Boolean; Test_48 : Boolean; Test_80 : Boolean; Test_112 : Boolean; Test_144 : Boolean;
      Test_17 : Boolean; Test_49 : Boolean; Test_81 : Boolean; Test_113 : Boolean; Test_145 : Boolean;
      Test_18 : Boolean; Test_50 : Boolean; Test_82 : Boolean; Test_114 : Boolean; Test_146 : Boolean;
      Test_19 : Boolean; Test_51 : Boolean; Test_83 : Boolean; Test_115 : Boolean; Test_147 : Boolean;
      Test_20 : Boolean; Test_52 : Boolean; Test_84 : Boolean; Test_116 : Boolean; Test_148 : Boolean;
      Test_21 : Boolean; Test_53 : Boolean; Test_85 : Boolean; Test_117 : Boolean; Test_149 : Boolean;
      Test_22 : Boolean; Test_54 : Boolean; Test_86 : Boolean; Test_118 : Boolean; Test_150 : Boolean;
      Test_23 : Boolean; Test_55 : Boolean; Test_87 : Boolean; Test_119 : Boolean; Test_151 : Boolean;
      Test_24 : Boolean; Test_56 : Boolean; Test_88 : Boolean; Test_120 : Boolean; Test_152 : Boolean;
      Test_25 : Boolean; Test_57 : Boolean; Test_89 : Boolean; Test_121 : Boolean; Test_153 : Boolean;
      Test_26 : Boolean; Test_58 : Boolean; Test_90 : Boolean; Test_122 : Boolean; Test_154 : Boolean;
      Test_27 : Boolean; Test_59 : Boolean; Test_91 : Boolean; Test_123 : Boolean; Test_155 : Boolean;
      Test_28 : Boolean; Test_60 : Boolean; Test_92 : Boolean; Test_124 : Boolean; Test_156 : Boolean;
      Test_29 : Boolean; Test_61 : Boolean; Test_93 : Boolean; Test_125 : Boolean; Test_157 : Boolean;
      Test_30 : Boolean; Test_62 : Boolean; Test_94 : Boolean; Test_126 : Boolean; Test_158 : Boolean;
      Test_31 : Boolean; Test_63 : Boolean; Test_95 : Boolean; Test_127 : Boolean; Test_159 : Boolean;
      Test_32 : Boolean; Test_64 : Boolean; Test_96 : Boolean; Test_128 : Boolean; Test_160 : Boolean;


   begin
      Paths.Initialize (The_Paths);
      Test_1  := not Paths.Is_Complete (The_Paths,Batt,Bus_A);
      Test_2  := not Paths.Is_Complete (The_Paths,Batt,Bus_B);
      Test_3  := not Paths.Is_Complete (The_Paths,Batt,Bus_C);
      Test_4  := not Paths.Is_Complete (The_Paths,Batt,Bus_D);
      Test_5  := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_A);
      Test_6  := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_B);
      Test_7  := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_C);
      Test_8  := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_D);
      Test_9  := not Paths.Is_Complete (The_Paths,Gen,Bus_A);
      Test_10 := not Paths.Is_Complete (The_Paths,Gen,Bus_B);
      Test_11 := not Paths.Is_Complete (The_Paths,Gen,Bus_C);
      Test_12 := not Paths.Is_Complete (The_Paths,Gen,Bus_D);
      Test_13 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_A);
      Test_14 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_B);
      Test_15 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_C);
      Test_16 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_D);
      Test_17 := Paths.Voltage (The_Paths,Batt,Bus_A) = 0.0;
      Test_18 := Paths.Voltage (The_Paths,Batt,Bus_B) = 0.0;
      Test_19 := Paths.Voltage (The_Paths,Batt,Bus_C) = 0.0;
      Test_20 := Paths.Voltage (The_Paths,Batt,Bus_D) = 0.0;
      Test_21 := Paths.Voltage (The_Paths,Aux_Batt,Bus_A) = 0.0;
      Test_22 := Paths.Voltage (The_Paths,Aux_Batt,Bus_B) = 0.0;
      Test_23 := Paths.Voltage (The_Paths,Aux_Batt,Bus_C) = 0.0;
      Test_24 := Paths.Voltage (The_Paths,Aux_Batt,Bus_D) = 0.0;
      Test_25 := Paths.Voltage (The_Paths,Gen,Bus_A) = 0.0;
      Test_26 := Paths.Voltage (The_Paths,Gen,Bus_B) = 0.0;
      Test_27 := Paths.Voltage (The_Paths,Gen,Bus_C) = 0.0;
      Test_28 := Paths.Voltage (The_Paths,Gen,Bus_D) = 0.0;
      Test_29 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_A) = 0.0;
      Test_30 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_B) = 0.0;
      Test_31 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_C) = 0.0;
      Test_32 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_D) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1 , Number => 1 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_2 , Number => 2 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_3 , Number => 3 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_4 , Number => 4 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_5 , Number => 5 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_6 , Number => 6 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_7 , Number => 7 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_8 , Number => 8 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
      Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
      Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
      Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
      Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
      Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
      Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
      Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
      Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
      Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
      Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
      Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
      Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
      Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
      Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
      Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
      Class_Test_Result_File.Report_Case_Status (Success => Test_26, Number => 26);
      Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);
      Class_Test_Result_File.Report_Case_Status (Success => Test_28, Number => 28);
      Class_Test_Result_File.Report_Case_Status (Success => Test_29, Number => 29);
      Class_Test_Result_File.Report_Case_Status (Success => Test_30, Number => 30);
      Class_Test_Result_File.Report_Case_Status (Success => Test_31, Number => 31);
      Class_Test_Result_File.Report_Case_Status (Success => Test_32, Number => 32);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            for Name in Pwr_Source_Name_Type
            loop
               if Name = Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Aux_Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Gen then
                  The_Vdcs (Name) := 28.0;
               end if;
               if Name = Ext_Pwr then
                  The_Vdcs (Name) := 28.0;
               end if;
            end loop;


            for Pwr_Source_Name in Pwr_Source_Name_Type
            loop
               for Bus_Name in Bus_Name_Type
               loop
                  if Pwr_Source_Name = Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
                  if Pwr_Source_Name = Aux_Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
                  if Pwr_Source_Name = Gen then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
                  if Pwr_Source_Name = Ext_Pwr then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
               end loop;
            end loop;

            Paths.Update
              (An_Instance          => The_Paths,
               Path_Is_Complete     => Path_Completion,
               Power_Source_Voltage => The_Vdcs);

            if In_First_Quarter then
               Test_33 := Paths.Is_Complete (The_Paths,Batt,Bus_A);
               Test_34 := Paths.Is_Complete (The_Paths,Batt,Bus_B);
               Test_35 := Paths.Is_Complete (The_Paths,Batt,Bus_C);
               Test_36 := Paths.Is_Complete (The_Paths,Batt,Bus_D);
               Test_37 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_A);
               Test_38 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_B);
               Test_39 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_C);
               Test_40 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_D);
               Test_41 := Paths.Is_Complete (The_Paths,Gen,Bus_A);
               Test_42 := Paths.Is_Complete (The_Paths,Gen,Bus_B);
               Test_43 := Paths.Is_Complete (The_Paths,Gen,Bus_C);
               Test_44 := Paths.Is_Complete (The_Paths,Gen,Bus_D);
               Test_45 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_A);
               Test_46 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_B);
               Test_47 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_C);
               Test_48 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_D);
               Test_49 := Paths.Voltage (The_Paths,Batt,Bus_A) = 24.0;
               Test_50 := Paths.Voltage (The_Paths,Batt,Bus_B) = 24.0;
               Test_51 := Paths.Voltage (The_Paths,Batt,Bus_C) = 24.0;
               Test_52 := Paths.Voltage (The_Paths,Batt,Bus_D) = 24.0;
               Test_53 := Paths.Voltage (The_Paths,Aux_Batt,Bus_A) = 24.0;
               Test_54 := Paths.Voltage (The_Paths,Aux_Batt,Bus_B) = 24.0;
               Test_55 := Paths.Voltage (The_Paths,Aux_Batt,Bus_C) = 24.0;
               Test_56 := Paths.Voltage (The_Paths,Aux_Batt,Bus_D) = 24.0;
               Test_57 := Paths.Voltage (The_Paths,Gen,Bus_A) = 28.0;
               Test_58 := Paths.Voltage (The_Paths,Gen,Bus_B) = 28.0;
               Test_59 := Paths.Voltage (The_Paths,Gen,Bus_C) = 28.0;
               Test_60 := Paths.Voltage (The_Paths,Gen,Bus_D) = 28.0;
               Test_61 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_A) = 28.0;
               Test_62 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_B) = 28.0;
               Test_63 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_C) = 28.0;
               Test_64 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_D) = 28.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_33, Number => 33);
               Class_Test_Result_File.Report_Case_Status (Success => Test_34, Number => 34);
               Class_Test_Result_File.Report_Case_Status (Success => Test_35, Number => 35);
               Class_Test_Result_File.Report_Case_Status (Success => Test_36, Number => 36);
               Class_Test_Result_File.Report_Case_Status (Success => Test_37, Number => 37);
               Class_Test_Result_File.Report_Case_Status (Success => Test_38, Number => 38);
               Class_Test_Result_File.Report_Case_Status (Success => Test_39, Number => 39);
               Class_Test_Result_File.Report_Case_Status (Success => Test_40, Number => 40);
               Class_Test_Result_File.Report_Case_Status (Success => Test_41, Number => 41);
               Class_Test_Result_File.Report_Case_Status (Success => Test_42, Number => 42);
               Class_Test_Result_File.Report_Case_Status (Success => Test_43, Number => 43);
               Class_Test_Result_File.Report_Case_Status (Success => Test_44, Number => 44);
               Class_Test_Result_File.Report_Case_Status (Success => Test_45, Number => 45);
               Class_Test_Result_File.Report_Case_Status (Success => Test_46, Number => 46);
               Class_Test_Result_File.Report_Case_Status (Success => Test_47, Number => 47);
               Class_Test_Result_File.Report_Case_Status (Success => Test_48, Number => 48);
               Class_Test_Result_File.Report_Case_Status (Success => Test_49, Number => 49);
               Class_Test_Result_File.Report_Case_Status (Success => Test_50, Number => 50);
               Class_Test_Result_File.Report_Case_Status (Success => Test_51, Number => 51);
               Class_Test_Result_File.Report_Case_Status (Success => Test_52, Number => 52);
               Class_Test_Result_File.Report_Case_Status (Success => Test_53, Number => 53);
               Class_Test_Result_File.Report_Case_Status (Success => Test_54, Number => 54);
               Class_Test_Result_File.Report_Case_Status (Success => Test_55, Number => 55);
               Class_Test_Result_File.Report_Case_Status (Success => Test_56, Number => 56);
               Class_Test_Result_File.Report_Case_Status (Success => Test_57, Number => 57);
               Class_Test_Result_File.Report_Case_Status (Success => Test_58, Number => 58);
               Class_Test_Result_File.Report_Case_Status (Success => Test_59, Number => 59);
               Class_Test_Result_File.Report_Case_Status (Success => Test_60, Number => 60);
               Class_Test_Result_File.Report_Case_Status (Success => Test_61, Number => 61);
               Class_Test_Result_File.Report_Case_Status (Success => Test_62, Number => 62);
               Class_Test_Result_File.Report_Case_Status (Success => Test_63, Number => 63);
               Class_Test_Result_File.Report_Case_Status (Success => Test_64, Number => 64);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            for Name in Pwr_Source_Name_Type
            loop
               if Name = Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Aux_Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Gen then
                  The_Vdcs (Name) := 28.0;
               end if;
               if Name = Ext_Pwr then
                  The_Vdcs (Name) := 28.0;
               end if;
            end loop;


            for Pwr_Source_Name in Pwr_Source_Name_Type
            loop
               for Bus_Name in Bus_Name_Type
               loop
                  if Pwr_Source_Name = Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
                  if Pwr_Source_Name = Aux_Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
                  if Pwr_Source_Name = Gen then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
                  if Pwr_Source_Name = Ext_Pwr then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
               end loop;
            end loop;

            Paths.Update
              (An_Instance          => The_Paths,
               Path_Is_Complete     => Path_Completion,
               Power_Source_Voltage => The_Vdcs);

            if In_Second_Quarter then
               Test_65 := not Paths.Is_Complete (The_Paths,Batt,Bus_A);
               Test_66 := not Paths.Is_Complete (The_Paths,Batt,Bus_B);
               Test_67 := not Paths.Is_Complete (The_Paths,Batt,Bus_C);
               Test_68 := not Paths.Is_Complete (The_Paths,Batt,Bus_D);
               Test_69 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_A);
               Test_70 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_B);
               Test_71 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_C);
               Test_72 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_D);
               Test_73 := not Paths.Is_Complete (The_Paths,Gen,Bus_A);
               Test_74 := Paths.Is_Complete (The_Paths,Gen,Bus_B);
               Test_75 := not Paths.Is_Complete (The_Paths,Gen,Bus_C);
               Test_76 := Paths.Is_Complete (The_Paths,Gen,Bus_D);
               Test_77 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_A);
               Test_78 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_B);
               Test_79 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_C);
               Test_80 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_D);
               Test_81 := Paths.Voltage (The_Paths,Batt,Bus_A) = 0.0;
               Test_82 := Paths.Voltage (The_Paths,Batt,Bus_B) = 0.0;
               Test_83 := Paths.Voltage (The_Paths,Batt,Bus_C) = 0.0;
               Test_84 := Paths.Voltage (The_Paths,Batt,Bus_D) = 0.0;
               Test_85 := Paths.Voltage (The_Paths,Aux_Batt,Bus_A) = 24.0;
               Test_86 := Paths.Voltage (The_Paths,Aux_Batt,Bus_B) = 0.0;
               Test_87 := Paths.Voltage (The_Paths,Aux_Batt,Bus_C) = 24.0;
               Test_88 := Paths.Voltage (The_Paths,Aux_Batt,Bus_D) = 0.0;
               Test_89 := Paths.Voltage (The_Paths,Gen,Bus_A) = 0.0;
               Test_90 := Paths.Voltage (The_Paths,Gen,Bus_B) = 28.0;
               Test_91 := Paths.Voltage (The_Paths,Gen,Bus_C) = 0.0;
               Test_92 := Paths.Voltage (The_Paths,Gen,Bus_D) = 28.0;
               Test_93 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_A) = 0.0;
               Test_94 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_B) = 28.0;
               Test_95 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_C) = 28.0;
               Test_96 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_D) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_65, Number => 65);
               Class_Test_Result_File.Report_Case_Status (Success => Test_66, Number => 66);
               Class_Test_Result_File.Report_Case_Status (Success => Test_67, Number => 67);
               Class_Test_Result_File.Report_Case_Status (Success => Test_68, Number => 68);
               Class_Test_Result_File.Report_Case_Status (Success => Test_69, Number => 69);
               Class_Test_Result_File.Report_Case_Status (Success => Test_70, Number => 70);
               Class_Test_Result_File.Report_Case_Status (Success => Test_71, Number => 71);
               Class_Test_Result_File.Report_Case_Status (Success => Test_72, Number => 72);
               Class_Test_Result_File.Report_Case_Status (Success => Test_73, Number => 73);
               Class_Test_Result_File.Report_Case_Status (Success => Test_74, Number => 74);
               Class_Test_Result_File.Report_Case_Status (Success => Test_75, Number => 75);
               Class_Test_Result_File.Report_Case_Status (Success => Test_76, Number => 76);
               Class_Test_Result_File.Report_Case_Status (Success => Test_77, Number => 77);
               Class_Test_Result_File.Report_Case_Status (Success => Test_78, Number => 78);
               Class_Test_Result_File.Report_Case_Status (Success => Test_79, Number => 79);
               Class_Test_Result_File.Report_Case_Status (Success => Test_80, Number => 80);
               Class_Test_Result_File.Report_Case_Status (Success => Test_81, Number => 81);
               Class_Test_Result_File.Report_Case_Status (Success => Test_82, Number => 82);
               Class_Test_Result_File.Report_Case_Status (Success => Test_83, Number => 83);
               Class_Test_Result_File.Report_Case_Status (Success => Test_84, Number => 84);
               Class_Test_Result_File.Report_Case_Status (Success => Test_85, Number => 85);
               Class_Test_Result_File.Report_Case_Status (Success => Test_86, Number => 86);
               Class_Test_Result_File.Report_Case_Status (Success => Test_87, Number => 87);
               Class_Test_Result_File.Report_Case_Status (Success => Test_88, Number => 88);
               Class_Test_Result_File.Report_Case_Status (Success => Test_89, Number => 89);
               Class_Test_Result_File.Report_Case_Status (Success => Test_90, Number => 90);
               Class_Test_Result_File.Report_Case_Status (Success => Test_91, Number => 91);
               Class_Test_Result_File.Report_Case_Status (Success => Test_92, Number => 92);
               Class_Test_Result_File.Report_Case_Status (Success => Test_93, Number => 93);
               Class_Test_Result_File.Report_Case_Status (Success => Test_94, Number => 94);
               Class_Test_Result_File.Report_Case_Status (Success => Test_95, Number => 95);
               Class_Test_Result_File.Report_Case_Status (Success => Test_96, Number => 96);
            end if;
            In_Second_Quarter := False;

         elsif Now < Three_Quarter_Time then

            for Name in Pwr_Source_Name_Type
            loop
               if Name = Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Aux_Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Gen then
                  The_Vdcs (Name) := 28.0;
               end if;
               if Name = Ext_Pwr then
                  The_Vdcs (Name) := 28.0;
               end if;
            end loop;


            for Pwr_Source_Name in Pwr_Source_Name_Type
            loop
               for Bus_Name in Bus_Name_Type
               loop
                  if Pwr_Source_Name = Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
                  if Pwr_Source_Name = Aux_Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
                  if Pwr_Source_Name = Gen then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
                  if Pwr_Source_Name = Ext_Pwr then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := True;
                     end if;
                  end if;
               end loop;
            end loop;

            Paths.Update
              (An_Instance          => The_Paths,
               Path_Is_Complete     => Path_Completion,
               Power_Source_Voltage => The_Vdcs);

            if In_Third_Quarter then
               Test_97  := Paths.Is_Complete (The_Paths,Batt,Bus_A);
               Test_98  := Paths.Is_Complete (The_Paths,Batt,Bus_B);
               Test_99  := Paths.Is_Complete (The_Paths,Batt,Bus_C);
               Test_100 := Paths.Is_Complete (The_Paths,Batt,Bus_D);
               Test_101 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_A);
               Test_102 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_B);
               Test_103 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_C);
               Test_104 := Paths.Is_Complete (The_Paths,Aux_Batt,Bus_D);
               Test_105 := Paths.Is_Complete (The_Paths,Gen,Bus_A);
               Test_106 := not Paths.Is_Complete (The_Paths,Gen,Bus_B);
               Test_107 := Paths.Is_Complete (The_Paths,Gen,Bus_C);
               Test_108 := not Paths.Is_Complete (The_Paths,Gen,Bus_D);
               Test_109 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_A);
               Test_110 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_B);
               Test_111 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_C);
               Test_112 := Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_D);
               Test_113 := Paths.Voltage (The_Paths,Batt,Bus_A) = 24.0;
               Test_114 := Paths.Voltage (The_Paths,Batt,Bus_B) = 24.0;
               Test_115 := Paths.Voltage (The_Paths,Batt,Bus_C) = 24.0;
               Test_116 := Paths.Voltage (The_Paths,Batt,Bus_D) = 24.0;
               Test_117 := Paths.Voltage (The_Paths,Aux_Batt,Bus_A) = 0.0;
               Test_118 := Paths.Voltage (The_Paths,Aux_Batt,Bus_B) = 24.0;
               Test_119 := Paths.Voltage (The_Paths,Aux_Batt,Bus_C) = 0.0;
               Test_120 := Paths.Voltage (The_Paths,Aux_Batt,Bus_D) = 24.0;
               Test_121 := Paths.Voltage (The_Paths,Gen,Bus_A) = 28.0;
               Test_122 := Paths.Voltage (The_Paths,Gen,Bus_B) = 0.0;
               Test_123 := Paths.Voltage (The_Paths,Gen,Bus_C) = 28.0;
               Test_124 := Paths.Voltage (The_Paths,Gen,Bus_D) = 0.0;
               Test_125 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_A) = 28.0;
               Test_126 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_B) = 0.0;
               Test_127 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_C) = 0.0;
               Test_128 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_D) = 28.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_97 , Number => 97 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_98 , Number => 98 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_99 , Number => 99 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_100, Number => 100);
               Class_Test_Result_File.Report_Case_Status (Success => Test_101, Number => 101);
               Class_Test_Result_File.Report_Case_Status (Success => Test_102, Number => 102);
               Class_Test_Result_File.Report_Case_Status (Success => Test_103, Number => 103);
               Class_Test_Result_File.Report_Case_Status (Success => Test_104, Number => 104);
               Class_Test_Result_File.Report_Case_Status (Success => Test_105, Number => 105);
               Class_Test_Result_File.Report_Case_Status (Success => Test_106, Number => 106);
               Class_Test_Result_File.Report_Case_Status (Success => Test_107, Number => 107);
               Class_Test_Result_File.Report_Case_Status (Success => Test_108, Number => 108);
               Class_Test_Result_File.Report_Case_Status (Success => Test_109, Number => 109);
               Class_Test_Result_File.Report_Case_Status (Success => Test_110, Number => 110);
               Class_Test_Result_File.Report_Case_Status (Success => Test_111, Number => 111);
               Class_Test_Result_File.Report_Case_Status (Success => Test_112, Number => 112);
               Class_Test_Result_File.Report_Case_Status (Success => Test_113, Number => 113);
               Class_Test_Result_File.Report_Case_Status (Success => Test_114, Number => 114);
               Class_Test_Result_File.Report_Case_Status (Success => Test_115, Number => 115);
               Class_Test_Result_File.Report_Case_Status (Success => Test_116, Number => 116);
               Class_Test_Result_File.Report_Case_Status (Success => Test_117, Number => 117);
               Class_Test_Result_File.Report_Case_Status (Success => Test_118, Number => 118);
               Class_Test_Result_File.Report_Case_Status (Success => Test_119, Number => 119);
               Class_Test_Result_File.Report_Case_Status (Success => Test_120, Number => 120);
               Class_Test_Result_File.Report_Case_Status (Success => Test_121, Number => 121);
               Class_Test_Result_File.Report_Case_Status (Success => Test_122, Number => 122);
               Class_Test_Result_File.Report_Case_Status (Success => Test_123, Number => 123);
               Class_Test_Result_File.Report_Case_Status (Success => Test_124, Number => 124);
               Class_Test_Result_File.Report_Case_Status (Success => Test_125, Number => 125);
               Class_Test_Result_File.Report_Case_Status (Success => Test_126, Number => 126);
               Class_Test_Result_File.Report_Case_Status (Success => Test_127, Number => 127);
               Class_Test_Result_File.Report_Case_Status (Success => Test_128, Number => 128);
            end if;
            In_Third_Quarter := False;

         else

            for Name in Pwr_Source_Name_Type
            loop
               if Name = Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Aux_Batt then
                  The_Vdcs (Name) := 24.0;
               end if;
               if Name = Gen then
                  The_Vdcs (Name) := 28.0;
               end if;
               if Name = Ext_Pwr then
                  The_Vdcs (Name) := 28.0;
               end if;
            end loop;


            for Pwr_Source_Name in Pwr_Source_Name_Type
            loop
               for Bus_Name in Bus_Name_Type
               loop
                  if Pwr_Source_Name = Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
                  if Pwr_Source_Name = Aux_Batt then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
                  if Pwr_Source_Name = Gen then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
                  if Pwr_Source_Name = Ext_Pwr then
                     if Bus_Name = Bus_A then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_B then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_C then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                     if Bus_Name = Bus_D then
                        Path_Completion (Pwr_Source_Name,Bus_Name) := False;
                     end if;
                  end if;
               end loop;
            end loop;

            Paths.Update
              (An_Instance          => The_Paths,
               Path_Is_Complete     => Path_Completion,
               Power_Source_Voltage => The_Vdcs);

            if In_Fourth_Quarter then
               Test_129 := not Paths.Is_Complete (The_Paths,Batt,Bus_A);
               Test_130 := not Paths.Is_Complete (The_Paths,Batt,Bus_B);
               Test_131 := not Paths.Is_Complete (The_Paths,Batt,Bus_C);
               Test_132 := not Paths.Is_Complete (The_Paths,Batt,Bus_D);
               Test_133 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_A);
               Test_134 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_B);
               Test_135 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_C);
               Test_136 := not Paths.Is_Complete (The_Paths,Aux_Batt,Bus_D);
               Test_137 := not Paths.Is_Complete (The_Paths,Gen,Bus_A);
               Test_138 := not Paths.Is_Complete (The_Paths,Gen,Bus_B);
               Test_139 := not Paths.Is_Complete (The_Paths,Gen,Bus_C);
               Test_140 := not Paths.Is_Complete (The_Paths,Gen,Bus_D);
               Test_141 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_A);
               Test_142 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_B);
               Test_143 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_C);
               Test_144 := not Paths.Is_Complete (The_Paths,Ext_Pwr,Bus_D);
               Test_145 := Paths.Voltage (The_Paths,Batt,Bus_A) = 0.0;
               Test_146 := Paths.Voltage (The_Paths,Batt,Bus_B) = 0.0;
               Test_147 := Paths.Voltage (The_Paths,Batt,Bus_C) = 0.0;
               Test_148 := Paths.Voltage (The_Paths,Batt,Bus_D) = 0.0;
               Test_149 := Paths.Voltage (The_Paths,Aux_Batt,Bus_A) = 0.0;
               Test_150 := Paths.Voltage (The_Paths,Aux_Batt,Bus_B) = 0.0;
               Test_151 := Paths.Voltage (The_Paths,Aux_Batt,Bus_C) = 0.0;
               Test_152 := Paths.Voltage (The_Paths,Aux_Batt,Bus_D) = 0.0;
               Test_153 := Paths.Voltage (The_Paths,Gen,Bus_A) = 0.0;
               Test_154 := Paths.Voltage (The_Paths,Gen,Bus_B) = 0.0;
               Test_155 := Paths.Voltage (The_Paths,Gen,Bus_C) = 0.0;
               Test_156 := Paths.Voltage (The_Paths,Gen,Bus_D) = 0.0;
               Test_157 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_A) = 0.0;
               Test_158 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_B) = 0.0;
               Test_159 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_C) = 0.0;
               Test_160 := Paths.Voltage (The_Paths,Ext_Pwr,Bus_D) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_129, Number => 129);
               Class_Test_Result_File.Report_Case_Status (Success => Test_130, Number => 130);
               Class_Test_Result_File.Report_Case_Status (Success => Test_131, Number => 131);
               Class_Test_Result_File.Report_Case_Status (Success => Test_132, Number => 132);
               Class_Test_Result_File.Report_Case_Status (Success => Test_133, Number => 133);
               Class_Test_Result_File.Report_Case_Status (Success => Test_134, Number => 134);
               Class_Test_Result_File.Report_Case_Status (Success => Test_135, Number => 135);
               Class_Test_Result_File.Report_Case_Status (Success => Test_136, Number => 136);
               Class_Test_Result_File.Report_Case_Status (Success => Test_137, Number => 137);
               Class_Test_Result_File.Report_Case_Status (Success => Test_138, Number => 138);
               Class_Test_Result_File.Report_Case_Status (Success => Test_139, Number => 139);
               Class_Test_Result_File.Report_Case_Status (Success => Test_140, Number => 140);
               Class_Test_Result_File.Report_Case_Status (Success => Test_141, Number => 141);
               Class_Test_Result_File.Report_Case_Status (Success => Test_142, Number => 142);
               Class_Test_Result_File.Report_Case_Status (Success => Test_143, Number => 143);
               Class_Test_Result_File.Report_Case_Status (Success => Test_144, Number => 144);
               Class_Test_Result_File.Report_Case_Status (Success => Test_145, Number => 145);
               Class_Test_Result_File.Report_Case_Status (Success => Test_146, Number => 146);
               Class_Test_Result_File.Report_Case_Status (Success => Test_147, Number => 147);
               Class_Test_Result_File.Report_Case_Status (Success => Test_148, Number => 148);
               Class_Test_Result_File.Report_Case_Status (Success => Test_149, Number => 149);
               Class_Test_Result_File.Report_Case_Status (Success => Test_150, Number => 150);
               Class_Test_Result_File.Report_Case_Status (Success => Test_151, Number => 151);
               Class_Test_Result_File.Report_Case_Status (Success => Test_152, Number => 152);
               Class_Test_Result_File.Report_Case_Status (Success => Test_153, Number => 153);
               Class_Test_Result_File.Report_Case_Status (Success => Test_154, Number => 154);
               Class_Test_Result_File.Report_Case_Status (Success => Test_155, Number => 155);
               Class_Test_Result_File.Report_Case_Status (Success => Test_156, Number => 156);
               Class_Test_Result_File.Report_Case_Status (Success => Test_157, Number => 157);
               Class_Test_Result_File.Report_Case_Status (Success => Test_158, Number => 158);
               Class_Test_Result_File.Report_Case_Status (Success => Test_159, Number => 159);
               Class_Test_Result_File.Report_Case_Status (Success => Test_160, Number => 160);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;


   end;


end Path_Collection_G_Ctd;
