-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Electrical.Relay_Controller;
with Jpats_Electrical.Power_Supply_Controller;
with Jpats_Electrical.Container;
with Jpats_Electrical_Types;

procedure Jpats_Electrical.Relay_Controller_Ctd is


   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr renames Container;
   package Ele_T renames Jpats_Electrical_Types;
   package Relays renames Ctnr.Coil_Relay_Collection;

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;
   The_Cbs : Ctnr.Circuit_Breaker_Collection.Instance renames Ctnr.This_Subsystem.The_Circuit_Breakers;
begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..10) := (others => false);
begin
   Relay_Controller.Initialize;

   Test_Case_1 (1)  := (Relays.Is_Open (The_Relays, Ele_T.Battery_Relay)                      and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Battery_Relay));
   Test_Case_1 (2)  := (Relays.Is_Open (The_Relays, Ele_T.Generator_Relay)                    and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Generator_Relay));
   Test_Case_1 (3)  := (Relays.Is_Open (The_Relays, Ele_T.Generator_On_Relay)                 and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Generator_On_Relay));
   Test_Case_1 (4)  := (Relays.Is_Open (The_Relays, Ele_T.Bus_Tie_Relay)                      and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Bus_Tie_Relay));
   Test_Case_1 (5)  := (Relays.Is_Open (The_Relays, Ele_T.Avionics_Master_Battery_Relay)      and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Avionics_Master_Battery_Relay));
   Test_Case_1 (6)  := (Relays.Is_Open (The_Relays, Ele_T.Avionics_Master_Generator_Relay)    and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Avionics_Master_Generator_Relay));
   Test_Case_1 (7)  := (Relays.Is_Open (The_Relays, Ele_T.Starter_On_Relay)                   and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Starter_On_Relay));
   Test_Case_1 (8)  := (Relays.Is_Open (The_Relays, Ele_T.External_Power_Relay)               and
                        not  Relays.Is_Closed (The_Relays, Ele_T.External_Power_Relay));
   Test_Case_1 (9)  := (Relays.Is_Open (The_Relays, Ele_T.Auxiliary_Battery_Relay)            and
                        not  Relays.Is_Closed (The_Relays, Ele_T.Auxiliary_Battery_Relay));
   Test_Case_1 (10) := (Relays.Is_Open (The_Relays, Ele_T.External_Power_Voltage_Sense_Relay) and
                        not  Relays.Is_Closed (The_Relays, Ele_T.External_Power_Voltage_Sense_Relay));

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;


Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..1) := (others => false);
   Iconst : constant Float := 0.0666667;
begin
   Relay_Controller.Initialize;
   Power_Supply_Controller.Initialize;
   Io.Master_Bat_On_Sw := True;
   Ctnr.Circuit_Breaker_Collection.Power (The_Cbs);
--   Ctnr.Coil_Relay_Collection.Close_Relay (The_Relays,Ele_T.Battery_Relay);
   for I in 1..1000 loop
      Relay_Controller.Update (Iconst);
   end loop;
   Test_Case_2 (1) := Relays.Is_Closed (The_Relays, Ele_T.Battery_Relay);
   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Electrical.Relay_Controller_Ctd;
