-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Electrical.Power_Supply_Controller;
with Jpats_Electrical.Container;
with Jpats_Electrical_Types;
with Electrical_Units_Types;
with Power_Supply;
with Power_Supply.Battery;
with Power_Supply.Auxiliary_Battery;
with Power_Supply.Generator;
with Power_Supply.External_Power;

procedure Jpats_Electrical.Power_Supply_Controller_Ctd is


   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr     renames Container;
   package Ele      renames Jpats_Electrical_Types;
   package Ele_U    renames Electrical_Units_Types;
   package Batt     renames Power_Supply.Battery;
   package Gen      renames Power_Supply.Generator;
   package Aux_Batt renames Power_Supply.Auxiliary_Battery;
   package Ext_Pwr  renames Power_Supply.External_Power;
   package Buses    renames Ctnr.Bus_Collection;
   package Paths    renames Ctnr.Path_Collection;
   package Gcu          renames Ctnr.Generator_Control_Unit;
   package Aux_Batt_Mnt renames Ctnr.Auxiliary_Battery_Mount;
   package Pwr_Supp     renames Power_Supply;
   package Cbs          renames Ctnr.Circuit_Breaker_Collection;

   The_Batt     : Batt.Instance     renames Ctnr.This_Subsystem.The_Battery;
   The_Gen      : Gen.Instance      renames Ctnr.This_Subsystem.The_Generator;
   The_Aux_Batt : Aux_Batt.Instance renames Ctnr.This_Subsystem.The_Auxiliary_Battery;
   The_Ext_Pwr  : Ext_Pwr.Instance  renames Ctnr.This_Subsystem.The_External_Power;
   The_Gcu          : Gcu.Instance          renames Ctnr.This_Subsystem.The_Generator_Control_Unit;
   The_Aux_Batt_Mnt : Aux_Batt_Mnt.Instance renames Ctnr.This_Subsystem.The_Auxiliary_Battery_Mount;
   The_Buses : Buses.Instance renames Ctnr.This_Subsystem.The_Buses;
   The_Paths : Paths.Instance renames Ctnr.This_Subsystem.The_Paths;
   The_Cbs : Cbs.Instance renames Ctnr.This_Subsystem.The_Circuit_Breakers;

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..21) := (others => false);
begin
   Power_Supply_Controller.Initialize;

   Test_Case_1 (1)  := not Batt.Is_Charging (The_Batt);
   Test_Case_1 (2)  := Pwr_Supp.Voltage (The_Batt) = 24.0;
   Test_Case_1 (3)  := Pwr_Supp.Load (The_Batt) = 0.0;
   Test_Case_1 (4)  := Pwr_Supp.Power_Available (The_Batt);
   Test_Case_1 (5)  := Gen.Starter_Load (The_Gen) = 0.0;
   Test_Case_1 (6)  := Gen.Torque (The_Gen) = 0.0;
   Test_Case_1 (7)  := Pwr_Supp.Voltage (The_Gen) = 0.0;
   Test_Case_1 (8)  := Pwr_Supp.Load (The_Gen) = 0.0;
   Test_Case_1 (9)  := not Pwr_Supp.Power_Available (The_Gen);
   Test_Case_1 (10) := not Aux_Batt.Is_Charging (The_Aux_Batt);
   Test_Case_1 (11) := Pwr_Supp.Voltage (The_Aux_Batt) = 24.0;
   Test_Case_1 (12) := Pwr_Supp.Load (The_Aux_Batt) = 0.0;
   Test_Case_1 (13) := Pwr_Supp.Power_Available (The_Aux_Batt);
   Test_Case_1 (14) := Pwr_Supp.Voltage (The_Ext_Pwr) = 0.0;
   Test_Case_1 (15) := Pwr_Supp.Load (The_Ext_Pwr) = 0.0;
   Test_Case_1 (16) := not Pwr_Supp.Power_Available (The_Ext_Pwr);
   Test_Case_1 (17) := not Gcu.Line_Control (The_Gcu);
   Test_Case_1 (18) := not Aux_Batt_Mnt.Lights_Out (The_Aux_Batt_Mnt);
   Test_Case_1 (19) := Aux_Batt_Mnt.Voltage_Out (The_Aux_Batt_Mnt) = 0.0;
   Test_Case_1 (20) := Aux_Batt_Mnt.Voltage_In (The_Aux_Batt_Mnt) = 0.0;
   Test_Case_1 (21) := not Aux_Batt_Mnt.Is_Powered (The_Aux_Batt_Mnt);

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;


Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..1) := (others => false);
   Iconst : constant Float := 0.0666667;
begin
   Power_Supply_Controller.Initialize;
   Io.Master_Bat_On_Sw := True;
   Cbs.Power (The_Cbs);
   Ios.The_Gpu_Connector_In := True;
   Ios.The_Gpu_Power_On := True;
   for I in 1..1000 loop
      Power_Supply_Controller.Update (Iconst);
   end loop;
   Test_Case_2 (1) := Pwr_Supp.Voltage (The_Ext_Pwr) = 28.25;
   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Electrical.Power_Supply_Controller_Ctd;
