-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Electrical.Circuit_Breaker_Controller;
with Jpats_Electrical.Power_Supply_Controller;
with Jpats_Electrical.Container;
with Jpats_Electrical_Types;

procedure Jpats_Electrical.Circuit_Breaker_Controller_Ctd is


   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr renames Container;
   package Ele_T renames Jpats_Electrical_Types;
   package Relays renames Ctnr.Coil_Relay_Collection;
   package Cbs renames Ctnr.Circuit_Breaker_Collection;
   package Buses renames Ctnr.Bus_Collection;


   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;

   The_Cbs : Cbs.Instance renames Ctnr.This_Subsystem.The_Circuit_Breakers;
   The_Buses : Buses.Instance renames Ctnr.This_Subsystem.The_Buses;
begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..114) := (others => false);
begin
   Circuit_Breaker_Controller.Initialize;

   Test_Case_1 (1) := not Cbs.Is_Powered (The_Cbs, Ele_T.Bus_Tie_Control_Cb);
   Test_Case_1 (2) := not Cbs.Is_Powered (The_Cbs, Ele_T.Generator_Sense_Cb);
   Test_Case_1 (3) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ext_Pwr_Cb);
   Test_Case_1 (4) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aux_Batt_Cb);
   Test_Case_1 (5) := not Cbs.Is_Powered (The_Cbs, Ele_T.Cond_Blower_Cb);
   Test_Case_1 (6) := not Cbs.Is_Powered (The_Cbs, Ele_T.Heat_Exch_Blower_Cb);
   Test_Case_1 (7) := not Cbs.Is_Powered (The_Cbs, Ele_T.Bus_Sense_Cb);
   Test_Case_1 (8) := not Cbs.Is_Powered (The_Cbs, Ele_T.Spare_Cb);
   Test_Case_1 (9) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ram_Air_Valve_Cb);
   Test_Case_1 (10) := not Cbs.Is_Powered (The_Cbs, Ele_T.Battery_Cb);
   Test_Case_1 (11) := not Cbs.Is_Powered (The_Cbs, Ele_T.Emerg_Flaps_Cb);
   Test_Case_1 (12) := not Cbs.Is_Powered (The_Cbs, Ele_T.Clocks_Cb);
   Test_Case_1 (13) := not Cbs.Is_Powered (The_Cbs, Ele_T.Elt_Cb);
   Test_Case_1 (14) := not Cbs.Is_Powered (The_Cbs, Ele_T.Obogs_Cb);
   Test_Case_1 (15) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fdr_Maint_Epa_Fuel_Pump_Cb);
   Test_Case_1 (16) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ail_El_Trim_Cb);
   Test_Case_1 (17) := not Cbs.Is_Powered (The_Cbs, Ele_T.Rud_Trim_Cb);
   Test_Case_1 (18) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ldg_Gr_Cont_Cb);
   Test_Case_1 (19) := not Cbs.Is_Powered (The_Cbs, Ele_T.Flap_Cont_Cb);
   Test_Case_1 (20) := not Cbs.Is_Powered (The_Cbs, Ele_T.Util_Lt_Cb);
   Test_Case_1 (21) := not Cbs.Is_Powered (The_Cbs, Ele_T.Coll_Lts_Cb);
   Test_Case_1 (22) := not Cbs.Is_Powered (The_Cbs, Ele_T.Inst_Lts_Cb);
   Test_Case_1 (23) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ldg_Lts_Cb);
   Test_Case_1 (24) := not Cbs.Is_Powered (The_Cbs, Ele_T.Cws_Cb_Fwd_Batt_Bus);
   Test_Case_1 (25) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fuel_Qty_Lo_Cb);
   Test_Case_1 (26) := not Cbs.Is_Powered (The_Cbs, Ele_T.Pmu_Cb);
   Test_Case_1 (27) := not Cbs.Is_Powered (The_Cbs, Ele_T.Boost_Pump_Cb);
   Test_Case_1 (28) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ign_Cb);
   Test_Case_1 (29) := not Cbs.Is_Powered (The_Cbs, Ele_T.Start_Cb);
   Test_Case_1 (30) := not Cbs.Is_Powered (The_Cbs, Ele_T.Oil_Trx_Cb);
   Test_Case_1 (31) := not Cbs.Is_Powered (The_Cbs, Ele_T.Batt_Sw_Cb);
   Test_Case_1 (32) := not Cbs.Is_Powered (The_Cbs, Ele_T.Avi_Mstr_Cb);
   Test_Case_1 (33) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fld_Lts_Cb);
   Test_Case_1 (34) := not Cbs.Is_Powered (The_Cbs, Ele_T.Alt_Eng_Dis_Cb);
   Test_Case_1 (35) := not Cbs.Is_Powered (The_Cbs, Ele_T.Edm_Cb_Fwd_Batt_Bus);
   Test_Case_1 (36) := not Cbs.Is_Powered (The_Cbs, Ele_T.Prop_Sys_Cb);
   Test_Case_1 (37) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fdr_Cb);
   Test_Case_1 (38) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aoa_Cb);
   Test_Case_1 (39) := not Cbs.Is_Powered (The_Cbs, Ele_T.Inflow_Sys_Cb);
   Test_Case_1 (40) := not Cbs.Is_Powered (The_Cbs, Ele_T.Hyd_Sys_Cb);
   Test_Case_1 (41) := not Cbs.Is_Powered (The_Cbs, Ele_T.Audio_Cb);
   Test_Case_1 (42) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aft_Battery_Cb);
   Test_Case_1 (43) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aux_Battery_Cb);
   Test_Case_1 (44) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fwd_Avi_Cb_Fwd_Batt_Bus);
   Test_Case_1 (45) := not Cbs.Is_Powered (The_Cbs, Ele_T.Eadi_Cb);
   Test_Case_1 (46) := not Cbs.Is_Powered (The_Cbs, Ele_T.Gps_Cb);
   Test_Case_1 (47) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ahrs_Cb);
   Test_Case_1 (48) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aft_Avi_Cb_Fwd_Avi_Batt_Bus);
   Test_Case_1 (49) := not Cbs.Is_Powered (The_Cbs, Ele_T.Eadi_Cb_Aft_Avi_Batt_Bus);
   Test_Case_1 (50) := not Cbs.Is_Powered (The_Cbs, Ele_T.Alt_Eng_Dis_Cb_Aft_Batt_Bus);
   Test_Case_1 (51) := not Cbs.Is_Powered (The_Cbs, Ele_T.Audio_Cb_Aft_Batt_Bus);
   Test_Case_1 (52) := not Cbs.Is_Powered (The_Cbs, Ele_T.Util_Lt_Cb_Aft_Batt_Bus);
   Test_Case_1 (53) := not Cbs.Is_Powered (The_Cbs, Ele_T.Inst_Lts_Cb_Aft_Batt_Bus);
   Test_Case_1 (54) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fld_Lts_Cb_Aft_Batt_Bus);
   Test_Case_1 (55) := not Cbs.Is_Powered (The_Cbs, Ele_T.Altm_Cb_Aft_Aux_Batt_Bus);
   Test_Case_1 (56) := not Cbs.Is_Powered (The_Cbs, Ele_T.Gyro_Cb_Aft_Aux_Batt_Bus);
   Test_Case_1 (57) := not Cbs.Is_Powered (The_Cbs, Ele_T.Trn_Rt_Cb_Aft_Aux_Batt_Bus);
   Test_Case_1 (58) := not Cbs.Is_Powered (The_Cbs, Ele_T.Gyro_Cb);
   Test_Case_1 (59) := not Cbs.Is_Powered (The_Cbs, Ele_T.Altm_Cb_Fwd_Aux_Batt_Bus);
   Test_Case_1 (60) := not Cbs.Is_Powered (The_Cbs, Ele_T.Trn_Rt_Cb);
   Test_Case_1 (61) := not Cbs.Is_Powered (The_Cbs, Ele_T.Uhf_Comm_Cb);
   Test_Case_1 (62) := not Cbs.Is_Powered (The_Cbs, Ele_T.Radio_Rlys_Cb_Fwd_Aux_Batt_Bus);
   Test_Case_1 (63) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fire_Detect_Cb_Fwd_Aux_Batt_Bus);
   Test_Case_1 (64) := not Cbs.Is_Powered (The_Cbs, Ele_T.Stby_Lts_Cb);
   Test_Case_1 (65) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aft_Stby_Cb);
   Test_Case_1 (66) := not Cbs.Is_Powered (The_Cbs, Ele_T.Air_Cond_Cb);
   Test_Case_1 (67) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ckpt_Temp_Cb);
   Test_Case_1 (68) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aural_Warn_Cb);
   Test_Case_1 (69) := not Cbs.Is_Powered (The_Cbs, Ele_T.Evap_Blower_Cb);
   Test_Case_1 (70) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aoa_Ht_Cb);
   Test_Case_1 (71) := not Cbs.Is_Powered (The_Cbs, Ele_T.Pitot_Ht_Cb);
   Test_Case_1 (72) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fuel_Bal_Cb);
   Test_Case_1 (73) := not Cbs.Is_Powered (The_Cbs, Ele_T.Side_Lts_Cb);
   Test_Case_1 (74) := not Cbs.Is_Powered (The_Cbs, Ele_T.Nav_Lts_Cb);
   Test_Case_1 (75) := not Cbs.Is_Powered (The_Cbs, Ele_T.Taxi_Lts_Cb);
   Test_Case_1 (76) := not Cbs.Is_Powered (The_Cbs, Ele_T.Speedbrake_Cb);
   Test_Case_1 (77) := not Cbs.Is_Powered (The_Cbs, Ele_T.Nws_Cb);
   Test_Case_1 (78) := not Cbs.Is_Powered (The_Cbs, Ele_T.Test_Lts_Cb);
   Test_Case_1 (79) := not Cbs.Is_Powered (The_Cbs, Ele_T.Trim_Ind_Cb);
   Test_Case_1 (80) := not Cbs.Is_Powered (The_Cbs, Ele_T.Edm_Cb_Fwd_Gen_Bus);
   Test_Case_1 (81) := not Cbs.Is_Powered (The_Cbs, Ele_T.Gen_Sw_Cb);
   Test_Case_1 (82) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fwd_Avi_Cb_Fwd_Gen_Bus);
   Test_Case_1 (83) := not Cbs.Is_Powered (The_Cbs, Ele_T.Fire_Detect_Cb_Fwd_Gen_Bus);
   Test_Case_1 (84) := not Cbs.Is_Powered (The_Cbs, Ele_T.Eng_Sys_Dis_Cb);
   Test_Case_1 (85) := not Cbs.Is_Powered (The_Cbs, Ele_T.Pri_Eng_Dis_Cb);
   Test_Case_1 (86) := not Cbs.Is_Powered (The_Cbs, Ele_T.Tad_Cb);
   Test_Case_1 (87) := not Cbs.Is_Powered (The_Cbs, Ele_T.Seat_Adj_Cb);
   Test_Case_1 (88) := not Cbs.Is_Powered (The_Cbs, Ele_T.Cws_Cb_Fwd_Gen_Bus);
   Test_Case_1 (89) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aft_Gen_Cb);
   Test_Case_1 (90) := not Cbs.Is_Powered (The_Cbs, Ele_T.Adc_Cb);
   Test_Case_1 (91) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ehsi_Cb);
   Test_Case_1 (92) := not Cbs.Is_Powered (The_Cbs, Ele_T.Xpdr_Cb);
   Test_Case_1 (93) := not Cbs.Is_Powered (The_Cbs, Ele_T.Nacws_Cb);
   Test_Case_1 (94) := not Cbs.Is_Powered (The_Cbs, Ele_T.Vhf_Comm_Cb);
   Test_Case_1 (95) := not Cbs.Is_Powered (The_Cbs, Ele_T.Asi_Cb);
   Test_Case_1 (96) := not Cbs.Is_Powered (The_Cbs, Ele_T.Altm_Cb_Fwd_Avi_Gen_Bus);
   Test_Case_1 (97) := not Cbs.Is_Powered (The_Cbs, Ele_T.Vhf_Nav_Cb);
   Test_Case_1 (98) := not Cbs.Is_Powered (The_Cbs, Ele_T.Dme_Cb);
   Test_Case_1 (99) := not Cbs.Is_Powered (The_Cbs, Ele_T.Radio_Rlys_Cb_Fwd_Avi_Gen_Bus);
   Test_Case_1 (100) := not Cbs.Is_Powered (The_Cbs, Ele_T.Vvi_Cb);
   Test_Case_1 (101) := not Cbs.Is_Powered (The_Cbs, Ele_T.Rmu_Cb);
   Test_Case_1 (102) := not Cbs.Is_Powered (The_Cbs, Ele_T.Aft_Avi_Cb_Fwd_Avi_Gen_Bus);
   Test_Case_1 (103) := not Cbs.Is_Powered (The_Cbs, Ele_T.Evap_Blower_Cb_Aft_Gen_Bus);
   Test_Case_1 (104) := not Cbs.Is_Powered (The_Cbs, Ele_T.Seat_Adj_Cb_Aft_Gen_Bus);
   Test_Case_1 (105) := not Cbs.Is_Powered (The_Cbs, Ele_T.Side_Lts_Cb_Aft_Gen_Bus);
   Test_Case_1 (106) := not Cbs.Is_Powered (The_Cbs, Ele_T.Eng_Sys_Dis_Cb_Aft_Gen_Bus);
   Test_Case_1 (107) := not Cbs.Is_Powered (The_Cbs, Ele_T.Pri_Eng_Dis_Cb_Aft_Gen_Bus);
   Test_Case_1 (108) := not Cbs.Is_Powered (The_Cbs, Ele_T.Trim_Ind_Cb_Aft_Gen_Bus);
   Test_Case_1 (109) := not Cbs.Is_Powered (The_Cbs, Ele_T.Ehsi_Cb_Aft_Avi_Gen_Bus);
   Test_Case_1 (110) := not Cbs.Is_Powered (The_Cbs, Ele_T.Rmu_Cb_Aft_Avi_Gen_Bus);
   Test_Case_1 (111) := not Cbs.Is_Powered (The_Cbs, Ele_T.Gps_Cb_Aft_Avi_Gen_Bus);
   Test_Case_1 (112) := not Cbs.Is_Powered (The_Cbs, Ele_T.Altm_Cb_Aft_Avi_Gen_Bus);
   Test_Case_1 (113) := not Cbs.Is_Powered (The_Cbs, Ele_T.Asi_Cb_Aft_Avi_Gen_Bus);
   Test_Case_1 (114) := not Cbs.Is_Powered (The_Cbs, Ele_T.Vvi_Cb_Aft_Avi_Gen_Bus);

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;


Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..1) := (others => false);
   Iconst : constant Float := 0.0666667;
begin
   Circuit_Breaker_Controller.Initialize;
   Power_Supply_Controller.Initialize;

   Io.Master_Bat_On_Sw := True;
   Io.Bus_Tie_Open_Sw := False;
   Io.Avionics_Master_On_Sw := True;
   Ios.The_Gpu_Connector_In := True;
   Ios.The_Gpu_Power_On := True;
   Io.Master_Gen_On_Sw := True;

   Buses.Power_Buses (The_Buses, 24.0);
   Io.Cws_Batt_Di  := True;


   for I in 1..1000 loop
      Circuit_Breaker_Controller.Update (Iconst);
   end loop;

   Test_Case_2 (1) := Cbs.Is_Powered (The_Cbs, Ele_T.Cws_Cb_Fwd_Batt_Bus);


   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Electrical.Circuit_Breaker_Controller_Ctd;

