-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Electrical.Bus_Controller;
with Jpats_Electrical.Power_Supply_Controller;
with Jpats_Electrical.Container;
with Jpats_Electrical_Types;
with Power_Supply;
with Power_Supply.Battery;
with Power_Supply.Auxiliary_Battery;
with Power_Supply.Generator;
with Power_Supply.External_Power;



procedure Jpats_Electrical.Bus_Controller_Ctd is


   type Test_Case_Array_Type is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case_Array_Type;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ele              renames Jpats_Electrical;
   package Ele_T            renames Jpats_Electrical_Types;
   package Ctnr             renames Container;
   package Relays           renames Ctnr.Coil_Relay_Collection;
   package Current_Limiters renames Ctnr.Current_Limiter_Collection;
   package Paths renames Ctnr.Path_Collection;
   package Buses renames Ctnr.Bus_Collection;
   package CBS renames Ctnr.Circuit_Breaker_Collection;

   Jpats : Ctnr.Instance renames Ctnr.This_Subsystem;

--   Path : Ctnr.Path_Array_Of_Boolean_Type;

--   Pwr_Source_Voltage : Ctnr.Array_Of_Power_Source_Voltage_Type;

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

   The_Batt         : Power_Supply.Battery.Instance           renames Jpats.The_Battery;
   The_Aux_Batt     : Power_Supply.Auxiliary_Battery.Instance renames Jpats.The_Auxiliary_Battery;
   The_Gen          : Power_Supply.Generator.Instance         renames Jpats.The_Generator;
   The_Ext_Pwr      : Power_Supply.External_Power.Instance    renames Jpats.The_External_Power;
   The_Aux_Batt_Mnt : Ctnr.Auxiliary_Battery_Mount.Instance   renames Jpats.The_Auxiliary_Battery_Mount;
   The_Paths : Paths.Instance renames Ctnr.This_Subsystem.The_Paths;
   The_Buses : Buses.Instance renames Ctnr.This_Subsystem.The_Buses;
   The_Cbs : Cbs.Instance     renames Ctnr.This_Subsystem.The_Circuit_Breakers;
   The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Relays;

   I : Integer := 0;

begin

Test_1 : declare
   Test_Case_1 : Test_Case_Array_Type (1..132) := (others => false);
begin
   Bus_Controller.Initialize;

   Test_Case_1 (1) :=  not Buses.Is_Powered (The_Buses, ctnr.Forward_Battery_Bus);
   Test_Case_1 (2) :=  not Buses.Is_Powered (The_Buses, ctnr.Forward_Generator_Bus);
   Test_Case_1 (3) :=  not Buses.Is_Powered (The_Buses, ctnr.Forward_Avionics_Battery_Bus);
   Test_Case_1 (4) :=  not Buses.Is_Powered (The_Buses, ctnr.Forward_Avionics_Generator_Bus);
   Test_Case_1 (5) :=  not Buses.Is_Powered (The_Buses, ctnr.Hot_Battery_Bus);
   Test_Case_1 (6) :=  not Buses.Is_Powered (The_Buses, ctnr.Generator_Bus);
   Test_Case_1 (7) :=  not Buses.Is_Powered (The_Buses, ctnr.Aft_Battery_Bus);
   Test_Case_1 (8) :=  not Buses.Is_Powered (The_Buses, ctnr.Aft_Generator_Bus);
   Test_Case_1 (9) :=  not Buses.Is_Powered (The_Buses, ctnr.Aft_Auxiliary_Battery_Bus);
   Test_Case_1 (10) := not Buses.Is_Powered (The_Buses, ctnr.Forward_Auxiliary_Battery_Bus);
   Test_Case_1 (11) := not Buses.Is_Powered (The_Buses, ctnr.Aft_Avionics_Generator_Bus);
   Test_Case_1 (12) := not Buses.Is_Powered (The_Buses, ctnr.Aft_Avionics_Battery_Bus);

   Test_Case_1 (13) := Buses.Load (The_Buses, ctnr.Forward_Battery_Bus) = 0.0;
   Test_Case_1 (14) := Buses.Load (The_Buses, ctnr.Forward_Generator_Bus) = 0.0;
   Test_Case_1 (15) := Buses.Load (The_Buses, ctnr.Forward_Avionics_Battery_Bus) = 0.0;
   Test_Case_1 (16) := Buses.Load (The_Buses, ctnr.Forward_Avionics_Generator_Bus) = 0.0;
   Test_Case_1 (17) := Buses.Load (The_Buses, ctnr.Hot_Battery_Bus) = 0.0;
   Test_Case_1 (18) := Buses.Load (The_Buses, ctnr.Generator_Bus) = 0.0;
   Test_Case_1 (19) := Buses.Load (The_Buses, ctnr.Aft_Battery_Bus) = 0.0;
   Test_Case_1 (20) := Buses.Load (The_Buses, ctnr.Aft_Generator_Bus) = 0.0;
   Test_Case_1 (21) := Buses.Load (The_Buses, ctnr.Aft_Auxiliary_Battery_Bus) = 0.0;
   Test_Case_1 (22) := Buses.Load (The_Buses, ctnr.Forward_Auxiliary_Battery_Bus) = 0.0;
   Test_Case_1 (23) := Buses.Load (The_Buses, ctnr.Aft_Avionics_Generator_Bus) = 0.0;
   Test_Case_1 (24) := Buses.Load (The_Buses, ctnr.Aft_Avionics_Battery_Bus) = 0.0;

   Test_Case_1 (25) := Buses.Voltage (The_Buses, ctnr.Forward_Battery_Bus) = 0.0;
   Test_Case_1 (26) := Buses.Voltage (The_Buses, ctnr.Forward_Generator_Bus) = 0.0;
   Test_Case_1 (27) := Buses.Voltage (The_Buses, ctnr.Forward_Avionics_Battery_Bus) = 0.0;
   Test_Case_1 (28) := Buses.Voltage (The_Buses, ctnr.Forward_Avionics_Generator_Bus) = 0.0;
   Test_Case_1 (29) := Buses.Voltage (The_Buses, ctnr.Hot_Battery_Bus) = 0.0;
   Test_Case_1 (30) := Buses.Voltage (The_Buses, ctnr.Generator_Bus) = 0.0;
   Test_Case_1 (31) := Buses.Voltage (The_Buses, ctnr.Aft_Battery_Bus) = 0.0;
   Test_Case_1 (32) := Buses.Voltage (The_Buses, ctnr.Aft_Generator_Bus) = 0.0;
   Test_Case_1 (33) := Buses.Voltage (The_Buses, ctnr.Aft_Auxiliary_Battery_Bus) = 0.0;
   Test_Case_1 (34) := Buses.Voltage (The_Buses, ctnr.Forward_Auxiliary_Battery_Bus) = 0.0;
   Test_Case_1 (35) := Buses.Voltage (The_Buses, ctnr.Aft_Avionics_Generator_Bus) = 0.0;
   Test_Case_1 (36) := Buses.Voltage (The_Buses, ctnr.Aft_Avionics_Battery_Bus) = 0.0;

   I := 37;

   for Pwr_Src in Ctnr.Power_Source_Name_Type
   loop
      for Bus in Ctnr.Bus_Name_Type
      loop
         Test_Case_1 (I) := not Paths.Is_Complete (The_Paths,Pwr_Src,Bus);
         I := I + 1;
      end loop;
   end loop;


   for Pwr_Src in Ctnr.Power_Source_Name_Type
   loop
      for Bus in Ctnr.Bus_Name_Type
      loop
         Test_Case_1 (I) := Paths.Voltage (The_Paths,Pwr_Src,Bus) = 0.0;
         I := I + 1;
      end loop;
   end loop;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;


Test_2 : declare
   Test_Case_2 : Test_Case_Array_Type (1..1) := (others => false);
   Iconst : constant Float := 0.0666667;
begin
   Bus_Controller.Initialize;
   Power_Supply_Controller.Initialize;
   Io.Master_Bat_On_Sw := True;
   Io.Bus_Tie_Open_Sw := False;
   Ctnr.Current_Limiter_Collection.Close_Current_Limiter (Ctnr.This_Subsystem.The_Current_Limiters, Ctnr.Battery_Bus_Current_Limiter);
   Ctnr.Circuit_Breaker_Collection.Power (The_Cbs);
   Ctnr.Coil_Relay_Collection.Close_Relay (The_Relays,Ele_T.Battery_Relay);
   for I in 1..1000 loop
      Bus_Controller.Update (Iconst);
   end loop;
   Test_Case_2 (1) := Buses.Is_Powered (The_Buses, ctnr.Forward_Battery_Bus);
   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Electrical.Bus_Controller_Ctd;
