-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Generator_Control_Unit_G;

procedure Generator_Control_Unit_G_Ctd is



begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Gcu is new Generator_Control_Unit_G
        (Voltage_Type => Float,
         Ampere_Type  => Float);

      A_Gcu : Gcu.Instance;

      Voltage_In_in        : Float;
      Bus_Sense_Voltage_in : Float;
      Current_In_in        : Float;
      Reverse_Current_In_in: Float;
      Gen_Reset_In_in      : Boolean;
      Fail_Demanded_in     : Boolean;

      Test_1 : Boolean;
      Test_2 : Boolean;
      Test_3 : Boolean;

      Transistion_To_Online_Counter : Integer := 0;
      Transistion_To_Offline_Counter : Integer := 0;

      Line_Control_Last_Pass : Boolean := False;

   begin

      Gcu.Initialize (A_Gcu);
      Test_1 := not Gcu.Line_Control (A_Gcu);
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 100.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_First_Quarter then
--                Test_2 := not Gcu.Line_Control (A_Gcu);
--                Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
--             end if;
--             In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Voltage_In_in         := 0.0;
            Bus_Sense_Voltage_in  := 0.0;
            Current_In_in         := 0.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Second_Quarter then
--                Test_3 := not Gcu.Line_Control (A_Gcu);
--                Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
--             end if;
--             In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 100.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Third_Quarter then
--                Test_4 := not Gcu.Line_Control (A_Gcu);
--                Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
--             end if;
--             In_Third_Quarter := False;
         else

            Voltage_In_in         := 0.0;
            Bus_Sense_Voltage_in  := 0.0;
            Current_In_in         := 0.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Fourth_Quarter then
--                Test_5 := not Gcu.Line_Control (A_Gcu);
--                Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
--             end if;
--             In_Fourth_Quarter := False;
         end if;

         if Line_Control_Last_Pass /= Gcu.Line_Control (A_Gcu) then
            if Gcu.Line_Control (A_Gcu) then
               Transistion_To_Online_Counter := Transistion_To_Online_Counter + 1;
            else
               Transistion_To_Offline_Counter := Transistion_To_Offline_Counter + 1;
            end if;
         end if;



         Line_Control_Last_Pass := Gcu.Line_Control (A_Gcu);

      end loop;

      Test_2 := Transistion_To_Online_Counter = 2;
      Test_3 := Transistion_To_Offline_Counter = 2;
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);

   end;

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Gcu is new Generator_Control_Unit_G
        (Voltage_Type => Float,
         Ampere_Type  => Float);

      A_Gcu : Gcu.Instance;

      Voltage_In_in        : Float;
      Bus_Sense_Voltage_in : Float;
      Current_In_in        : Float;
      Reverse_Current_In_in: Float;
      Gen_Reset_In_in      : Boolean;
      Fail_Demanded_in     : Boolean;

      Test_4 : Boolean;
      Test_5 : Boolean;


      Transistion_To_Online_Counter : Integer := 0;
      Transistion_To_Offline_Counter : Integer := 0;

      Line_Control_Last_Pass : Boolean := False;

   begin

      Gcu.Initialize (A_Gcu);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 10.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_First_Quarter then
--             end if;
--             In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Voltage_In_In := Voltage_In_In - Iconst;
            if Voltage_In_In >= 0.0 then Voltage_In_In := 0.0; end if;

--            Voltage_In_in         := 0.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 0.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Second_Quarter then
--             end if;
--             In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 28.0;
            Current_In_in         := 10.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Third_Quarter then
--             end if;
--             In_Third_Quarter := False;
         else

            Voltage_In_In := Voltage_In_In + Iconst;
            if Voltage_In_In >= 45.0 then Voltage_In_In := 45.0; end if;

--            Voltage_In_in         := 0.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 10.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Fourth_Quarter then
--             end if;
--             In_Fourth_Quarter := False;
         end if;

         if Line_Control_Last_Pass /= Gcu.Line_Control (A_Gcu) then
            if Gcu.Line_Control (A_Gcu) then
               Transistion_To_Online_Counter := Transistion_To_Online_Counter + 1;
            else
               Transistion_To_Offline_Counter := Transistion_To_Offline_Counter + 1;
            end if;
         end if;

         Line_Control_Last_Pass := Gcu.Line_Control (A_Gcu);

      end loop;

      Test_4 := Transistion_To_Online_Counter = 2;
      Test_5 := Transistion_To_Offline_Counter = 2;
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
      Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);

   end;

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 20.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      package Gcu is new Generator_Control_Unit_G
        (Voltage_Type => Float,
         Ampere_Type  => Float);

      A_Gcu : Gcu.Instance;

      Voltage_In_in        : Float;
      Bus_Sense_Voltage_in : Float;
      Current_In_in        : Float;
      Reverse_Current_In_in: Float;
      Gen_Reset_In_in      : Boolean;
      Fail_Demanded_in     : Boolean;

      Test_6 : Boolean;
      Test_7 : Boolean;

      Transistion_To_Online_Counter : Integer := 0;
      Transistion_To_Offline_Counter : Integer := 0;

      Line_Control_Last_Pass : Boolean := False;

   begin

      Gcu.Initialize (A_Gcu);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 10.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_First_Quarter then
--             end if;
--             In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 451.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Second_Quarter then
--             end if;
--             In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 10.0;
            Reverse_Current_In_In := 0.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Third_Quarter then
--             end if;
--             In_Third_Quarter := False;
         else

            Voltage_In_in         := 28.0;
            Bus_Sense_Voltage_in  := 24.0;
            Current_In_in         := 10.0;
            Reverse_Current_In_In := 50.0;
            Gen_Reset_In_in       := False;
            Fail_Demanded_in      := False;

            Gcu.Update
              (An_Instance        => A_Gcu,
               Iconst             => Iconst,
               Voltage_In         => Voltage_In_in,
               Bus_Sense_Voltage  => Bus_Sense_Voltage_in,
               Current_In         => Current_In_in,
               Reverse_Current_In => Reverse_Current_In_in,
               Gen_Reset_In       => Gen_Reset_In_in,
               Fail_Demanded      => Fail_Demanded_in);

--             if In_Fourth_Quarter then
--             end if;
--             In_Fourth_Quarter := False;
         end if;

         if Line_Control_Last_Pass /= Gcu.Line_Control (A_Gcu) then
            if Gcu.Line_Control (A_Gcu) then
               Transistion_To_Online_Counter := Transistion_To_Online_Counter + 1;
            else
               Transistion_To_Offline_Counter := Transistion_To_Offline_Counter + 1;
            end if;
         end if;

         Line_Control_Last_Pass := Gcu.Line_Control (A_Gcu);

      end loop;

      Test_6 := Transistion_To_Online_Counter = 1;
      Test_7 := Transistion_To_Offline_Counter = 1;
      Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
      Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);

   end;

end Generator_Control_Unit_G_Ctd;
