-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Current_Limiter_G;
with Current_Limiter_Collection_G;

procedure Current_Limiter_Collection_G_Ctd is



begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package CL is new Current_Limiter_G;
      type CL_Name_Type is (Left,Right);
      type CL_Array is array (CL_Name_Type) of CL.Instance;
      type CL_Bool_array is array (CL_Name_Type) of Boolean;
      package CLs is new Current_Limiter_Collection_G
        (Current_Limiter_Name_Type     => CL_Name_Type,
         Current_Limiter_Type          => CL.Instance,
         Array_Of_Current_Limiter_Type => CL_Array,
         Array_Of_Boolean              => CL_Bool_Array,
         Open_A_Current_Limiter        => CL.Open,
         Close_A_Current_Limiter       => CL.Close,
         Initialize_A_Current_Limiter  => CL.Initialize,
         Update_A_Current_Limiter      => CL.Update,
         A_Current_Limiter_Open        => CL.Is_Open,
         A_Current_Limiter_Closed      => CL.Is_Closed);

      The_CLs : CLs.Instance;
      Open_Commands : CL_Bool_Array;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;

   begin

      CLs.Initialize (The_CLs);
      Test_1 := not CLs.Is_Open (The_CLs,Left) and CLs.Is_Closed (The_CLs,Left);
      Test_2 := not CLs.Is_Open (The_CLs,Right) and CLs.Is_Closed (The_CLs,Right);
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      while Now < Stop_Time
      loop
         if Now < One_Quarter_Time then

            for Name in CL_Name_Type
            loop
               if Name = Left then
                 Open_Commands (Name) := False;
               end if;
                 if Name = Right then
                 Open_Commands (Name) := False;
               end if;
            end loop;

            CLs.Update(The_CLs,Open_Commands);

            if In_First_Quarter then
               Test_3 := not CLs.Is_Open (The_CLs,Left) and CLs.Is_Closed (The_CLs,Left);
               Test_4 := not CLs.Is_Open (The_CLs,Right) and CLs.Is_Closed (The_CLs,Right);
               Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
               Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            for Name in CL_Name_Type
            loop
               if Name = Left then
                 Open_Commands (Name) := True;
               end if;
                 if Name = Right then
                 Open_Commands (Name) := False;
               end if;
            end loop;

            CLs.Update(The_CLs,Open_Commands);

            if In_Second_Quarter then
               Test_5 := CLs.Is_Open (The_CLs,Left) and not CLs.Is_Closed (The_CLs,Left);
               Test_6 := not CLs.Is_Open (The_CLs,Right) and CLs.Is_Closed (The_CLs,Right);
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then


            for Name in CL_Name_Type
            loop
               if Name = Left then
                 Open_Commands (Name) := False;
               end if;
                 if Name = Right then
                 Open_Commands (Name) := True;
               end if;
            end loop;

            CLs.Update(The_CLs,Open_Commands);

            if In_Third_Quarter then
               Test_7 := not CLs.Is_Open (The_CLs,Left) and CLs.Is_Closed (The_CLs,Left);
               Test_8 := CLs.Is_Open (The_CLs,Right) and not CLs.Is_Closed (The_CLs,Right);
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
            end if;
            In_Third_Quarter := False;
         else

            for Name in CL_Name_Type
            loop
               if Name = Left then
                 Open_Commands (Name) := True;
               end if;
                 if Name = Right then
                 Open_Commands (Name) := True;
               end if;
            end loop;

            CLs.Update(The_CLs,Open_Commands);


            if In_Fourth_Quarter then
               Test_9  := CLs.Is_Open (The_CLs,Left) and not CLs.Is_Closed (The_CLs,Left);
               Test_10 := CLs.Is_Open (The_CLs,Right) and not CLs.Is_Closed (The_CLs,Right);
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
            end if;
            In_Fourth_Quarter := False;
         end if;
      end loop;

   end;

end Current_Limiter_Collection_G_Ctd;
