-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Coil_Relay_G;
with Coil_Relay_Collection_G;

procedure Coil_Relay_Collection_G_Ctd is


begin


   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Relay is new Coil_Relay_G (Ampere_Type => Float,
                                         Closed_Load => 0.5);

      type Relay_Name_Type is (Relay_A, Relay_B, Relay_C);
      type Relay_Array is array (Relay_Name_Type) of Relay.Instance;
      type Relay_Bool_Array is array (Relay_Name_Type) of Boolean;
      package Relays is new Coil_Relay_Collection_G
        (Ampere_Type           => Float,
         Relay_Name_Type       => Relay_Name_Type,
         Relay_Type            => Relay.Instance,
         Array_Of_Relay_Type   => Relay_Array,
         Array_Of_Boolean_Type => Relay_Bool_Array,
         Open_A_Relay          => Relay.Open,
         Close_A_Relay         => Relay.Close,
         Initialize_A_Relay    => Relay.Initialize,
         A_Relay_Load          => Relay.Load,
         A_Relay_Is_Open       => Relay.Is_Open,
         A_Relay_Is_Closed     => Relay.Is_Closed,
         Update_A_Relay        => Relay.Update);

      The_Relays : Relays.Instance;
      P_And_G : Relay_Bool_Array;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;
      Test_16 : Boolean;
      Test_17 : Boolean;
      Test_18 : Boolean;
      Test_19 : Boolean;
      Test_20 : Boolean;
      Test_21 : Boolean;
      Test_22 : Boolean;
      Test_23 : Boolean;
      Test_24 : Boolean;
      Test_25 : Boolean;
      Test_26 : Boolean;
      Test_27 : Boolean;
      Test_28 : Boolean;
      Test_29 : Boolean;
      Test_30 : Boolean;

   begin

      Relays.Initialize (The_relays);
      Test_1 := Relays.Load (The_Relays,Relay_A) = 0.0;
      Test_2 := Relays.Load (The_Relays,Relay_B) = 0.0;
      Test_3 := Relays.Load (The_Relays,Relay_C) = 0.0;
      Test_4 := Relays.Is_Open (The_Relays,Relay_A) = True and not Relays.Is_Closed (The_Relays,Relay_A);
      Test_5 := Relays.Is_Open (The_Relays,Relay_B) = True and not Relays.Is_Closed (The_Relays,Relay_B);
      Test_6 := Relays.Is_Open (The_Relays,Relay_C) = True and not Relays.Is_Closed (The_Relays,Relay_C);
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
      Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
      Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            for Name in Relay_Name_Type
            loop
               if Name = Relay_A then
                  P_And_G (Name) := True;
               end if;
               if Name = Relay_B then
                  P_And_G (Name) := False;
               end if;
               if Name = Relay_C then
                  P_And_G (Name) := False;
               end if;
            end loop;

            Relays.Update(The_Relays,P_And_G);

            if In_First_Quarter then
               Test_7  := Relays.Load (The_Relays,Relay_A) = 0.5;
               Test_8  := Relays.Load (The_Relays,Relay_B) = 0.0;
               Test_9  := Relays.Load (The_Relays,Relay_C) = 0.0;
               Test_10 := not Relays.Is_Open (The_Relays,Relay_A) = True and Relays.Is_Closed (The_Relays,Relay_A);
               Test_11 := Relays.Is_Open (The_Relays,Relay_B) = True and not Relays.Is_Closed (The_Relays,Relay_B);
               Test_12 := Relays.Is_Open (The_Relays,Relay_C) = True and not Relays.Is_Closed (The_Relays,Relay_C);
               Class_Test_Result_File.Report_Case_Status (Success => Test_7 , Number => 7 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_8 , Number => 8 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            for Name in Relay_Name_Type
            loop
               if Name = Relay_A then
                  P_And_G (Name) := False;
               end if;
               if Name = Relay_B then
                  P_And_G (Name) := True;
               end if;
               if Name = Relay_C then
                  P_And_G (Name) := False;
               end if;
            end loop;

            Relays.Update(The_Relays,P_And_G);

            if In_Second_Quarter then
               Test_13 := Relays.Load (The_Relays,Relay_A) = 0.0;
               Test_14 := Relays.Load (The_Relays,Relay_B) = 0.5;
               Test_15 := Relays.Load (The_Relays,Relay_C) = 0.0;
               Test_16 := Relays.Is_Open (The_Relays,Relay_A) = True and not Relays.Is_Closed (The_Relays,Relay_A);
               Test_17 := not Relays.Is_Open (The_Relays,Relay_B) = True and Relays.Is_Closed (The_Relays,Relay_B);
               Test_18 := Relays.Is_Open (The_Relays,Relay_C) = True and not Relays.Is_Closed (The_Relays,Relay_C);
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            for Name in Relay_Name_Type
            loop
               if Name = Relay_A then
                  P_And_G (Name) := False;
               end if;
               if Name = Relay_B then
                  P_And_G (Name) := False;
               end if;
               if Name = Relay_C then
                  P_And_G (Name) := True;
               end if;
            end loop;

            Relays.Update(The_Relays,P_And_G);

            if In_Third_Quarter then
               Test_19 := Relays.Load (The_Relays,Relay_A) = 0.0;
               Test_20 := Relays.Load (The_Relays,Relay_B) = 0.0;
               Test_21 := Relays.Load (The_Relays,Relay_C) = 0.5;
               Test_22 := Relays.Is_Open (The_Relays,Relay_A) = True and not Relays.Is_Closed (The_Relays,Relay_A);
               Test_23 := Relays.Is_Open (The_Relays,Relay_B) = True and not Relays.Is_Closed (The_Relays,Relay_B);
               Test_24 := not Relays.Is_Open (The_Relays,Relay_C) = True and Relays.Is_Closed (The_Relays,Relay_C);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
            end if;
            In_Third_Quarter := False;
         else

            for Name in Relay_Name_Type
            loop
               if Name = Relay_A then
                  P_And_G (Name) := True;
               end if;
               if Name = Relay_B then
                  P_And_G (Name) := True;
               end if;
               if Name = Relay_C then
                  P_And_G (Name) := True;
               end if;
            end loop;

            Relays.Update(The_Relays,P_And_G);

            if In_Fourth_Quarter then
               Test_25 := Relays.Load (The_Relays,Relay_A) = 0.5;
               Test_26 := Relays.Load (The_Relays,Relay_B) = 0.5;
               Test_27 := Relays.Load (The_Relays,Relay_C) = 0.5;
               Test_28 := not Relays.Is_Open (The_Relays,Relay_A) = True and Relays.Is_Closed (The_Relays,Relay_A);
               Test_29 := not Relays.Is_Open (The_Relays,Relay_B) = True and Relays.Is_Closed (The_Relays,Relay_B);
               Test_30 := not Relays.Is_Open (The_Relays,Relay_C) = True and Relays.Is_Closed (The_Relays,Relay_C);
               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
               Class_Test_Result_File.Report_Case_Status (Success => Test_26, Number => 26);
               Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);
               Class_Test_Result_File.Report_Case_Status (Success => Test_28, Number => 28);
               Class_Test_Result_File.Report_Case_Status (Success => Test_29, Number => 29);
               Class_Test_Result_File.Report_Case_Status (Success => Test_30, Number => 30);
            end if;
            In_Fourth_Quarter := False;
         end if;
      end loop;

   end;


end Coil_Relay_Collection_G_Ctd;

