-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------



with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Circuit_Breaker_G;
with Circuit_Breaker_Collection_G;

procedure Circuit_Breaker_Collection_G_Ctd is

begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Cb is new Circuit_Breaker_G;
      type Cb_Name_Type is (Cb1,Cb2,Cb3,Cb4,Cb5);
      type Cb_Array is array (Cb_Name_Type) of Cb.Instance;
      type Cb_Bool_Array is array (Cb_Name_Type) of Boolean;
      package Cb_Collection is new Circuit_Breaker_Collection_G
        (Circuit_Breaker_Name_Type     => Cb_Name_Type,
         Circuit_Breaker_Type          => Cb.Instance,
         Array_Of_Circuit_Breaker_Type => Cb_Array,
         Array_Of_Boolean_Type         => Cb_Bool_Array,
         Power_Circuit_Breaker         => Cb.Power,
         Unpower_Circuit_Breaker       => Cb.Unpower,
         Circuit_Breaker_Is_Powered    => Cb.Is_Powered,
         Circuit_Breaker_Is_Unpowered  => Cb.Is_Unpowered,
         Update_Circuit_Breaker        => Cb.Update,
         Initialize_Circuit_Breaker    => Cb.Initialize);

      A_Cb_Collection    : Cb_Collection.Instance;
      Another_Cb_Collection : Cb_Collection.Instance;

      The_Cbs       : Cb_Collection.Instance renames A_Cb_Collection;
      The_Other_Cbs : Cb_Collection.Instance renames Another_Cb_Collection;

      The_Cbs_Power : Cb_Bool_Array;
      The_Cbs_In    : Cb_Bool_Array;


      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;
      Test_16 : Boolean;
      Test_17 : Boolean;
      Test_18 : Boolean;
      Test_19 : Boolean;
      Test_20 : Boolean;
      Test_21 : Boolean;
      Test_22 : Boolean;
      Test_23 : Boolean;
      Test_24 : Boolean;
      Test_25 : Boolean;
      Test_26 : Boolean;
      Test_27 : Boolean;
      Test_28 : Boolean;
      Test_29 : Boolean;

   begin

      Cb_Collection.Initialize (The_Cbs);

      Test_1 := not Cb_Collection.Is_Powered (The_Cbs,Cb1) and Cb_Collection.Is_Unpowered (The_Cbs,Cb1);
      Test_2 := not Cb_Collection.Is_Powered (The_Cbs,Cb2) and Cb_Collection.Is_Unpowered (The_Cbs,Cb2);
      Test_3 := not Cb_Collection.Is_Powered (The_Cbs,Cb3) and Cb_Collection.Is_Unpowered (The_Cbs,Cb3);
      Test_4 := not Cb_Collection.Is_Powered (The_Cbs,Cb4) and Cb_Collection.Is_Unpowered (The_Cbs,Cb4);
      Test_5 := not Cb_Collection.Is_Powered (The_Cbs,Cb5) and Cb_Collection.Is_Unpowered (The_Cbs,Cb5);
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
      Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);

      Cb_Collection.Initialize (The_Other_Cbs);

      for Name in Cb_Name_Type
      loop
         Test_26 := not Cb_Collection.Is_Powered (The_Other_Cbs,Name) and Cb_Collection.Is_Unpowered (The_Other_Cbs,Name);
         exit when not Test_26;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Test_26, Number => 26);

      while Now < Stop_Time
      loop


         if Now < One_Quarter_Time then

            for Name in Cb_Name_Type
            loop
               if Name = Cb1 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := False;
               end if;
               if Name = Cb2 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := False;
               end if;
               if Name = Cb3 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := False;
               end if;
               if Name = Cb4 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb5 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := False;
               end if;
            end loop;

            Cb_Collection.Update (An_Instance => The_Cbs,
                                  Has_Power   => The_Cbs_Power,
                                  Is_In       => The_Cbs_In);


            Cb_Collection.Power (The_Other_Cbs);

            if In_First_Quarter then

               Test_6  := not Cb_Collection.Is_Powered (The_Cbs,Cb1) and Cb_Collection.Is_Unpowered (The_Cbs,Cb1);
               Test_7  := not Cb_Collection.Is_Powered (The_Cbs,Cb2) and Cb_Collection.Is_Unpowered (The_Cbs,Cb2);
               Test_8  := not Cb_Collection.Is_Powered (The_Cbs,Cb3) and Cb_Collection.Is_Unpowered (The_Cbs,Cb3);
               Test_9  := Cb_Collection.Is_Powered (The_Cbs,Cb4) and not Cb_Collection.Is_Unpowered (The_Cbs,Cb4);
               Test_10 := not Cb_Collection.Is_Powered (The_Cbs,Cb5) and Cb_Collection.Is_Unpowered (The_Cbs,Cb5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6 , Number => 6 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_7 , Number => 7 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_8 , Number => 8 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);

               for Name in Cb_Name_Type
               loop
                  Test_27 := Cb_Collection.Is_Powered (The_Other_Cbs,Name) and not Cb_Collection.Is_Unpowered (The_Other_Cbs,Name);
                  exit when not Test_26;
               end loop;

               Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);

            end if;
            In_First_Quarter := False;

         elsif Now < Two_Quarter_Time then

            for Name in Cb_Name_Type
            loop
               if Name = Cb1 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := False;
               end if;
               if Name = Cb2 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb3 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := False;
               end if;
               if Name = Cb4 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := False;
               end if;
               if Name = Cb5 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := False;
               end if;
            end loop;

            Cb_Collection.Update (An_Instance => The_Cbs,
                                  Has_Power   => The_Cbs_Power,
                                  Is_In       => The_Cbs_In);

            Cb_Collection.Unpower (The_Other_Cbs);

            if In_Second_Quarter then
               Test_11 := not Cb_Collection.Is_Powered (The_Cbs,Cb1) and Cb_Collection.Is_Unpowered (The_Cbs,Cb1);
               Test_12 := Cb_Collection.Is_Powered (The_Cbs,Cb2) and not Cb_Collection.Is_Unpowered (The_Cbs,Cb2);
               Test_13 := not Cb_Collection.Is_Powered (The_Cbs,Cb3) and Cb_Collection.Is_Unpowered (The_Cbs,Cb3);
               Test_14 := not Cb_Collection.Is_Powered (The_Cbs,Cb4) and Cb_Collection.Is_Unpowered (The_Cbs,Cb4);
               Test_15 := not Cb_Collection.Is_Powered (The_Cbs,Cb5) and Cb_Collection.Is_Unpowered (The_Cbs,Cb5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);

               for Name in Cb_Name_Type
               loop
                  Test_27 := not Cb_Collection.Is_Powered (The_Other_Cbs,Name) and Cb_Collection.Is_Unpowered (The_Other_Cbs,Name);
                  exit when not Test_27;
               end loop;

               Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);

            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            for Name in Cb_Name_Type
            loop
               if Name = Cb1 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb2 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb3 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb4 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb5 then
                  The_Cbs_Power (Name) := False;
                  The_Cbs_In (Name)    := True;
               end if;
            end loop;

            Cb_Collection.Update (An_Instance => The_Cbs,
                                  Has_Power   => The_Cbs_Power,
                                  Is_In       => The_Cbs_In);

            Cb_Collection.Power (The_Other_Cbs);

            if In_Third_Quarter then
               Test_16 := not Cb_Collection.Is_Powered (The_Cbs,Cb1) and Cb_Collection.Is_Unpowered (The_Cbs,Cb1);
               Test_17 := not Cb_Collection.Is_Powered (The_Cbs,Cb2) and Cb_Collection.Is_Unpowered (The_Cbs,Cb2);
               Test_18 := not Cb_Collection.Is_Powered (The_Cbs,Cb3) and Cb_Collection.Is_Unpowered (The_Cbs,Cb3);
               Test_19 := not Cb_Collection.Is_Powered (The_Cbs,Cb4) and Cb_Collection.Is_Unpowered (The_Cbs,Cb4);
               Test_20 := not Cb_Collection.Is_Powered (The_Cbs,Cb5) and Cb_Collection.Is_Unpowered (The_Cbs,Cb5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);

               for Name in Cb_Name_Type
               loop
                  Test_28 := Cb_Collection.Is_Powered (The_Other_Cbs,Name) and not Cb_Collection.Is_Unpowered (The_Other_Cbs,Name);
                  exit when not Test_28;
               end loop;

               Class_Test_Result_File.Report_Case_Status (Success => Test_28, Number => 28);

            end if;
            In_Third_Quarter := False;
         else

            for Name in Cb_Name_Type
            loop
               if Name = Cb1 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb2 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb3 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb4 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := True;
               end if;
               if Name = Cb5 then
                  The_Cbs_Power (Name) := True;
                  The_Cbs_In (Name)    := True;
               end if;
            end loop;

            Cb_Collection.Update (An_Instance => The_Cbs,
                                  Has_Power   => The_Cbs_Power,
                                  Is_In       => The_Cbs_In);

            Cb_Collection.Unpower (The_Other_Cbs);

            if In_Fourth_Quarter then
               Test_21 := Cb_Collection.Is_Powered (The_Cbs,Cb1) and not Cb_Collection.Is_Unpowered (The_Cbs,Cb1);
               Test_22 := Cb_Collection.Is_Powered (The_Cbs,Cb2) and not Cb_Collection.Is_Unpowered (The_Cbs,Cb2);
               Test_23 := Cb_Collection.Is_Powered (The_Cbs,Cb3) and not Cb_Collection.Is_Unpowered (The_Cbs,Cb3);
               Test_24 := Cb_Collection.Is_Powered (The_Cbs,Cb4) and not Cb_Collection.Is_Unpowered (The_Cbs,Cb4);
               Test_25 := Cb_Collection.Is_Powered (The_Cbs,Cb5) and not Cb_Collection.Is_Unpowered (The_Cbs,Cb5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);

               for Name in Cb_Name_Type
               loop
                  Test_29 := not Cb_Collection.Is_Powered (The_Other_Cbs,Name) and Cb_Collection.Is_Unpowered (The_Other_Cbs,Name);
                  exit when not Test_29;
               end loop;

               Class_Test_Result_File.Report_Case_Status (Success => Test_29, Number => 29);

            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;

   end;


end Circuit_Breaker_Collection_G_Ctd;
