-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Bus_G;

procedure Bus_G_Ctd is



begin


   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Bus is new Bus_G (Voltage_Type => Float,
                                Ampere_Type  => Float,
                                Powered_Voltage_Threshold => 5.0);

      A_Bus : Bus.Instance;

      Voltage_To_Bus : Float := 10.0;
      Load_On_Bus    : Float := 10.0;


      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;

   begin

      Bus.Initialize (A_Bus);

      Test_1 := Bus.Voltage (A_Bus) = 0.0;
      Test_2 := Bus.Is_Powered (A_Bus) = False;
      Test_3 := Bus.Load (A_Bus) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then


            Voltage_To_Bus := 4.0;
            Load_On_Bus    := 10.0;

            Bus.Update
              (An_Instance => A_Bus,
               Voltage     => Voltage_To_Bus,
               Load        => Load_On_Bus);


            if In_First_Quarter then
               Test_4 := Bus.Voltage (A_Bus) = 4.0;
               Test_5 := Bus.Is_Powered (A_Bus) = False;
               Test_6 := Bus.Load (A_Bus) = 10.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
            end if;
            In_First_Quarter := False;

         elsif Now < Two_Quarter_Time then

            Voltage_To_Bus := 24.0;
            Load_On_Bus    := 11.0;

            Bus.Update
              (An_Instance => A_Bus,
               Voltage     => Voltage_To_Bus,
               Load        => Load_On_Bus);

            if In_Second_Quarter then
               Test_7 := Bus.Voltage (A_Bus) = 24.0;
               Test_8 := Bus.Is_Powered (A_Bus) = True;
               Test_9 := Bus.Load (A_Bus) = 11.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
            end if;
            In_Second_Quarter := False;

         elsif Now < Three_Quarter_Time then

            Voltage_To_Bus := 3.0;
            Load_On_Bus    := 0.0;

            Bus.Update
              (An_Instance => A_Bus,
               Voltage     => Voltage_To_Bus,
               Load        => Load_On_Bus);

            if In_Third_Quarter then
               Test_10 := Bus.Voltage (A_Bus) = 3.0;
               Test_11 := Bus.Is_Powered (A_Bus) = False;
               Test_12 := Bus.Load (A_Bus) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
            end if;
            In_Third_Quarter := False;

         else

            Voltage_To_Bus := 28.0;
            Load_On_Bus    := 11.0;

            Bus.Update
              (An_Instance => A_Bus,
               Voltage     => Voltage_To_Bus,
               Load        => Load_On_Bus);

            if In_Fourth_Quarter then
               Test_13 := Bus.Voltage (A_Bus) = 28.0;
               Test_14 := Bus.Is_Powered (A_Bus) = True;
               Test_15 := Bus.Load (A_Bus) = 11.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
            end if;
            In_Fourth_Quarter := False;

         end if;


      end loop;


   end;

end Bus_G_Ctd;
