-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Bus_G;
with Bus_Collection_G;

procedure Bus_Collection_G_Ctd is



begin


   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Bus is new Bus_G
        (Voltage_Type => Float,
         Ampere_Type => Float,
         Powered_Voltage_Threshold => 5.0);
      type Bus_Name_Type is (Bus_A, Bus_B, Bus_C);
      type Bus_Array is array (Bus_Name_Type) of Bus.Instance;
      type Bus_Vdc_Array is array (Bus_Name_Type) of Float;
      type Bus_Load_Array is array (Bus_Name_Type) of Float;
      package Bus_Collection is new Bus_Collection_G
        (Voltage_Type          => Float,
         Ampere_Type           => Float,
         Bus_Name_Type         => Bus_Name_Type,
         Bus_Type              => Bus.Instance,
         Array_Of_Bus_Type     => Bus_Array,
         Array_Of_Bus_Voltages => Bus_Vdc_Array,
         Array_Of_Bus_Loads    => Bus_Load_Array,
         Power_A_Bus           => Bus.Power,
         Unpower_A_Bus         => Bus.Unpower,
         Set_A_Bus_Load        => Bus.Set_Load,
         A_Bus_Voltage         => Bus.Voltage,
         A_Bus_Is_Powered      => Bus.Is_Powered,
         A_Bus_Load            => Bus.Load,
         Update_A_Bus          => Bus.Update,
         Initialize_A_Bus      => Bus.Initialize);

      A_Bus_collection : Bus_Collection.Instance;
      The_Voltages : Bus_Vdc_Array;
      The_Loads    : Bus_Load_Array;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;
      Test_16 : Boolean;
      Test_17 : Boolean;
      Test_18 : Boolean;
      Test_19 : Boolean;
      Test_20 : Boolean;
      Test_21 : Boolean;
      Test_22 : Boolean;
      Test_23 : Boolean;
      Test_24 : Boolean;
      Test_25 : Boolean;
      Test_26 : Boolean;
      Test_27 : Boolean;
      Test_28 : Boolean;
      Test_29 : Boolean;
      Test_30 : Boolean;
      Test_31 : Boolean;
      Test_32 : Boolean;
      Test_33 : Boolean;
      Test_34 : Boolean;
      Test_35 : Boolean;
      Test_36 : Boolean;
      Test_37 : Boolean;
      Test_38 : Boolean;
      Test_39 : Boolean;
      Test_40 : Boolean;
      Test_41 : Boolean;
      Test_42 : Boolean;
      Test_43 : Boolean;
      Test_44 : Boolean;
      Test_45 : Boolean;

   begin

      Bus_Collection.Initialize (A_Bus_Collection);

      Test_1 := Bus_Collection.Voltage (A_Bus_Collection,Bus_A) = 0.0;
      Test_2 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_A) = False;
      Test_3 := Bus_Collection.Load (A_Bus_Collection,Bus_A) = 0.0;
      Test_4 := Bus_Collection.Voltage (A_Bus_Collection,Bus_B) = 0.0;
      Test_5 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_B) = False;
      Test_6 := Bus_Collection.Load (A_Bus_Collection,Bus_B) = 0.0;
      Test_7 := Bus_Collection.Voltage (A_Bus_Collection,Bus_C) = 0.0;
      Test_8 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_C) = False;
      Test_9 := Bus_Collection.Load (A_Bus_Collection,Bus_C) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
      Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
      Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
      Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
      Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
      Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            for Name in Bus_Name_Type
            loop
               if Name = Bus_A then
                  The_Voltages (Name) := 28.0;
                  The_Loads (Name)    := 10.0;
               end if;
               if Name = Bus_B then
                  The_Voltages (Name) := 24.0;
                  The_Loads (Name)    := 5.0;
               end if;
               if Name = Bus_C then
                  The_Voltages (Name) := 0.0;
                  The_Loads (Name)    := 0.0;
               end if;
            end loop;

            Bus_Collection.Update
              (An_Instance  => A_Bus_Collection,
               Bus_Voltages => The_Voltages,
               Bus_Loads    => The_Loads);

            if In_First_Quarter then
               Test_10 := Bus_Collection.Voltage (A_Bus_Collection,Bus_A) = 28.0;
               Test_11 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_A) = True;
               Test_12 := Bus_Collection.Load (A_Bus_Collection,Bus_A) = 10.0;
               Test_13 := Bus_Collection.Voltage (A_Bus_Collection,Bus_B) = 24.0;
               Test_14 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_B) = True;
               Test_15 := Bus_Collection.Load (A_Bus_Collection,Bus_B) = 5.0;
               Test_16 := Bus_Collection.Voltage (A_Bus_Collection,Bus_C) = 0.0;
               Test_17 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_C) = False;
               Test_18 := Bus_Collection.Load (A_Bus_Collection,Bus_C) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
            end if;
            In_First_Quarter := False;

         elsif Now < Two_Quarter_Time then

            for Name in Bus_Name_Type
            loop
               if Name = Bus_A then
                  The_Voltages (Name) := 27.0;
                  The_Loads (Name)    := 11.0;
               end if;
               if Name = Bus_B then
                  The_Voltages (Name) := 28.0;
                  The_Loads (Name)    := 3.0;
               end if;
               if Name = Bus_C then
                  The_Voltages (Name) := 28.0;
                  The_Loads (Name)    := 10.0;
               end if;
            end loop;

            Bus_Collection.Update
              (An_Instance  => A_Bus_Collection,
               Bus_Voltages => The_Voltages,
               Bus_Loads    => The_Loads);

            if In_Second_Quarter then
               Test_19 := Bus_Collection.Voltage (A_Bus_Collection,Bus_A) = 27.0;
               Test_20 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_A) = True;
               Test_21 := Bus_Collection.Load (A_Bus_Collection,Bus_A) = 11.0;
               Test_22 := Bus_Collection.Voltage (A_Bus_Collection,Bus_B) = 28.0;
               Test_23 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_B) = True;
               Test_24 := Bus_Collection.Load (A_Bus_Collection,Bus_B) = 3.0;
               Test_25 := Bus_Collection.Voltage (A_Bus_Collection,Bus_C) = 28.0;
               Test_26 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_C) = True;
               Test_27 := Bus_Collection.Load (A_Bus_Collection,Bus_C) = 10.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
               Class_Test_Result_File.Report_Case_Status (Success => Test_26, Number => 26);
               Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);
            end if;
            In_Second_Quarter := False;

         elsif Now < Three_Quarter_Time then

            for Name in Bus_Name_Type
            loop
               if Name = Bus_A then
                  The_Voltages (Name) := 4.0;
                  The_Loads (Name)    := 10.0;
               end if;
               if Name = Bus_B then
                  The_Voltages (Name) := 28.0;
                  The_Loads (Name)    := 10.0;
               end if;
               if Name = Bus_C then
                  The_Voltages (Name) := 0.0;
                  The_Loads (Name)    := 0.0;
               end if;
            end loop;

            Bus_Collection.Update
              (An_Instance  => A_Bus_Collection,
               Bus_Voltages => The_Voltages,
               Bus_Loads    => The_Loads);

            if In_Third_Quarter then
               Test_28 := Bus_Collection.Voltage (A_Bus_Collection,Bus_A) = 4.0;
               Test_29 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_A) = False;
               Test_30 := Bus_Collection.Load (A_Bus_Collection,Bus_A) = 10.0;
               Test_31 := Bus_Collection.Voltage (A_Bus_Collection,Bus_B) = 28.0;
               Test_32 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_B) = True;
               Test_33 := Bus_Collection.Load (A_Bus_Collection,Bus_B) = 10.0;
               Test_34 := Bus_Collection.Voltage (A_Bus_Collection,Bus_C) = 0.0;
               Test_35 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_C) = False;
               Test_36 := Bus_Collection.Load (A_Bus_Collection,Bus_C) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_28, Number => 28);
               Class_Test_Result_File.Report_Case_Status (Success => Test_29, Number => 29);
               Class_Test_Result_File.Report_Case_Status (Success => Test_30, Number => 30);
               Class_Test_Result_File.Report_Case_Status (Success => Test_31, Number => 31);
               Class_Test_Result_File.Report_Case_Status (Success => Test_32, Number => 32);
               Class_Test_Result_File.Report_Case_Status (Success => Test_33, Number => 33);
               Class_Test_Result_File.Report_Case_Status (Success => Test_34, Number => 34);
               Class_Test_Result_File.Report_Case_Status (Success => Test_35, Number => 35);
               Class_Test_Result_File.Report_Case_Status (Success => Test_36, Number => 36);
            end if;
            In_Third_Quarter := False;

         else

            for Name in Bus_Name_Type
            loop
               if Name = Bus_A then
                  The_Voltages (Name) := 0.0;
                  The_Loads (Name)    := 0.0;
               end if;
               if Name = Bus_B then
                  The_Voltages (Name) := 1.0;
                  The_Loads (Name)    := 5.0;
               end if;
               if Name = Bus_C then
                  The_Voltages (Name) := 28.0;
                  The_Loads (Name)    := 10.0;
               end if;
            end loop;

            Bus_Collection.Update
              (An_Instance  => A_Bus_Collection,
               Bus_Voltages => The_Voltages,
               Bus_Loads    => The_Loads);

            if In_Fourth_Quarter then
               Test_37 := Bus_Collection.Voltage (A_Bus_Collection,Bus_A) = 0.0;
               Test_38 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_A) = False;
               Test_39 := Bus_Collection.Load (A_Bus_Collection,Bus_A) = 0.0;
               Test_40 := Bus_Collection.Voltage (A_Bus_Collection,Bus_B) = 1.0;
               Test_41 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_B) = False;
               Test_42 := Bus_Collection.Load (A_Bus_Collection,Bus_B) = 5.0;
               Test_43 := Bus_Collection.Voltage (A_Bus_Collection,Bus_C) = 28.0;
               Test_44 := Bus_Collection.Is_Powered (A_Bus_Collection,Bus_C) = True;
               Test_45 := Bus_Collection.Load (A_Bus_Collection,Bus_C) = 10.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_37, Number => 37);
               Class_Test_Result_File.Report_Case_Status (Success => Test_38, Number => 38);
               Class_Test_Result_File.Report_Case_Status (Success => Test_39, Number => 39);
               Class_Test_Result_File.Report_Case_Status (Success => Test_40, Number => 40);
               Class_Test_Result_File.Report_Case_Status (Success => Test_41, Number => 41);
               Class_Test_Result_File.Report_Case_Status (Success => Test_42, Number => 42);
               Class_Test_Result_File.Report_Case_Status (Success => Test_43, Number => 43);
               Class_Test_Result_File.Report_Case_Status (Success => Test_44, Number => 44);
               Class_Test_Result_File.Report_Case_Status (Success => Test_45, Number => 45);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;
   end;

end Bus_Collection_G_Ctd;


