-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Auxiliary_Battery_Mount_G;

procedure Auxiliary_Battery_Mount_G_Ctd is
begin


   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Mount is new Auxiliary_Battery_Mount_G (Float);
      A_Mount : Mount.Instance;

      Voltage_Into_Mount_From_Fwd_Batt_Bus : Float;
      Auxiliary_Batt_Voltage_Into_Mount    : Float;
      Lights_In                            : Boolean;

      Lights_Out_Last_Pass  : Boolean := False;
      Voltage_Out_Last_Pass : Float   := 0.0;
      Voltage_In_Last_Pass  : Float   := 0.0;
      Is_Powered_Last_Pass  : Boolean := False;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;
      Test_16 : Boolean;
      Test_17 : Boolean;
      Test_18 : Boolean;
      Test_19 : Boolean;
      Test_20 : Boolean;

   begin

      Mount.Initialize (A_Mount);

      Test_1 := Mount.Lights_Out (A_Mount)  = False;
      Test_2 := Mount.Voltage_Out (A_Mount) = 0.0;
      Test_3 := Mount.Voltage_In (A_Mount)  = 0.0;
      Test_4 := Mount.Is_Powered (A_Mount)  = False;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Voltage_Into_Mount_From_Fwd_Batt_Bus := 0.0;
            Auxiliary_Batt_Voltage_Into_Mount    := 0.0;
            Lights_In                            := False;

            Mount.Update
              (An_Instance                  => A_Mount,
               Volts_28_In                  => Voltage_Into_Mount_From_Fwd_Batt_Bus,
               Volts_5_In                   => Lights_In,
               Auxiliary_Battery_Voltage_In => Auxiliary_Batt_Voltage_Into_Mount);

         if In_First_Quarter then

            Test_5 := Mount.Lights_Out (A_Mount)  = False;
            Test_6 := Mount.Voltage_Out (A_Mount) = 0.0;
            Test_7 := Mount.Voltage_In (A_Mount)  = 0.0;
            Test_8 := Mount.Is_Powered (A_Mount)  = False;
            Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
            Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
            Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
            Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);

         end if;
         In_First_Quarter := False;


         elsif Now < Two_Quarter_Time then

            Voltage_Into_Mount_From_Fwd_Batt_Bus := 28.0;
            Auxiliary_Batt_Voltage_Into_Mount    := 24.0;
            Lights_In                            := False;

            Mount.Update
              (An_Instance                  => A_Mount,
               Volts_28_In                  => Voltage_Into_Mount_From_Fwd_Batt_Bus,
               Volts_5_In                   => Lights_In,
               Auxiliary_Battery_Voltage_In => Auxiliary_Batt_Voltage_Into_Mount);

         if In_second_Quarter then

            Test_9  := Mount.Lights_Out (A_Mount)  = False;
            Test_10 := Mount.Voltage_Out (A_Mount) = 28.0;
            Test_11 := Mount.Voltage_In (A_Mount)  = 28.0;
            Test_12 := Mount.Is_Powered (A_Mount)  = True;
            Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
            Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
            Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
            Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);

         end if;
         In_second_Quarter := False;

         elsif Now < Three_Quarter_Time then

            Voltage_Into_Mount_From_Fwd_Batt_Bus := 10.0;
            Auxiliary_Batt_Voltage_Into_Mount    := 24.0;
            Lights_In                            := True;

            Mount.Update
              (An_Instance                  => A_Mount,
               Volts_28_In                  => Voltage_Into_Mount_From_Fwd_Batt_Bus,
               Volts_5_In                   => Lights_In,
               Auxiliary_Battery_Voltage_In => Auxiliary_Batt_Voltage_Into_Mount);

            if In_third_Quarter then

               Test_13 := Mount.Lights_Out (A_Mount)  = True;
               Test_14 := Mount.Voltage_Out (A_Mount) = 24.0;
               Test_15 := Mount.Voltage_In (A_Mount)  = 10.0;
               Test_16 := Mount.Is_Powered (A_Mount)  = True;
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);

            end if;
            In_third_Quarter := False;

         else

            Voltage_Into_Mount_From_Fwd_Batt_Bus := 24.0;
            Auxiliary_Batt_Voltage_Into_Mount    := 24.0;
            Lights_In                            := False;

            Mount.Update
              (An_Instance                  => A_Mount,
               Volts_28_In                  => Voltage_Into_Mount_From_Fwd_Batt_Bus,
               Volts_5_In                   => Lights_In,
               Auxiliary_Battery_Voltage_In => Auxiliary_Batt_Voltage_Into_Mount);

            if In_Fourth_Quarter then

               Test_17 := Mount.Lights_Out (A_Mount)  = False;
               Test_18 := Mount.Voltage_Out (A_Mount) = 24.0;
               Test_19 := Mount.Voltage_In (A_Mount)  = 24.0;
               Test_20 := Mount.Is_Powered (A_Mount)  = True;
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);

            end if;
            In_Fourth_Quarter := False;



         end if;

         -- transition analysis

         Lights_Out_Last_Pass  := Mount.Lights_Out (A_Mount);
         Voltage_Out_Last_Pass := Mount.Voltage_Out (A_Mount);
         Voltage_In_Last_Pass  := Mount.Voltage_In (A_Mount);
         Is_Powered_Last_Pass  := Mount.Is_Powered (A_Mount);

      end loop;


   end;

end Auxiliary_Battery_Mount_G_Ctd;





