-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Nacws_Threat_Control;
with Ada.Text_Io,
  Avionics_Types,
  Jpats_Avionics_Types,
  Coordinate_Types;
with Class_Test_Result_File;
use Ada.Text_Io,Nacws_Threat_Control;

procedure Nacws_Threat_Control_Ct is

   package Jat renames Jpats_Avionics_Types;



   Ground_Elevation          : Float;
   Aircraft_Position         : Jat.Position_Type;
   True_Heading              : Jat.Bearing_Type;
   Reposition_Active         : Boolean;
   Earth_Axis_Velocity       : Jat.Attitude_Rate_Type;
   Body_Axis_Velocity        : Jat.Attitude_Rate_Type;
   Rate_Of_Climb             : Float;
   Weight_On_Wheels          : Boolean;
   Nacws_Active              : Boolean;
   Nacws_Page_Start_Button   : Jat.Ios_Boolean_Type;
   Nacws_Page_Aircraft_Type  : Jat.Ios_Aircraft_Type;
   Nacws_Page_Bearing        : Jat.Ios_Float_Type;
   Nacws_Page_Distance       : Jat.Ios_Float_Type;
   Nacws_Page_Altitude       : Jat.Ios_Float_Type;
   Nacws_Page_Time           : Jat.Ios_Float_Type;
   Nacws_Page_Vert_Pos       : Jat.Ios_Vertical_Type;
   Nacws_Page_Speed          : Jat.Ios_Float_Type;
   Nacws_Page_Closure        : Jat.Ios_Float_Type;
   Nacws_Alt_Layer_Table     : Jat.Nacws_Altitude_Table_Type;
   Nacws_Zthr_Table          : Jat.Nacws_Altitude_Table_Type;
   Nacws_Tau_Table           : Jat.Nacws_Tau_Table_Type;
   Nacws_Dmod_Table          : Jat.Nacws_Tau_Table_Type;
   Flight_Freeze             : Boolean;
   Solution_Found            : Jat.Ios_Integer_Type;
   Solution_Reverse          : Jat.Ios_Boolean_Type;
   results                   : Jat.Intruder_Drive_Array_Type;
   Initial_Position_Pass     : Boolean;
   Final_Position_Pass       : Boolean;

   Time : Float := 0.0;
   Iconst : Float := 1.0/10.0;
   The_Threat : Nacws_Threat_Control.Instance;

   type Cases is array (1 .. 8) of Integer;

   type Heading_Array is array (Cases'range) of Avionics_Types.Heading_Type;

   Heading : constant Heading_Array := (0.0,45.0,90.0,135.0,180.0,
                                        -135.0,-90.0,-45.0);

   type Velocity_Array is array (Cases'Range) of Jat.Attitude_Rate_Type;

   Velocity : constant Velocity_Array :=
     (( 337.5,   0.0,0.0),
      ( 238.6, 238.6,0.0),
      (   0.0, 337.5,0.0),
      (-238.6, 238.6,0.0),
      (-337.5,   0.0,0.0),
      (-238.6,-238.6,0.0),
      (   0.0,-337.5,0.0),
      ( 238.6,-238.6,0.0));

   type Results_Array is array (Cases'Range) of Jat.Position_Type;

   Initial_Position : constant Results_Array :=
     ((4.55556E+01,-4.50000E+01,0.0),
      (4.53928E+01,-4.44425E+01,0.0),
      (4.50000E+01,-4.42142E+01,0.0),
      (4.46072E+01,-4.44463E+01,0.0),
      (4.44444E+01,-4.50000E+01,0.0),
      (4.46072E+01,-4.55537E+01,0.0),
      (4.50000E+01,-4.57858E+01,0.0),
      (4.53928E+01,-4.55575E+01,0.0));

   Final_Position : constant Results_Array :=
     ((4.52778E+01,-4.50000E+01,0.0),
      (4.51963E+01,-4.47224E+01,0.0),
      (4.50000E+01,-4.46071E+01,0.0),
      (4.48036E+01,-4.47222E+01,0.0),
      (4.47222E+01,-4.50000E+01,0.0),
      (4.48036E+01,-4.52778E+01,0.0),
      (4.50000E+01,-4.53929E+01,0.0),
      (4.51964E+01,-4.52778E+01,0.0));

begin

   for I in Cases'Range loop

      Nacws_Threat_Control.Init(The_Threat);
      Time := 0.0;

      Ground_Elevation          := 1000.0;
      Aircraft_Position.latitude  := 45.0;
      Aircraft_Position.Longitude := -45.0;
      Aircraft_Position.Altitude  := 5000.0;
      True_Heading              := Heading(I);
      Reposition_Active         := False;
      Earth_Axis_Velocity.X     := Velocity(I).X;
      Earth_Axis_Velocity.y     := Velocity(I).Y;
      Earth_Axis_Velocity.Z     := 0.0;
      Body_Axis_Velocity.X      := 0.0;
      Body_Axis_Velocity.Y      := 0.0;
      Body_Axis_Velocity.Z      := 0.0;
      Rate_Of_Climb             := 0.0;
      Weight_On_Wheels          := False;
      Nacws_Active              := False;
      Nacws_Page_Start_Button   := (True,False);
      --   Nacws_Page_Aircraft_Type  :=
      Nacws_Page_Bearing        := (0.0,0.0);
      Nacws_Page_Distance       := (0.0,0.0);
      Nacws_Page_Altitude       := (5000.0,0.0);
      Nacws_Page_Time           := (5.0,5.0);
      Nacws_Page_Vert_Pos       := (Jat.Level,Jat.Level);
      Nacws_Page_Speed          := (200.0,200.0);
      Nacws_Page_Closure        := (0.0,0.0);

--      Nacws_Page_Aircraft_Type  := Jat.Ios_Aircraft_Type;
--      Nacws_Alt_Layer_Table     := Jat.Nacws_Altitude_Table_Type;
--      Nacws_Zthr_Table          := Jat.Nacws_Altitude_Table_Type;
--      Nacws_Tau_Table           := Jat.Nacws_Tau_Table_Type;
--      Nacws_Dmod_Table          := Jat.Nacws_Tau_Table_Type;
      Flight_Freeze             := False;
      Solution_Found            := (0,0);
      Solution_Reverse          := (False,False);


      Set_Ground_Elevation(The_Threat,Ground_Elevation);
      Set_Aircraft_Position(The_Threat,Aircraft_Position);
      Set_True_Heading(The_Threat,True_Heading);
      Set_Reposition_Active(The_Threat,Reposition_Active);
      Set_Earth_Axis_Velocity(The_Threat,Earth_Axis_Velocity);
      Set_Body_Axis_Velocity(The_Threat,Body_Axis_Velocity);
      Set_Rate_Of_Climb(The_Threat,Rate_Of_Climb);
      Set_Weight_On_Wheels(The_Threat,Weight_On_Wheels);
      Set_Nacws_Active(The_Threat,Nacws_Active);
      Set_Nacws_Page_Start_Button(The_Threat,Nacws_Page_Start_Button);
      Set_Nacws_Page_Aircraft_Type(The_Threat,Nacws_Page_Aircraft_Type);
      Set_Nacws_Page_Bearing(The_Threat,Nacws_Page_Bearing);
      Set_Nacws_Page_Distance(The_Threat,Nacws_Page_Distance);
      Set_Nacws_Page_Altitude(The_Threat,Nacws_Page_Altitude);
      Set_Nacws_Page_Time(The_Threat,Nacws_Page_Time);
      Set_Nacws_Page_Vert_Pos(The_Threat,Nacws_Page_Vert_Pos);
      Set_Nacws_Page_Speed(The_Threat,Nacws_Page_Speed);
      Set_Nacws_Page_Closure(The_Threat,Nacws_Page_Closure);
      Set_Flight_Freeze(The_Threat,Flight_Freeze);
      Set_Solution_Found(The_Threat,Solution_Found);
      Set_Solution_Reverse(The_Threat,Solution_Reverse);


      loop
         Aircraft_Position.Latitude := Aircraft_Position.Latitude +
           Long_Float(Velocity(I).X*Iconst/364566.0);

         Aircraft_Position.Longitude := Aircraft_Position.Longitude +
           Long_Float(Velocity(I).Y*Iconst/364566.0/0.707);



         Set_Aircraft_Position(The_Threat,Aircraft_Position);


         Nacws_Threat_Control.Update(Iconst      => Iconst,
                                     An_Instance => The_Threat);

         if Time = 0.0 then
            Initial_Position_Pass := False;
            Results := Intruder_Drive(The_Threat);
            Initial_Position_Pass :=
              abs(Results(1).Lat - Initial_Position(I).Latitude) < 0.01 and
              abs(Results(1).Lon - Initial_Position(I).Longitude) < 0.01;

            if Initial_Position_Pass then
               Put("initial position pass");
            else
               Put("initial position fail");
            end if;

         end if;

         Time := Time + Iconst;

         if Time >=  Nacws_Page_Time(1) * 60.0 then
            Final_Position_Pass := False;
            Results := Intruder_Drive(The_Threat);
            Final_Position_Pass :=
              abs(Results(1).Lat - Final_Position(I).Latitude) < 0.01 and
              abs(Results(1).Lon - Final_Position(I).Longitude) < 0.01;

            if Final_Position_Pass and Initial_Position_Pass then
               Put_Line("pass");
               Class_Test_Result_File.Report_Case_Status (true);
            else
               Put_Line("fail");
               Class_Test_Result_File.Report_Case_Status (false);
            end if;

         end if;
         exit when Time >=  Nacws_Page_Time(1) * 60.0;

      end loop;

   end loop;

end;

