-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Nacws;
with Ada.Text_Io,
  Avionics_Types,
  Jpats_Avionics_Types,
  Coordinate_Types,
  Length_Types;
with Class_Test_Result_File;
use Ada.Text_Io,Nacws,Jpats_Avionics_Types;

procedure Nacws_Ct is

   package Jat renames Jpats_Avionics_Types;

   Power                  : Boolean;
   Aircraft_Position      : Jpats_Avionics_Types.Position_Type;
   Ground_Elevation       : Length_Types.Feet;
   Rate_Of_Climb          : Length_Types.Feet_per_Min;
   Geometric_Altitude     : Length_Types.Feet;
   Reposition_In_Progress : Boolean;
   Adc_Valid              : Boolean;
   Adc_Corrected_Altitude : Length_Types.Feet;
   Adc_Vertical_Speed     : Length_Types.Feet_per_Min;
   Weight_On_Wheels       : Boolean;
   Intruder_Drive         : Jat.Intruder_Drive_Array_Type;
   Gps_Valid              : Boolean;
   Ahrs_Valid             : Boolean;
   Ahrs_True_Heading      : Float;
   Transponder_Mode       : Jat.Xpdr_Mode_Select_Type;
   Flight_Freeze          : Boolean;
   Proximity_Sw           : Boolean;
   Range_Sw               : Boolean;
   Nacws_Sw_Off           : Boolean;
   Display                   : Jat.Nacws_Display_Type;

   Time : Float := 0.0;
   Iconst : Float := 1.0/10.0;
   The_Nacws : Nacws.Instance;

   type Cases is array (1 .. 8) of Integer;

   type Velocity_Array is array (Cases'Range) of Jat.Attitude_Rate_Type;

   Velocity : constant Velocity_Array :=
     (( 337.5,   0.0,0.0),
      ( 238.6, 238.6,0.0),
      (   0.0, 337.5,0.0),
      (-238.6, 238.6,0.0),
      (-337.5,   0.0,0.0),
      (-238.6,-238.6,0.0),
      (   0.0,-337.5,0.0),
      ( 238.6,-238.6,0.0));

   type Results_Array is array (Cases'Range) of Jat.Position_Type;

   Initial_Position : constant Results_Array :=
     ((44.9,-45.0,0.0),
      (44.9,-45.1,0.0),
      (45.0,-45.1,0.0),
      (45.1,-45.1,0.0),
      (45.1,-45.0,0.0),
      (45.1,-44.9,0.0),
      (45.0,-44.9,0.0),
      (44.9,-44.9,0.0));

begin

   for I in Cases'Range loop

      Nacws.Init(The_Nacws);
      Time := 0.0;

      Power                  := True;
      Aircraft_Position.Latitude :=   45.0;
      Aircraft_Position.Longitude := -45.0;
      Ground_Elevation       := 1000.0;
      Rate_Of_Climb          := 0.0;
      Geometric_Altitude     := 5000.0;
      Reposition_In_Progress := False;
      Adc_Valid              := True;
      Adc_Corrected_Altitude := 5000.0;
      Adc_Vertical_Speed     := 0.0;
      Weight_On_Wheels       := True;

      Intruder_Drive(1).Aircraft := Jat.Ank_B737;
      Intruder_Drive(1).Lat                := Initial_Position(I).Latitude;
      Intruder_Drive(1).Lon                := Initial_Position(I).Longitude;
      Intruder_Drive(1).Active             := True;
      Intruder_Drive(1).Altitude           := 5000.0;
      Intruder_Drive(1).Heading            := 180.0;
      Intruder_Drive(1).Completion_Percent := 50.0;
      Intruder_Drive(1).Brg_From_Sim       := 0.0;
      Intruder_Drive(1).Dst_From_Sim       := 0.0;
      Intruder_Drive(1).Roll               := 0.0;
      Intruder_Drive(1).Pitch              := 0.0;
      Intruder_Drive(2).Aircraft           := Jat.Ank_B737;
      Intruder_Drive(2).Lat                := 45.0;
      Intruder_Drive(2).Lon                := -44.5;
      Intruder_Drive(2).Active             := True;
      Intruder_Drive(2).Altitude           := 4000.0;
      Intruder_Drive(2).Heading            := 0.0;
      Intruder_Drive(2).Completion_Percent := 0.0;
      Intruder_Drive(2).Brg_From_Sim       := 0.0;
      Intruder_Drive(2).Dst_From_Sim       := 0.0;
      Intruder_Drive(2).Roll               := 0.0;
      Intruder_Drive(2).Pitch              := 0.0;

      Gps_Valid              := True;
      Ahrs_Valid             := True;
      Ahrs_True_Heading      := 0.0;
      Transponder_Mode       := Jat.Ta;
      Flight_Freeze          := False;
      Proximity_Sw           := False;
      Range_Sw               := False;
      Nacws_Sw_Off           := False;

      Set_Power(The_Nacws,Power);
      Set_Aircraft_Position(The_Nacws,Aircraft_Position);
      Set_Ground_Elevation(The_Nacws,Ground_Elevation);
      Set_Rate_Of_Climb(The_Nacws,Rate_Of_Climb );
      Set_Geometric_Altitude(The_Nacws,Geometric_Altitude);
      Set_Reposition_In_Progress(The_Nacws,Reposition_In_Progress);
      Set_Adc_Valid(The_Nacws,Adc_Valid);
      Set_Adc_Corrected_Altitude(The_Nacws,Adc_Corrected_Altitude);
      Set_Adc_Vertical_Speed(The_Nacws,Adc_Vertical_Speed);
      Set_Weight_On_Wheels(The_Nacws,Weight_On_Wheels);
      Set_Intruder_Drive(The_Nacws,Intruder_Drive);
      Set_Gps_Valid(The_Nacws,Gps_Valid);
      Set_Ahrs_Valid(The_Nacws,Ahrs_Valid);
      Set_Ahrs_True_Heading(The_Nacws,Ahrs_True_Heading);
      Set_Transponder_Mode(The_Nacws,Transponder_Mode);
      Set_Flight_Freeze(The_Nacws,Flight_Freeze);
      Set_Proximity_Sw(The_Nacws,Proximity_Sw );
      Set_Range_Sw(The_Nacws,Range_Sw);
      Set_Nacws_Sw_Off(The_Nacws,Nacws_Sw_Off);

      loop

         Time := Time + Iconst;

         Intruder_Drive(1).Lat := Intruder_Drive(1).Lat +
           Long_Float(Velocity(I).X*Iconst/364566.0);
         Intruder_Drive(1).Lon := Intruder_Drive(1).Lon +
           Long_Float(Velocity(I).Y*Iconst/364566.0/0.707);

         Set_Intruder_Drive(The_Nacws,Intruder_Drive);

         Nacws.Update(Iconst      => Iconst,
                      An_Instance => The_Nacws);

         Display := Nacws_Display(The_Nacws);

         if Display.Intr_Display(1) = Jat.Ta and Time <= 300.0 then
            Put_Line("pass");
            Class_Test_Result_File.Report_Case_Status (true);
            exit;
         elsif Time > 300.0 then
            Put_Line("fail");
            Class_Test_Result_File.Report_Case_Status (false);
            exit;
         end if;

      end loop;

   end loop;

end;

