-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ahrs;
with Ada.Text_Io,
  Avionics_Types,
  Jpats_Avionics_Types,
  Coordinate_Types;
with Class_Test_Result_File;
use Ada.Text_Io;

procedure Ahrs_Ct is

   package Jat renames Jpats_Avionics_Types;

   Attitude_Fail             : Boolean;
   Rate_Of_Turn_Fail         : Boolean;
   Magnetic_Sensor_Fail      : Boolean;
   Heading_Fail              : Boolean;
   Freeze_Selected           : Boolean;
   Weight_On_Wheels          : Boolean;
   Slew_Direction            : Ahrs.Slew_Direction_Type;
   Power                     : Boolean;
   Aircraft_Position         : Jat.Position_Type;
   Body_Axis_Velocity        : Coordinate_Types.Cartesian;
   Rapid_Align               : Boolean;
   Gyro_Mode                 : Ahrs.Gyro_Mode_Type;
   Stable : Boolean;
   Pass : Boolean;
   Heading_N1 : Float;
   Pitch_N1 : Float;
   Roll_N1 : Float;
   Time : Float := 0.0;
   Iconst : Float := 1.0/10.0;
   The_Ahrs : Ahrs.Instance;
   Display_Attitude : Avionics_Types.Attitude_Type;

   type Cases is array (1 .. 8) of Integer;

   type Heading_Array is array (Cases'range) of Avionics_Types.Heading_Type;

   Heading : constant Heading_Array := (0.0,45.0,90.0,135.0,180.0,
                                        -135.0,-90.0,-45.0);

   type attitude_Array is array (Cases'Range) of float;

   Pitch : constant attitude_Array := (0.0,10.0,20.0,30.0,
                                       40.0,-10.0,-20.0,-30.0);
   Roll  : constant Attitude_Array := (0.0,10.0,20.0,30.0,
                                       40.0,-10.0,-20.0,-30.0);



begin

   for I in Cases'Range loop

      Ahrs.Init(The_Ahrs);
      Time := 0.0;

      Attitude_Fail             := False;
      Rate_Of_Turn_Fail         := False;
      Magnetic_Sensor_Fail      := False;
      Heading_Fail              := false;
      Freeze_Selected           := false;
      Weight_On_Wheels          := true;
      Slew_Direction            := Ahrs.None;
      Power                     := true;
      Aircraft_Position.Latitude := 45.0;
      Aircraft_Position.Longitude := 45.0;
      Body_Axis_Velocity.x      := 0.0;
      Rapid_Align               := False;
      Gyro_Mode                 := Ahrs.Slave;

      while Time < 500.0 loop
         Time := Time + Iconst;

         Power := Time > 0.5;



         Ahrs.Set_Weight_On_Wheels(The_Ahrs,Weight_On_Wheels);
         Ahrs.Set_Slew_Direction(The_Ahrs,Slew_Direction);
         Ahrs.Set_Power(The_Ahrs,Power);
         Ahrs.Set_Magnetic_Heading(The_Ahrs,Heading(I));
         Ahrs.Set_Aircraft_Position(The_Ahrs,Aircraft_Position);
         Ahrs.Set_Aircraft_Pitch(The_Ahrs,Pitch(I));
         Ahrs.Set_Aircraft_Roll(The_Ahrs,Roll(I));
         Ahrs.Set_Body_Axis_Velocity(The_Ahrs,Body_Axis_Velocity);
         Ahrs.Set_Rapid_Align(The_Ahrs,Rapid_Align);
         Ahrs.Set_Gyro_Mode(The_Ahrs,Gyro_Mode);

         ahrs.Update(Iconst      => Iconst,
                     An_Instance => The_Ahrs);

         Display_Attitude := Ahrs.Attitude(The_Ahrs);

         Stable :=
           abs(Display_Attitude.Heading - Heading_N1) < 0.01 and
           abs(Display_Attitude.Pitch   - Pitch_N1)   < 0.01 and
           abs(Display_Attitude.Roll    - Roll_N1)    < 0.01 and
           Time > 120.0;
         Heading_N1 := Display_Attitude.Heading;
         Pitch_N1   := Display_Attitude.Pitch;
         Roll_N1    := Display_Attitude.Roll;

         if Stable then
            Pass :=
              abs(abs(Display_Attitude.Heading) - abs(Heading(I))) < 0.5 and
              abs(Display_Attitude.Pitch   - Pitch(I))   < 0.5 and
              abs(Display_Attitude.Roll    - Roll(I))    < 0.5;

            Class_Test_Result_File.Report_Case_Status (Pass);

            if Pass then
               Put_Line("Pass");
            else
               Put_Line("Fail");
            end if;

            exit;

         end if;

      end loop;
   end loop;
end;

