-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Torque_Trim;
with Angle_Types;
with Length_Types;
with Mass_Types;
with Force_Types;
with Class_Test_Result_File;

procedure EXECUTE_torque is

   An_Instance : Torque_Trim.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_Engine_Torque_Demand                :Float;
   A_Engine_Torque_of_Simulated_Aircraft :Float;
   A_Predefined_PLA_Trim_Demand          :Angle_Types.Degrees;
   A_Predefined_PLA_Trim_Valid           :Boolean;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Predefined_PLA_Trim_Demand := 999.0;
   A_Predefined_PLA_Trim_Valid  := false;

   Torque_Trim.Assign_Torque_Trim
     (A_Predefined_PLA_Trim_Demand ,
      A_Predefined_PLA_Trim_Valid  ,
      An_Instance                  );

   A_Engine_Torque_Demand                :=1099.9;
   A_Engine_Torque_of_Simulated_Aircraft := 1069.3;

   Torque_Trim.Set_Torque_Trim
     (A_Engine_Torque_Demand                ,
      A_Engine_Torque_of_Simulated_Aircraft ,
      An_Instance                           );

   --Torque_Trim.Assign_Torque_Trim
   --    (A_Predefined_PLA_Trim_Demand ,
   --     A_Predefined_PLA_Trim_Valid  ,
   --     An_Instance                  );

   put(Torque_Trim.Get_PLA_Trim_Demand(An_Instance )); put_line(" pla ");

   if Torque_Trim.Get_PLA_Trim_Valid(An_Instance ) then
      put_line(" pla on ");
   end if;

   Pass := abs(Torque_Trim.Get_PLA_Trim_Demand(An_Instance) - 1002.06) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line("--------------- CONSTRAINT -------------------");
   A_Engine_Torque_Demand                :=10000.0;
   A_Engine_Torque_of_Simulated_Aircraft :=10000.0;
   Torque_Trim.Set_Torque_Trim
     (A_Engine_Torque_Demand                ,
      A_Engine_Torque_of_Simulated_Aircraft ,
      An_Instance                           );
   put(Torque_Trim.Get_PLA_Trim_Demand(An_Instance )); put_line(" pla ");

   if Torque_Trim.Get_PLA_Trim_Valid(An_Instance ) then
      put_line(" pla on ");
   end if;

   Pass := abs(Torque_Trim.Get_PLA_Trim_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line("--------------- END -------------------");
   A_Engine_Torque_Demand                :=0.0;
   A_Engine_Torque_of_Simulated_Aircraft :=0.0;
   Torque_Trim.Set_Torque_Trim
     (A_Engine_Torque_Demand                ,
      A_Engine_Torque_of_Simulated_Aircraft ,
      An_Instance                           );
   put(Torque_Trim.Get_PLA_Trim_Demand(An_Instance )); put_line(" pla ");

   if Torque_Trim.Get_PLA_Trim_Valid(An_Instance ) then
      put_line(" pla on ");
   end if;

   Pass := abs(Torque_Trim.Get_PLA_Trim_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;






end EXECUTE_torque;

