-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Status;
with Class_Test_Result_File;

procedure EXECUTE_status is

   An_Instance  : Status.Instance;

   An_Integration_Constant : Float := 1.0/60.0;


   A_Test_Operating_State :Boolean;
   A_Test_Operating_Timer :Float;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Test_Operating_State := true;
   Status.Assign_State(A_Test_Operating_State,
                       An_Instance         );

   if Status.Get_Test_Operating_State(An_Instance) then
      put_line(" ok ");
   end if;

   A_Test_Operating_Timer := 5.467;
   Status.Assign_Timer(A_Test_Operating_Timer,
                       An_Instance         );

   Status.Set_Timer(An_Integration_Constant,
                    An_Instance            );


   put(Status.Get_Timer (An_Instance ));put_line(" time ");

   pass := abs(Status.Get_Timer (An_Instance) - 5.4836667) <= A_Tolerance;
   Class_Test_Result_file.Report_Case_Status(Pass);
   Pass := False;

   put_line("------------------ CONSTRAINT ----------------");

   A_Test_Operating_Timer := 1000.0;
   Status.Assign_Timer(A_Test_Operating_Timer,
                       An_Instance         );

   An_Integration_Constant := 1000.0;
   Status.Set_Timer(An_Integration_Constant,
                    An_Instance            );

   put(Status.Get_Timer (An_Instance ));put_line(" time ");

   pass := abs(Status.Get_Timer (An_Instance)) >= 0.0;
   Class_Test_Result_file.Report_Case_Status(Pass);
   Pass := False;


   put_line("------------------ END ----------------");

   A_Test_Operating_Timer := 0.0;
   Status.Assign_Timer(A_Test_Operating_Timer,
                       An_Instance         );

   An_Integration_Constant := 0.0;
   Status.Set_Timer(An_Integration_Constant,
                    An_Instance            );

   put(Status.Get_Timer (An_Instance ));put_line(" time ");

   pass := abs(Status.Get_Timer (An_Instance)) >= 0.0;
   Class_Test_Result_file.Report_Case_Status(Pass);
   Pass := False;





end EXECUTE_status;

