-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Side_Slip_Hold;
with Angle_Types;
with Length_Types;
with Class_Test_Result_File;

procedure EXECUTE_side_slip is

   An_Instance : Side_Slip_Hold.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_x_Velocity_Body_Axis_of_Simulated_Aircraft :Length_Types.Feet_per_Sec;
   A_y_Velocity_Body_Axis_of_Simulated_Aircraft :Length_Types.Feet_per_Sec;
   A_Roll_Angle_of_Simulated_Aircraft           :Angle_Types.Radians;
   A_Demand_Side_Slip_Angle                     :Angle_Types.Radians;
   A_Predefined_Lagged_Roll_Angle                                         :Angle_Types.Radians;
   A_Predefined_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft           :Float;   --| feet/sec2
   --| This is so since Raytheon's math model does not give y-Body axis acceleration of the simulated aircraft.
   A_Predefined_Roll_Angle_Demand                                         :Angle_Types.Radians;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_of_Simulated_Aircraft      :Length_Types.Feet_per_Sec;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft :Float;  --| feet/sec2
   A_Predefined_Roll_Hold                                                 :Boolean := False;
   A_Predefined_Yaw_Hold                                                  :Boolean := False;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Predefined_Lagged_Roll_Angle                                        := 0.453;
   A_Predefined_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft          := -0.0327;
   --| This is so since Raytheon's math model does not give y-Body axis acceleration of the simulated aircraft.
   A_Predefined_Roll_Angle_Demand                                        := -1.238;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_of_Simulated_Aircraft      := 0.37;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft := -0.198;

   Side_Slip_Hold.Assign_Side_Slip_Hold
     (A_Predefined_Lagged_Roll_Angle                                        ,
      A_Predefined_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft          ,
      --| This is so since Raytheon's math model does not give y-Body axis acceleration of the simulated aircraft.
      A_Predefined_Roll_Angle_Demand                                        ,
      A_Predefined_Last_Pass_y_Body_Axis_Velocity_of_Simulated_Aircraft      ,
      A_Predefined_Last_Pass_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft,
      A_Predefined_Roll_Hold                                                ,
      A_Predefined_Yaw_Hold                                                ,
      An_Instance                                                          );

   A_x_Velocity_Body_Axis_of_Simulated_Aircraft := -10.784;
   A_y_Velocity_Body_Axis_of_Simulated_Aircraft :=-1.64;
   A_Roll_Angle_of_Simulated_Aircraft          := 0.23;
   A_Demand_Side_Slip_Angle                    := -0.0567;

   Side_Slip_Hold.Set_Side_Slip_Hold
     (A_x_Velocity_Body_Axis_of_Simulated_Aircraft,
      A_y_Velocity_Body_Axis_of_Simulated_Aircraft,
      A_Roll_Angle_of_Simulated_Aircraft         ,
      An_Integration_Constant                    ,
      A_Demand_Side_Slip_Angle                    ,
      An_Instance                                );

   put(Side_Slip_Hold.Get_Roll_Angle_Demand(An_Instance)); put_line(" roll angle ");

   Pass := abs(Side_Slip_Hold.Get_Roll_Angle_Demand(An_Instance) - 0.36554777) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("--------------- CONSTRAINT --------------------");

   A_Predefined_Lagged_Roll_Angle                                        := 1000.0;
   A_Predefined_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft          := 1000.0;
   --| This is so since Raytheon's math model does not give y-Body axis acceleration of the simulated aircraft.
   A_Predefined_Roll_Angle_Demand                                        := 1000.0;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_of_Simulated_Aircraft      :=1000.0;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft := 1000.0;

   Side_Slip_Hold.Assign_Side_Slip_Hold
     (A_Predefined_Lagged_Roll_Angle                                        ,
      A_Predefined_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft          ,
      --| This is so since Raytheon's math model does not give y-Body axis acceleration of the simulated aircraft.
      A_Predefined_Roll_Angle_Demand                                        ,
      A_Predefined_Last_Pass_y_Body_Axis_Velocity_of_Simulated_Aircraft      ,
      A_Predefined_Last_Pass_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft,
      A_Predefined_Roll_Hold                                                ,
      A_Predefined_Yaw_Hold                                                ,
      An_Instance                                                          );

   A_x_Velocity_Body_Axis_of_Simulated_Aircraft := 1000.0;
   A_y_Velocity_Body_Axis_of_Simulated_Aircraft :=1000.0;
   A_Roll_Angle_of_Simulated_Aircraft          := 1000.0;
   A_Demand_Side_Slip_Angle                    := 1000.0;

   Side_Slip_Hold.Set_Side_Slip_Hold
     (A_x_Velocity_Body_Axis_of_Simulated_Aircraft,
      A_y_Velocity_Body_Axis_of_Simulated_Aircraft,
      A_Roll_Angle_of_Simulated_Aircraft         ,
      An_Integration_Constant                    ,
      A_Demand_Side_Slip_Angle                    ,
      An_Instance                                );

   put(Side_Slip_Hold.Get_Roll_Angle_Demand(An_Instance)); put_line(" roll angle ");

   Pass := abs(Side_Slip_Hold.Get_Roll_Angle_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("--------------- END --------------------");

   A_Predefined_Lagged_Roll_Angle                                        := 0.0;
   A_Predefined_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft          := 0.0;
   --| This is so since Raytheon's math model does not give y-Body axis acceleration of the simulated aircraft.
   A_Predefined_Roll_Angle_Demand                                        := 0.0;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_of_Simulated_Aircraft      :=0.0;
   A_Predefined_Last_Pass_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft := 0.0;

   Side_Slip_Hold.Assign_Side_Slip_Hold
     (A_Predefined_Lagged_Roll_Angle                                        ,
      A_Predefined_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft          ,
      --| This is so since Raytheon's math model does not give y-Body axis acceleration of the simulated aircraft.
      A_Predefined_Roll_Angle_Demand                                        ,
      A_Predefined_Last_Pass_y_Body_Axis_Velocity_of_Simulated_Aircraft      ,
      A_Predefined_Last_Pass_y_Body_Axis_Velocity_Rate_of_Simulated_Aircraft,
      A_Predefined_Roll_Hold                                                ,
      A_Predefined_Yaw_Hold                                                ,
      An_Instance                                                          );

   A_x_Velocity_Body_Axis_of_Simulated_Aircraft := 0.0;
   A_y_Velocity_Body_Axis_of_Simulated_Aircraft :=0.0;
   A_Roll_Angle_of_Simulated_Aircraft          := 0.0;
   A_Demand_Side_Slip_Angle                    := 0.0;

   Side_Slip_Hold.Set_Side_Slip_Hold
     (A_x_Velocity_Body_Axis_of_Simulated_Aircraft,
      A_y_Velocity_Body_Axis_of_Simulated_Aircraft,
      A_Roll_Angle_of_Simulated_Aircraft         ,
      An_Integration_Constant                    ,
      A_Demand_Side_Slip_Angle                    ,
      An_Instance                                );

   put(Side_Slip_Hold.Get_Roll_Angle_Demand(An_Instance)); put_line(" roll angle ");

   Pass := abs(Side_Slip_Hold.Get_Roll_Angle_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

end EXECUTE_side_slip;

