-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Special_Autopilot_Pitch;
with Special_Autopilot_Roll;
with Special_Autopilot_Yaw;
with Angle_Types;
with Length_Types;
with Mass_Types;
with Force_Types;
with Class_Test_Result_File;

procedure EXECUTE_sap is

   An_Instance_P  : Special_Autopilot_Pitch.Instance;
   An_Instance_R  : Special_Autopilot_Roll.Instance;
   An_Instance_Y  : Special_Autopilot_Yaw.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_Yaw_Angle_Demand                                     :Angle_Types.Radians;
   A_Yaw_Angle_of_Simulated_Aircraft                      :Angle_Types.Radians;
   A_Roll_Angle_of_Simulated_Aircraft                     :Angle_Types.Radians;
   A_Pitch_Angle_of_Simulated_Aircraft                    :Angle_Types.Radians;
   A_Yaw_Acceleration_of_Simulated_Aircraft               :Angle_Types.Radians_per_Sq_Sec;
   A_zz_Moment_of_Inertia_of_Simulated_Aircraft           :Mass_Types.Slugs_Feet_Sq;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft    :Force_Types.Pounds_per_Sq_Feet;
   A_Wing_Area_of_Simulated_Aircraft                      :Length_Types.Sq_Feet;
   A_Wing_Span_of_Simulated_Aircraft                      :Length_Types.Feet;
   A_Yaw_Moment_Coefficient_of_Rudder_to_Rudder_Position  :Float; --Will be of Horizontal Tail for JPATS
   A_Predefined_Rudder_Position_Demand                    :Angle_Types.Degrees;
   A_Predefined_Rudder_Position_Demand_Valid              :Boolean;
   A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft :Angle_Types.Radians;
   A_Predefined_Last_Pass_Yaw_Angle_Demand                :Angle_Types.Radians;
   A_Roll_Angle_Demand                                      :Angle_Types.Radians;
   A_Roll_Acceleration_of_Simulated_Aircraft                :Angle_Types.Radians_per_Sq_Sec;
   A_xx_Moment_of_Inertia_of_Simulated_Aircraft             :Mass_Types.Slugs_Feet_Sq;
   A_Roll_Moment_Coefficient_of_Aileron_to_Aileron_Position :Float;
   A_Predefined_Aileron_Position_Demand                    :Angle_Types.Degrees;
   A_Predefined_Aileron_Position_Demand_Vaild              :Boolean;
   A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft :Angle_Types.Radians;
   A_Predefined_Last_Pass_Roll_Angle_Demand                :Angle_Types.Radians;
   A_Pitch_Angle_Demand                                       :Angle_Types.Radians;
   A_Pitch_Acceleration_of_Simulated_Aircraft                 :Angle_Types.Radians_per_Sq_Sec;
   A_yy_Moment_of_Inertia_of_Simulated_Aircraft               :Mass_Types.Slugs_Feet_Sq;
   A_Mean_Aerodynamic_Chord_of_Simulated_Aircraft             :Length_Types.Feet;
   A_Pitch_Moment_Coefficient_of_Elevator_to_Elevator_Position :Float; --Will be of Horizontal Tail for JPATS
   A_Predefined_Elevator_Position_Demand                    :Angle_Types.Degrees;
   A_Predefined_Elevator_Position_Demand_Valid              :Boolean;
   A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft :Angle_Types.Radians;
   A_Predefined_Last_Pass_Pitch_Angle_Demand                :Angle_Types.Radians;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.001;

begin

   A_Predefined_Rudder_Position_Demand                    := 2.5;
   A_Predefined_Rudder_Position_Demand_Valid              := false;
   A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft := 0.03;
   A_Predefined_Last_Pass_Yaw_Angle_Demand                := -0.34;

   Special_Autopilot_Yaw.Assign_Special_Autopilot_Yaw
     (A_Predefined_Rudder_Position_Demand                    ,
      A_Predefined_Rudder_Position_Demand_Valid              ,
      A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Yaw_Angle_Demand                ,
      An_Instance_Y);


   A_Yaw_Angle_Demand                                      := -0.36;
   A_Yaw_Angle_of_Simulated_Aircraft                       := 0.01;
   A_Roll_Angle_of_Simulated_Aircraft                      := 0.21;
   A_Pitch_Angle_of_Simulated_Aircraft                     := -0.095;
   A_Yaw_Acceleration_of_Simulated_Aircraft                := -0.023369;
   A_zz_Moment_of_Inertia_of_Simulated_Aircraft            := 4659.6;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 85.6;
   A_Wing_Area_of_Simulated_Aircraft                       := 145.6;
   A_Wing_Span_of_Simulated_Aircraft                       := 33.42;
   A_Yaw_Moment_Coefficient_of_Rudder_to_Rudder_Position  := 0.526;
   Special_Autopilot_Yaw.Set_Special_Autopilot_Yaw
     (A_Yaw_Angle_Demand                                     ,
      A_Yaw_Angle_of_Simulated_Aircraft                      ,
      A_Roll_Angle_of_Simulated_Aircraft                     ,
      A_Pitch_Angle_of_Simulated_Aircraft                    ,
      A_Yaw_Acceleration_of_Simulated_Aircraft               ,
      A_zz_Moment_of_Inertia_of_Simulated_Aircraft           ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft    ,
      A_Wing_Area_of_Simulated_Aircraft                      ,
      A_Wing_Span_of_Simulated_Aircraft                      ,
      A_Yaw_Moment_Coefficient_of_Rudder_to_Rudder_Position  , --Will be of Horizontal Tail for JPATS
      An_Integration_Constant                                ,
      An_Instance_Y);

   --    Special_Autopilot_Yaw.Assign_Special_Autopilot_Yaw
   --        (A_Predefined_Rudder_Position_Demand                    ,
   --         A_Predefined_Rudder_Position_Demand_Valid              ,
   --         A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft ,
   --         A_Predefined_Last_Pass_Yaw_Angle_Demand                ,
   --         An_Instance_Y);

   put(Special_Autopilot_Yaw.Get_Position_Demand(An_Instance_Y));   put_line(" rudder ");

   if  Special_Autopilot_Yaw.Get_Position_Valid(An_Instance_Y) then
      put_line(" rudder on ");
   end if;

   A_Predefined_Aileron_Position_Demand                    := -0.26;
   A_Predefined_Aileron_Position_Demand_Vaild              := false;
   A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft := -0.86;
   A_Predefined_Last_Pass_Roll_Angle_Demand                := -0.987;

   Special_Autopilot_Roll.Assign_Special_Autopilot_Roll
     (A_Predefined_Aileron_Position_Demand                    ,
      A_Predefined_Aileron_Position_Demand_Vaild              ,
      A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Roll_Angle_Demand                ,
      An_Instance_R);

   A_Roll_Angle_Demand                                     := -0.963;
   A_Roll_Angle_of_Simulated_Aircraft                      := -0.88;
   A_Roll_Acceleration_of_Simulated_Aircraft               := -0.5423;
   A_xx_Moment_of_Inertia_of_Simulated_Aircraft            := 6125.68;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 85.6;
   A_Wing_Area_of_Simulated_Aircraft                       := 145.6;
   A_Wing_Span_of_Simulated_Aircraft                       := 33.42;
   A_Roll_Moment_Coefficient_of_Aileron_to_Aileron_Position := -0.269;

   Special_Autopilot_Roll.Set_Special_Autopilot_Roll
     (A_Roll_Angle_Demand                                      ,
      A_Roll_Angle_of_Simulated_Aircraft                       ,
      A_Roll_Acceleration_of_Simulated_Aircraft                ,
      A_xx_Moment_of_Inertia_of_Simulated_Aircraft             ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft      ,
      A_Wing_Area_of_Simulated_Aircraft                        ,
      A_Wing_Span_of_Simulated_Aircraft                        ,
      A_Roll_Moment_Coefficient_of_Aileron_to_Aileron_Position ,
      An_Integration_Constant                                  ,
      An_Instance_R);

   --    Special_Autopilot_Roll.Assign_Special_Autopilot_Roll
   --       (A_Predefined_Aileron_Position_Demand                    ,
   --         A_Predefined_Aileron_Position_Demand_Vaild              ,
   --         A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft ,
   --         A_Predefined_Last_Pass_Roll_Angle_Demand                ,
   --          An_Instance_R);



   put(Special_Autopilot_Roll.Get_Position_Demand(An_Instance_R));   put_line(" aileron ");

   if  Special_Autopilot_Roll.Get_Position_Valid(An_Instance_R) then
      put_line(" aileron on ");
   end if;




   A_Predefined_Elevator_Position_Demand                    := 2.69;
   A_Predefined_Elevator_Position_Demand_Valid              := false;
   A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft := -1.112;
   A_Predefined_Last_Pass_Pitch_Angle_Demand                := 1.012;

   Special_Autopilot_Pitch.Assign_Special_Autopilot_Pitch
     (A_Predefined_Elevator_Position_Demand                    ,
      A_Predefined_Elevator_Position_Demand_Valid              ,
      A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Pitch_Angle_Demand                ,
      An_Instance_P);

   A_Pitch_Angle_Demand                                       := 1.009;
   A_Pitch_Angle_of_Simulated_Aircraft                        := -1.1109;
   A_Roll_Angle_of_Simulated_Aircraft                         := -0.369;
   A_Pitch_Acceleration_of_Simulated_Aircraft                 := -0.26983;
   A_yy_Moment_of_Inertia_of_Simulated_Aircraft               := 456.9;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 85.6;
   A_Wing_Area_of_Simulated_Aircraft                       := 145.6;
   A_Mean_Aerodynamic_Chord_of_Simulated_Aircraft             := 12.5;
   A_Pitch_Moment_Coefficient_of_Elevator_to_Elevator_Position:= 0.16;

   Special_Autopilot_Pitch.Set_Special_Autopilot_Pitch
     (A_Pitch_Angle_Demand                                       ,
      A_Pitch_Angle_of_Simulated_Aircraft                        ,
      A_Roll_Angle_of_Simulated_Aircraft                         ,
      A_Pitch_Acceleration_of_Simulated_Aircraft                 ,
      A_yy_Moment_of_Inertia_of_Simulated_Aircraft               ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft        ,
      A_Wing_Area_of_Simulated_Aircraft                          ,
      A_Mean_Aerodynamic_Chord_of_Simulated_Aircraft             ,
      A_Pitch_Moment_Coefficient_of_Elevator_to_Elevator_Position, --Will be of Horizontal Tail for JPATS
      An_Integration_Constant                                    ,
      An_Instance_P);

   --    Special_Autopilot_Pitch.Assign_Special_Autopilot_Pitch
   --        (A_Predefined_Elevator_Position_Demand                    ,
   --         A_Predefined_Elevator_Position_Demand_Valid              ,
   --         A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft ,
   --         A_Predefined_Last_Pass_Pitch_Angle_Demand                ,
   --         An_Instance_P);



   put(Special_Autopilot_Pitch.Get_Position_Demand(An_Instance_P));   put_line(" elevator ");

   if  Special_Autopilot_Pitch.Get_Position_Valid(An_Instance_P) then
      put_line(" elevator on ");
   end if;


   pass := abs(Special_Autopilot_Yaw.Get_Position_Demand(An_Instance_Y) - 2.49608489) <= A_Tolerance and
     abs(Special_Autopilot_Roll.Get_Position_Demand(An_Instance_R) - (-0.28909567)) <= A_Tolerance and
     abs(Special_Autopilot_Pitch.Get_Position_Demand(An_Instance_P) - 2.72292581) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   pass := False;

   put_line("------------------ CONSTRAINT -----------------------");

   A_Predefined_Rudder_Position_Demand                    := 1000.0;
   A_Predefined_Rudder_Position_Demand_Valid              := false;
   A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft := 1000.0;
   A_Predefined_Last_Pass_Yaw_Angle_Demand                := 1000.0;

   Special_Autopilot_Yaw.Assign_Special_Autopilot_Yaw
     (A_Predefined_Rudder_Position_Demand                    ,
      A_Predefined_Rudder_Position_Demand_Valid              ,
      A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Yaw_Angle_Demand                ,
      An_Instance_Y);

   A_Yaw_Angle_Demand                                      := 1000.0;
   A_Yaw_Angle_of_Simulated_Aircraft                       := 1000.0;
   A_Roll_Angle_of_Simulated_Aircraft                      := 1000.0;
   A_Pitch_Angle_of_Simulated_Aircraft                     := 1000.0;
   A_Yaw_Acceleration_of_Simulated_Aircraft                := 1000.0;
   A_zz_Moment_of_Inertia_of_Simulated_Aircraft            := 10000.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 1000.0;
   A_Wing_Area_of_Simulated_Aircraft                       := 1000.0;
   A_Wing_Span_of_Simulated_Aircraft                       := 1000.0;
   A_Yaw_Moment_Coefficient_of_Rudder_to_Rudder_Position  := 1000.0;
   Special_Autopilot_Yaw.Set_Special_Autopilot_Yaw
     (A_Yaw_Angle_Demand                                     ,
      A_Yaw_Angle_of_Simulated_Aircraft                      ,
      A_Roll_Angle_of_Simulated_Aircraft                     ,
      A_Pitch_Angle_of_Simulated_Aircraft                    ,
      A_Yaw_Acceleration_of_Simulated_Aircraft               ,
      A_zz_Moment_of_Inertia_of_Simulated_Aircraft           ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft    ,
      A_Wing_Area_of_Simulated_Aircraft                      ,
      A_Wing_Span_of_Simulated_Aircraft                      ,
      A_Yaw_Moment_Coefficient_of_Rudder_to_Rudder_Position  , --Will be of Horizontal Tail for JPATS
      An_Integration_Constant                                ,
      An_Instance_Y);

   put(Special_Autopilot_Yaw.Get_Position_Demand(An_Instance_Y));   put_line(" rudder ");

   if  Special_Autopilot_Yaw.Get_Position_Valid(An_Instance_Y) then
      put_line(" rudder on ");
   end if;

   A_Predefined_Aileron_Position_Demand                    := 1000.0;
   A_Predefined_Aileron_Position_Demand_Vaild              := false;
   A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft := 1000.0;
   A_Predefined_Last_Pass_Roll_Angle_Demand                := 1000.0;

   Special_Autopilot_Roll.Assign_Special_Autopilot_Roll
     (A_Predefined_Aileron_Position_Demand                    ,
      A_Predefined_Aileron_Position_Demand_Vaild              ,
      A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Roll_Angle_Demand                ,
      An_Instance_R);

   A_Roll_Angle_Demand                                     := 1000.0;
   A_Roll_Angle_of_Simulated_Aircraft                      := 1000.0;
   A_Roll_Acceleration_of_Simulated_Aircraft               := 1000.0;
   A_xx_Moment_of_Inertia_of_Simulated_Aircraft            := 10000.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 1000.0;
   A_Wing_Area_of_Simulated_Aircraft                       := 1000.0;
   A_Wing_Span_of_Simulated_Aircraft                       := 1000.0;
   A_Roll_Moment_Coefficient_of_Aileron_to_Aileron_Position := 1000.0;

   Special_Autopilot_Roll.Set_Special_Autopilot_Roll
     (A_Roll_Angle_Demand                                      ,
      A_Roll_Angle_of_Simulated_Aircraft                       ,
      A_Roll_Acceleration_of_Simulated_Aircraft                ,
      A_xx_Moment_of_Inertia_of_Simulated_Aircraft             ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft      ,
      A_Wing_Area_of_Simulated_Aircraft                        ,
      A_Wing_Span_of_Simulated_Aircraft                        ,
      A_Roll_Moment_Coefficient_of_Aileron_to_Aileron_Position ,
      An_Integration_Constant                                  ,
      An_Instance_R);

   put(Special_Autopilot_Roll.Get_Position_Demand(An_Instance_R));   put_line(" aileron ");

   if  Special_Autopilot_Roll.Get_Position_Valid(An_Instance_R) then
      put_line(" aileron on ");
   end if;

   A_Predefined_Elevator_Position_Demand                    := 1000.0;
   A_Predefined_Elevator_Position_Demand_Valid              := false;
   A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft := 1000.0;
   A_Predefined_Last_Pass_Pitch_Angle_Demand                := 1000.0;

   Special_Autopilot_Pitch.Assign_Special_Autopilot_Pitch
     (A_Predefined_Elevator_Position_Demand                    ,
      A_Predefined_Elevator_Position_Demand_Valid              ,
      A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Pitch_Angle_Demand                ,
      An_Instance_P);

   A_Pitch_Angle_Demand                                       := 1000.0;
   A_Pitch_Angle_of_Simulated_Aircraft                        := 1000.0;
   A_Roll_Angle_of_Simulated_Aircraft                         := 1000.0;
   A_Pitch_Acceleration_of_Simulated_Aircraft                 := 1000.0;
   A_yy_Moment_of_Inertia_of_Simulated_Aircraft               := 10000.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 1000.0;
   A_Wing_Area_of_Simulated_Aircraft                       := 1000.0;
   A_Mean_Aerodynamic_Chord_of_Simulated_Aircraft             := 1000.0;
   A_Pitch_Moment_Coefficient_of_Elevator_to_Elevator_Position:= 1000.0;

   Special_Autopilot_Pitch.Set_Special_Autopilot_Pitch
     (A_Pitch_Angle_Demand                                       ,
      A_Pitch_Angle_of_Simulated_Aircraft                        ,
      A_Roll_Angle_of_Simulated_Aircraft                         ,
      A_Pitch_Acceleration_of_Simulated_Aircraft                 ,
      A_yy_Moment_of_Inertia_of_Simulated_Aircraft               ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft        ,
      A_Wing_Area_of_Simulated_Aircraft                          ,
      A_Mean_Aerodynamic_Chord_of_Simulated_Aircraft             ,
      A_Pitch_Moment_Coefficient_of_Elevator_to_Elevator_Position, --Will be of Horizontal Tail for JPATS
      An_Integration_Constant                                    ,
      An_Instance_P);

   put(Special_Autopilot_Pitch.Get_Position_Demand(An_Instance_P));   put_line(" elevator ");

   if  Special_Autopilot_Pitch.Get_Position_Valid(An_Instance_P) then
      put_line(" elevator on ");
   end if;


   pass := abs(Special_Autopilot_Yaw.Get_Position_Demand(An_Instance_Y)) >= 0.0 and
     abs(Special_Autopilot_Roll.Get_Position_Demand(An_Instance_R)) >= 0.0 and
     abs(Special_Autopilot_Pitch.Get_Position_Demand(An_Instance_P)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   pass := False;

   put_line("------------------ END -----------------------");

   A_Predefined_Rudder_Position_Demand                    := 0.0;
   A_Predefined_Rudder_Position_Demand_Valid              := false;
   A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft := 0.0;
   A_Predefined_Last_Pass_Yaw_Angle_Demand                := 0.0;

   Special_Autopilot_Yaw.Assign_Special_Autopilot_Yaw
     (A_Predefined_Rudder_Position_Demand                    ,
      A_Predefined_Rudder_Position_Demand_Valid              ,
      A_Predefined_Last_Pass_Yaw_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Yaw_Angle_Demand                ,
      An_Instance_Y);

   A_Yaw_Angle_Demand                                      := 0.0;
   A_Yaw_Angle_of_Simulated_Aircraft                       := 0.0;
   A_Roll_Angle_of_Simulated_Aircraft                      := 0.0;
   A_Pitch_Angle_of_Simulated_Aircraft                     := 0.0;
   A_Yaw_Acceleration_of_Simulated_Aircraft                := 0.0;
   A_zz_Moment_of_Inertia_of_Simulated_Aircraft            := 00.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 0.0;
   A_Wing_Area_of_Simulated_Aircraft                       := 0.0;
   A_Wing_Span_of_Simulated_Aircraft                       := 0.0;
   A_Yaw_Moment_Coefficient_of_Rudder_to_Rudder_Position  := 0.0;
   Special_Autopilot_Yaw.Set_Special_Autopilot_Yaw
     (A_Yaw_Angle_Demand                                     ,
      A_Yaw_Angle_of_Simulated_Aircraft                      ,
      A_Roll_Angle_of_Simulated_Aircraft                     ,
      A_Pitch_Angle_of_Simulated_Aircraft                    ,
      A_Yaw_Acceleration_of_Simulated_Aircraft               ,
      A_zz_Moment_of_Inertia_of_Simulated_Aircraft           ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft    ,
      A_Wing_Area_of_Simulated_Aircraft                      ,
      A_Wing_Span_of_Simulated_Aircraft                      ,
      A_Yaw_Moment_Coefficient_of_Rudder_to_Rudder_Position  , --Will be of Horizontal Tail for JPATS
      An_Integration_Constant                                ,
      An_Instance_Y);

   put(Special_Autopilot_Yaw.Get_Position_Demand(An_Instance_Y));   put_line(" rudder ");

   if  Special_Autopilot_Yaw.Get_Position_Valid(An_Instance_Y) then
      put_line(" rudder on ");
   end if;

   A_Predefined_Aileron_Position_Demand                    := 0.0;
   A_Predefined_Aileron_Position_Demand_Vaild              := false;
   A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft := 0.0;
   A_Predefined_Last_Pass_Roll_Angle_Demand                := 0.0;

   Special_Autopilot_Roll.Assign_Special_Autopilot_Roll
     (A_Predefined_Aileron_Position_Demand                    ,
      A_Predefined_Aileron_Position_Demand_Vaild              ,
      A_Predefined_Last_Pass_Roll_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Roll_Angle_Demand                ,
      An_Instance_R);

   A_Roll_Angle_Demand                                     := 0.0;
   A_Roll_Angle_of_Simulated_Aircraft                      := 0.0;
   A_Roll_Acceleration_of_Simulated_Aircraft               := 0.0;
   A_xx_Moment_of_Inertia_of_Simulated_Aircraft            := 00.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 0.0;
   A_Wing_Area_of_Simulated_Aircraft                       := 0.0;
   A_Wing_Span_of_Simulated_Aircraft                       := 0.0;
   A_Roll_Moment_Coefficient_of_Aileron_to_Aileron_Position := 0.0;

   Special_Autopilot_Roll.Set_Special_Autopilot_Roll
     (A_Roll_Angle_Demand                                      ,
      A_Roll_Angle_of_Simulated_Aircraft                       ,
      A_Roll_Acceleration_of_Simulated_Aircraft                ,
      A_xx_Moment_of_Inertia_of_Simulated_Aircraft             ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft      ,
      A_Wing_Area_of_Simulated_Aircraft                        ,
      A_Wing_Span_of_Simulated_Aircraft                        ,
      A_Roll_Moment_Coefficient_of_Aileron_to_Aileron_Position ,
      An_Integration_Constant                                  ,
      An_Instance_R);

   put(Special_Autopilot_Roll.Get_Position_Demand(An_Instance_R));   put_line(" aileron ");

   if  Special_Autopilot_Roll.Get_Position_Valid(An_Instance_R) then
      put_line(" aileron on ");
   end if;

   A_Predefined_Elevator_Position_Demand                    := 0.0;
   A_Predefined_Elevator_Position_Demand_Valid              := false;
   A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft := 0.0;
   A_Predefined_Last_Pass_Pitch_Angle_Demand                := 0.0;

   Special_Autopilot_Pitch.Assign_Special_Autopilot_Pitch
     (A_Predefined_Elevator_Position_Demand                    ,
      A_Predefined_Elevator_Position_Demand_Valid              ,
      A_Predefined_Last_Pass_Pitch_Angle_of_Simulated_Aircraft ,
      A_Predefined_Last_Pass_Pitch_Angle_Demand                ,
      An_Instance_P);

   A_Pitch_Angle_Demand                                       := 0.0;
   A_Pitch_Angle_of_Simulated_Aircraft                        := 0.0;
   A_Roll_Angle_of_Simulated_Aircraft                         := 0.0;
   A_Pitch_Acceleration_of_Simulated_Aircraft                 := 0.0;
   A_yy_Moment_of_Inertia_of_Simulated_Aircraft               := 00.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft     := 0.0;
   A_Wing_Area_of_Simulated_Aircraft                       := 0.0;
   A_Mean_Aerodynamic_Chord_of_Simulated_Aircraft             := 0.0;
   A_Pitch_Moment_Coefficient_of_Elevator_to_Elevator_Position:= 0.0;

   Special_Autopilot_Pitch.Set_Special_Autopilot_Pitch
     (A_Pitch_Angle_Demand                                       ,
      A_Pitch_Angle_of_Simulated_Aircraft                        ,
      A_Roll_Angle_of_Simulated_Aircraft                         ,
      A_Pitch_Acceleration_of_Simulated_Aircraft                 ,
      A_yy_Moment_of_Inertia_of_Simulated_Aircraft               ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft        ,
      A_Wing_Area_of_Simulated_Aircraft                          ,
      A_Mean_Aerodynamic_Chord_of_Simulated_Aircraft             ,
      A_Pitch_Moment_Coefficient_of_Elevator_to_Elevator_Position, --Will be of Horizontal Tail for JPATS
      An_Integration_Constant                                    ,
      An_Instance_P);

   put(Special_Autopilot_Pitch.Get_Position_Demand(An_Instance_P));   put_line(" elevator ");

   if  Special_Autopilot_Pitch.Get_Position_Valid(An_Instance_P) then
      put_line(" elevator on ");
   end if;


   pass := abs(Special_Autopilot_Yaw.Get_Position_Demand(An_Instance_Y)) >= 0.0 and
     abs(Special_Autopilot_Roll.Get_Position_Demand(An_Instance_R)) >= 0.0 and
     abs(Special_Autopilot_Pitch.Get_Position_Demand(An_Instance_P)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   pass := False;


end EXECUTE_sap;

