-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Roll_Hold;
with Angle_Types;
with Length_Types;
with Class_Test_Result_File;


procedure EXECUTE_roll_hold is

   An_Instance  : Roll_Hold.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_Roll_Angle_Demand                        :Angle_Types.Radians;
   A_Yaw_Acceleration_of_Simulated_Aircraft   :Angle_Types.Radians_per_Sq_Sec;
   A_Pitch_Acceleration_of_Simulated_Aircraft :Angle_Types.Radians_per_Sq_Sec;
   A_Roll_Angle_of_Simulated_Aircraft         :Angle_Types.Radians;
   A_Pitch_Angle_of_Simulated_Aircraft        :Angle_Types.Radians;
   A_Predefined_Roll_Rate_Demand :Angle_Types.Radians_per_Sec;
   A_Predefined_Roll_Rate_Valid  :Boolean;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Roll_Angle_Demand                       := -0.36;
   A_Yaw_Acceleration_of_Simulated_Aircraft  := 0.2367;
   A_Pitch_Acceleration_of_Simulated_Aircraft:= -1.0569;
   A_Roll_Angle_of_Simulated_Aircraft        :=-0.86;
   A_Pitch_Angle_of_Simulated_Aircraft       := -0.21;

   Roll_Hold.Set_Roll_Hold
     (A_Roll_Angle_Demand                       ,
      A_Yaw_Acceleration_of_Simulated_Aircraft  ,
      A_Pitch_Acceleration_of_Simulated_Aircraft,
      A_Roll_Angle_of_Simulated_Aircraft        ,
      A_Pitch_Angle_of_Simulated_Aircraft       ,
      An_Integration_Constant                   ,
      An_Instance                               );

   -- Roll_Hold.Assign_Roll_Hold
   --     (A_Predefined_Roll_Rate_Demand ,
   --      A_Predefined_Roll_Rate_Valid ,
   --      An_Instance                  );

   put(Roll_Hold.Get_Roll_Rate_Demand(An_Instance)); put_line(" roll rate dmd ");

   if Roll_Hold.Get_Roll_Rate_Valid(An_Instance ) then
      put_line(" roll rate valid ");
   end if;

   Pass := abs(Roll_Hold.Get_Roll_Rate_Demand(An_Instance) - 0.2079117) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("-------------------- CONSTRAINT ---------------");

   A_Roll_Angle_Demand                       := 1000.0;
   A_Yaw_Acceleration_of_Simulated_Aircraft  := 1000.0;
   A_Pitch_Acceleration_of_Simulated_Aircraft:= 1000.0;
   A_Roll_Angle_of_Simulated_Aircraft        := 1000.0;
   A_Pitch_Angle_of_Simulated_Aircraft       := 1000.0;

   Roll_Hold.Set_Roll_Hold
     (A_Roll_Angle_Demand                       ,
      A_Yaw_Acceleration_of_Simulated_Aircraft  ,
      A_Pitch_Acceleration_of_Simulated_Aircraft,
      A_Roll_Angle_of_Simulated_Aircraft        ,
      A_Pitch_Angle_of_Simulated_Aircraft       ,
      An_Integration_Constant                   ,
      An_Instance                               );

   put(Roll_Hold.Get_Roll_Rate_Demand(An_Instance)); put_line(" roll rate dmd ");

   if Roll_Hold.Get_Roll_Rate_Valid(An_Instance ) then
      put_line(" roll rate valid ");
   end if;

   Pass := abs(Roll_Hold.Get_Roll_Rate_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("-------------------- END ---------------");

   A_Roll_Angle_Demand                       := 0.0;
   A_Yaw_Acceleration_of_Simulated_Aircraft  := 0.0;
   A_Pitch_Acceleration_of_Simulated_Aircraft:= 0.0;
   A_Roll_Angle_of_Simulated_Aircraft        := 0.0;
   A_Pitch_Angle_of_Simulated_Aircraft       := 0.0;

   Roll_Hold.Set_Roll_Hold
     (A_Roll_Angle_Demand                       ,
      A_Yaw_Acceleration_of_Simulated_Aircraft  ,
      A_Pitch_Acceleration_of_Simulated_Aircraft,
      A_Roll_Angle_of_Simulated_Aircraft        ,
      A_Pitch_Angle_of_Simulated_Aircraft       ,
      An_Integration_Constant                   ,
      An_Instance                               );

   put(Roll_Hold.Get_Roll_Rate_Demand(An_Instance)); put_line(" roll rate dmd ");

   if Roll_Hold.Get_Roll_Rate_Valid(An_Instance ) then
      put_line(" roll rate valid ");
   end if;

   Pass := abs(Roll_Hold.Get_Roll_Rate_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;






end EXECUTE_roll_hold;

