-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Primary_Control_Surface;
with Angle_Types;
with Normalized_Types;
with Class_Test_Result_File;

procedure EXECUTE_Pri_CS is

   An_Instance  : Primary_Control_Surface.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_Delta_Primary_Control_Surface_Deflection :Float;
   A_Control_Surface_Trim_Gain                :Float;
   A_Predefined_Primary_Control_Surface_Position       :Angle_Types.Degrees;
   A_Predefined_Primary_Control_Surface_Position_Valid :Boolean;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin
   A_Predefined_Primary_Control_Surface_Position       := 2.59;
   A_Predefined_Primary_Control_Surface_Position_Valid := false;

   Primary_Control_Surface.Assign_Position
     (A_Predefined_Primary_Control_Surface_Position       ,
      A_Predefined_Primary_Control_Surface_Position_Valid,
      An_Instance                                        );

   A_Delta_Primary_Control_Surface_Deflection:= 0.43;
   A_Control_Surface_Trim_Gain               :=0.2;

   Primary_Control_Surface.Set_Position
     (A_Delta_Primary_Control_Surface_Deflection,
      A_Control_Surface_Trim_Gain               ,
      An_Instance                               );

   --Primary_Control_Surface.Assign_Position
   --    (A_Predefined_Primary_Control_Surface_Position       ,
   --     A_Predefined_Primary_Control_Surface_Position_Valid,
   --     An_Instance                                        );

   if Primary_Control_Surface.Get_Position_Valid(An_Instance ) then
      put_line(" surface position on ");
   end if;

   put(Primary_Control_Surface.Get_Position_Value(An_Instance )); put_line(" control surface position ");

   Pass := abs(Primary_Control_Surface.Get_Position_Value(An_Instance) - 2.676) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   put_line("------------------ CONSTRAINT -----------------------");

   A_Delta_Primary_Control_Surface_Deflection:= 1000.0;
   A_Control_Surface_Trim_Gain               := 1000.0;

   Primary_Control_Surface.Set_Position
     (A_Delta_Primary_Control_Surface_Deflection,
      A_Control_Surface_Trim_Gain               ,
      An_Instance                               );

   if Primary_Control_Surface.Get_Position_Valid(An_Instance ) then
      put_line(" surface position on ");
   end if;

   put(Primary_Control_Surface.Get_Position_Value(An_Instance )); put_line(" control surface position ");

   Pass := abs(Primary_Control_Surface.Get_Position_Value(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;


   put_line("------------------ END -----------------------");

   A_Delta_Primary_Control_Surface_Deflection:= 0.0;
   A_Control_Surface_Trim_Gain               := 0.0;

   Primary_Control_Surface.Set_Position
     (A_Delta_Primary_Control_Surface_Deflection,
      A_Control_Surface_Trim_Gain               ,
      An_Instance                               );

   if Primary_Control_Surface.Get_Position_Valid(An_Instance ) then
      put_line(" surface position on ");
   end if;

   put(Primary_Control_Surface.Get_Position_Value(An_Instance )); put_line(" control surface position ");

   Pass := abs(Primary_Control_Surface.Get_Position_Value(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;





end EXECUTE_Pri_CS;

