-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with PLA_Trim;
with Angle_Types;
with Normalized_Types;
with Class_Test_Result_File;

procedure EXECUTE_Pla is

   An_Instance  : PLA_Trim.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_Engine_Thrust_Demand                :Float;
   An_Ambient_Pressure_Ratio             :Normalized_Types.Normalize;
   A_Engine_Thrust_of_Simulated_Aircraft :Float;
   A_Predefined_PLA_Trim_Demand          :Angle_Types.Degrees;
   A_Predefined_PLA_Trim_Valid           :Boolean;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Predefined_PLA_Trim_Demand := 56.3;
   A_Predefined_PLA_Trim_Valid  := false;
   PLA_Trim.Assign_PLA_Trim
     (A_Predefined_PLA_Trim_Demand ,
      A_Predefined_PLA_Trim_Valid  ,
      An_Instance                  );

   A_Engine_Thrust_Demand                := 56.3;
   An_Ambient_Pressure_Ratio             := 0.9568;
   A_Engine_Thrust_of_Simulated_Aircraft := 59.36;

   PLA_Trim.Set_PLA_Trim
     (A_Engine_Thrust_Demand               ,
      An_Ambient_Pressure_Ratio             ,
      A_Engine_Thrust_of_Simulated_Aircraft,
      An_Instance                          );

   -- PLA_Trim.Assign_PLA_Trim
   --     (A_Predefined_PLA_Trim_Demand ,
   --      A_Predefined_PLA_Trim_Valid  ,
   --      An_Instance                  );

   put_line(float'image(PLA_Trim.Get_PLA_Trim_Demand(An_Instance )));

   Pass := abs(PLA_Trim.Get_PLA_Trim_Demand(An_Instance) - 56.29936037 ) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   if PLA_Trim.Get_PLA_Trim_Valid(An_Instance ) then
      put_line( " pla trim on ");
   end if;

   put_line("----------------------- CONSTRAINT ---------------------------");

   A_Engine_Thrust_Demand                := 1000.0;
   An_Ambient_Pressure_Ratio             := 1000.0;
   A_Engine_Thrust_of_Simulated_Aircraft := 1000.0;

   PLA_Trim.Set_PLA_Trim
     (A_Engine_Thrust_Demand               ,
      An_Ambient_Pressure_Ratio             ,
      A_Engine_Thrust_of_Simulated_Aircraft,
      An_Instance                          );

   put_line(float'image(PLA_Trim.Get_PLA_Trim_Demand(An_Instance )));

   Pass := abs(PLA_Trim.Get_PLA_Trim_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("----------------------- END ---------------------------");

   A_Engine_Thrust_Demand                := 0.0;
   An_Ambient_Pressure_Ratio             := 0.0;
   A_Engine_Thrust_of_Simulated_Aircraft := 0.0;

   PLA_Trim.Set_PLA_Trim
     (A_Engine_Thrust_Demand               ,
      An_Ambient_Pressure_Ratio             ,
      A_Engine_Thrust_of_Simulated_Aircraft,
      An_Instance                          );

   put_line(float'image(PLA_Trim.Get_PLA_Trim_Demand(An_Instance )));

   Pass := abs(PLA_Trim.Get_PLA_Trim_Demand(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;






end EXECUTE_Pla;

