-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Indicated_Velocity_Hold;
with Angle_Types;
with Class_Test_Result_File;


procedure EXECUTE_ind_vel is

   An_Instance  : Indicated_Velocity_Hold.Instance;

   An_Integration_Constant : Float := 1.0/60.0;
   A_Demand_x_Acceleration                :Float;
   A_x_Acceleration_of_Simulated_Aircraft :Float;
   A_Predefined_Pitch_Angle_Demand        :Angle_Types.Radians;
   A_Predefined_Pitch_Hold                :Boolean := false;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;


begin
   A_Predefined_Pitch_Angle_Demand := -0.1156;
   Indicated_Velocity_Hold.Assign_Indicated_Velocity_Hold
     (A_Predefined_Pitch_Angle_Demand,
      A_Predefined_Pitch_Hold        ,
      An_Instance                    );

   A_Demand_x_Acceleration                := -0.1248;
   A_x_Acceleration_of_Simulated_Aircraft := -0.369;
   Indicated_Velocity_Hold.Set_Indicated_Velocity_Hold
     (A_Demand_x_Acceleration               ,
      A_x_Acceleration_of_Simulated_Aircraft,
      An_Instance                           );

   put(Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(An_Instance));  put(" pitch angle ");

   Pass := abs(Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(An_Instance) - (-0.120484)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line("--------------------- CONSTRAINT --------------------");

   A_Predefined_Pitch_Angle_Demand := 1000.0;
   Indicated_Velocity_Hold.Assign_Indicated_Velocity_Hold
     (A_Predefined_Pitch_Angle_Demand,
      A_Predefined_Pitch_Hold        ,
      An_Instance                    );

   A_Demand_x_Acceleration                := 1000.0;
   A_x_Acceleration_of_Simulated_Aircraft := 1000.0;
   Indicated_Velocity_Hold.Set_Indicated_Velocity_Hold
     (A_Demand_x_Acceleration               ,
      A_x_Acceleration_of_Simulated_Aircraft,
      An_Instance                           );

   put(Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(An_Instance));  put(" pitch angle ");

   Pass := abs(Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line("--------------------- END --------------------");

   A_Predefined_Pitch_Angle_Demand := 0.0;
   Indicated_Velocity_Hold.Assign_Indicated_Velocity_Hold
     (A_Predefined_Pitch_Angle_Demand,
      A_Predefined_Pitch_Hold        ,
      An_Instance                    );

   A_Demand_x_Acceleration                := 0.0;
   A_x_Acceleration_of_Simulated_Aircraft := 0.0;
   Indicated_Velocity_Hold.Set_Indicated_Velocity_Hold
     (A_Demand_x_Acceleration               ,
      A_x_Acceleration_of_Simulated_Aircraft,
      An_Instance                           );

   put(Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(An_Instance));  put(" pitch angle ");

   Pass := abs(Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;




end EXECUTE_ind_vel;

