-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Error_Coefficients;

with Angle_Types;
with Force_Types;
with Mass_Types;
with Length_Types;
with Class_Test_Result_File;

procedure EXECUTE_err_coeff is

   An_Instance : Error_Coefficients.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   An_Angular_Acceleration_of_Simulated_Aircraft       :Angle_Types.Radians_per_Sq_Sec;
   A_Moment_of_Inertia_of_Simulated_Aircraft           :Mass_Types.Slugs_Feet_Sq;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft :Force_Types.Pounds_per_Sq_Feet;
   A_Wing_Area_of_Simulated_Aircraft                   :Length_Types.Sq_Feet;
   A_Wing_Dimension_of_Simulated_Aircraft              :Length_Types.Feet;
   A_Moment_Coefficient_of_Simulated_Aircraft          :Float;
   A_Trim_Gain                                         :Float;
   A_Predefined_Delta_Deflection                       :Angle_Types.Degrees;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin


   --| for Aileron,
   An_Angular_Acceleration_of_Simulated_Aircraft  := -0.325;
   A_Moment_of_Inertia_of_Simulated_Aircraft      := 3569.2;
   A_Wing_Dimension_of_Simulated_Aircraft         := 33.42;
   A_Moment_Coefficient_of_Simulated_Aircraft     := -0.002;
   A_Trim_Gain                                    := 0.1;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft := 70.43;
   A_Wing_Area_of_Simulated_Aircraft := 342.16;
   --| for Elevator, An_Angular_Acceleration_of_Simulated_Aircraft := Pitch_Acceleration
   --|               A_Moment_of_Inertia_of_Simulated_Aircraft     := Inertia_yy
   --|               A_Wing_Dimension_of_Simulated_Aircraft        := Mean_Aerodynamic_Chord
   --|               A_Moment_Coefficient_of_Simulated_Aircraft    := Elevator_Pitch_Moment_Coefficient
   --|               A_Trim_Gain                                   := Elevator_Trim_Gain

   --| for Rudder, An_Angular_Acceleration_of_Simulated_Aircraft   := Yaw_Acceleration
   --|             A_Moment_of_Inertia_of_Simulated_Aircraft       := Inertia_zz
   --|             A_Wing_Dimension_of_Simulated_Aircraft          := Wing_Span
   --|             A_Moment_Coefficient_of_Simulated_Aircraft      := Rudder_Yaw_Moment_Coefficient
   --|             A_Trim_Gain                                     := Rudder_Trim_Gain

   Error_Coefficients.Set_Error_Coefficients
     (An_Angular_Acceleration_of_Simulated_Aircraft       ,
      A_Moment_of_Inertia_of_Simulated_Aircraft           ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft ,
      A_Wing_Area_of_Simulated_Aircraft                   ,
      A_Wing_Dimension_of_Simulated_Aircraft              ,
      A_Moment_Coefficient_of_Simulated_Aircraft          ,
      A_Trim_Gain                                         ,
      An_Instance                                         );

   --Error_Coefficients.Assign_Error_Coefficients
   --        (A_Predefined_Delta_Deflection ,
   --         An_Instance                   );

   put(Error_Coefficients.Get_Delta_Deflection(An_Instance )); put_line(" error coeff. ");

   Pass := abs(Error_Coefficients.Get_Delta_Deflection(An_Instance) - (-0.07201631)) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" ------------------- CONSTRAINT ----------------------");

   --| for Aileron,
   An_Angular_Acceleration_of_Simulated_Aircraft  := 1000.0;
   A_Moment_of_Inertia_of_Simulated_Aircraft      := 10000.0;
   A_Wing_Dimension_of_Simulated_Aircraft         := 1000.0;
   A_Moment_Coefficient_of_Simulated_Aircraft     := 1000.0;
   A_Trim_Gain                                    := 1000.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft := 1000.0;
   A_Wing_Area_of_Simulated_Aircraft := 10000.0;

   Error_Coefficients.Set_Error_Coefficients
     (An_Angular_Acceleration_of_Simulated_Aircraft       ,
      A_Moment_of_Inertia_of_Simulated_Aircraft           ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft ,
      A_Wing_Area_of_Simulated_Aircraft                   ,
      A_Wing_Dimension_of_Simulated_Aircraft              ,
      A_Moment_Coefficient_of_Simulated_Aircraft          ,
      A_Trim_Gain                                         ,
      An_Instance                                         );

   put(Error_Coefficients.Get_Delta_Deflection(An_Instance )); put_line(" error coeff. ");

   Pass := abs(Error_Coefficients.Get_Delta_Deflection(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" ------------------- END ----------------------");

   --| for Aileron,
   An_Angular_Acceleration_of_Simulated_Aircraft  := 0.0;
   A_Moment_of_Inertia_of_Simulated_Aircraft      := 0.0;
   A_Wing_Dimension_of_Simulated_Aircraft         := 0.0;
   A_Moment_Coefficient_of_Simulated_Aircraft     := 0.0;
   A_Trim_Gain                                    := 0.0;
   A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft := 0.0;
   A_Wing_Area_of_Simulated_Aircraft := 0.0;

   Error_Coefficients.Set_Error_Coefficients
     (An_Angular_Acceleration_of_Simulated_Aircraft       ,
      A_Moment_of_Inertia_of_Simulated_Aircraft           ,
      A_Freestream_Dynamic_Pressure_of_Simulated_Aircraft ,
      A_Wing_Area_of_Simulated_Aircraft                   ,
      A_Wing_Dimension_of_Simulated_Aircraft              ,
      A_Moment_Coefficient_of_Simulated_Aircraft          ,
      A_Trim_Gain                                         ,
      An_Instance                                         );

   put(Error_Coefficients.Get_Delta_Deflection(An_Instance )); put_line(" error coeff. ");

   Pass := abs(Error_Coefficients.Get_Delta_Deflection(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;



end EXECUTE_err_coeff;

