-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Demand_x_Acceleration;
with Length_Types;
with Class_Test_Result_File;

procedure EXECUTE_dmd_acc is

   An_Instance : Demand_x_Acceleration.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_Calibrated_Airspeed_of_Simulated_Aircraft :Length_Types.Feet_per_Sec;
   A_Demand_Calibrated_Airspeed                :Length_Types.Feet_per_Sec;
   A_Predefined_Demand_x_Acceleration          :Length_Types.Feet_per_Sec;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin


   A_Calibrated_Airspeed_of_Simulated_Aircraft := 274.98;
   A_Demand_Calibrated_Airspeed                := 270.56;
   Demand_x_Acceleration.Set_Demand_x_Acceleration
     (A_Calibrated_Airspeed_of_Simulated_Aircraft,
      A_Demand_Calibrated_Airspeed               ,
      An_Instance                                );

   --    Demand_x_Acceleration.Assign_Demand_x_Acceleration
   --        (A_Predefined_Demand_x_Acceleration,
   --         An_Instance                       );

   put(Demand_x_Acceleration.Get_Demand_x_Acceleration(An_Instance)); put_line( " x acc " );

   Pass := abs(Demand_x_Acceleration.Get_Demand_x_Acceleration(An_Instance) - (-1.105)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("----------------- CONSTRAINT -------------------------");

   A_Calibrated_Airspeed_of_Simulated_Aircraft := 1000.0;
   A_Demand_Calibrated_Airspeed                := 1000.0;
   Demand_x_Acceleration.Set_Demand_x_Acceleration
     (A_Calibrated_Airspeed_of_Simulated_Aircraft,
      A_Demand_Calibrated_Airspeed               ,
      An_Instance                                );

   put(Demand_x_Acceleration.Get_Demand_x_Acceleration(An_Instance)); put_line( " x acc " );

   Pass := abs(Demand_x_Acceleration.Get_Demand_x_Acceleration(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("----------------- END -------------------------");

   A_Calibrated_Airspeed_of_Simulated_Aircraft := 0.0;
   A_Demand_Calibrated_Airspeed                := 0.0;
   Demand_x_Acceleration.Set_Demand_x_Acceleration
     (A_Calibrated_Airspeed_of_Simulated_Aircraft,
      A_Demand_Calibrated_Airspeed               ,
      An_Instance                                );

   put(Demand_x_Acceleration.Get_Demand_x_Acceleration(An_Instance)); put_line( " x acc " );

   Pass := abs(Demand_x_Acceleration.Get_Demand_x_Acceleration(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

end EXECUTE_dmd_acc;

