-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Auto_Throttle_Hold;
with Mass_Types;
with Class_Test_Result_File;

procedure EXECUTE_Auto_Throttle is

   An_Instance : Auto_Throttle_Hold.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   A_Gross_Weight_of_Simulated_Aircraft   :Mass_Types.Lbm;
   A_x_Acceleration_of_Simulated_Aircraft :Float;
   A_Demand_x_Acceleration                :Float;
   A_Predefined_Engine_Thrust_Demand      :Float;
   A_Predefined_PLA_Trim_Driver_Valid     :Boolean := false;
   A_Predefined_Engine_Thrust_Valid       :Boolean := false;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin
   A_Predefined_Engine_Thrust_Demand := 989.36;
   Auto_Throttle_Hold.Assign_Auto_Throttle_Hold
     (A_Predefined_Engine_Thrust_Demand ,
      A_Predefined_PLA_Trim_Driver_Valid,
      A_Predefined_Engine_Thrust_Valid  ,
      An_Instance                       );

   A_Gross_Weight_of_Simulated_Aircraft   := 6252.7;
   A_x_Acceleration_of_Simulated_Aircraft :=  -0.5698;
   A_Demand_x_Acceleration                := 0.2369;
   Auto_Throttle_Hold.Set_Auto_Throttle_Hold
     (A_Gross_Weight_of_Simulated_Aircraft  ,
      A_x_Acceleration_of_Simulated_Aircraft,
      A_Demand_x_Acceleration               ,
      An_Instance                           );

   put(Auto_Throttle_Hold.Get_Engine_Thrust_Demand(An_Instance)); put_line(" auto throttle ");

   pass:=abs(Auto_Throttle_Hold.Get_Engine_Thrust_Demand(An_Instance) - 1014.58027) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;
   put_line("---------------- CONSTRAINT -----------------------");

   A_Gross_Weight_of_Simulated_Aircraft   := 10000.0;
   A_x_Acceleration_of_Simulated_Aircraft :=  1000.0;
   A_Demand_x_Acceleration                := 1000.0;
   Auto_Throttle_Hold.Set_Auto_Throttle_Hold
     (A_Gross_Weight_of_Simulated_Aircraft  ,
      A_x_Acceleration_of_Simulated_Aircraft,
      A_Demand_x_Acceleration               ,
      An_Instance                           );

   put(Auto_Throttle_Hold.Get_Engine_Thrust_Demand(An_Instance)); put_line(" auto throttle ");

   pass:=abs(Auto_Throttle_Hold.Get_Engine_Thrust_Demand(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;
   put_line("---------------- END -----------------------");

   A_Gross_Weight_of_Simulated_Aircraft   := 0.0;
   A_x_Acceleration_of_Simulated_Aircraft := 0.0;
   A_Demand_x_Acceleration                := 0.0;
   Auto_Throttle_Hold.Set_Auto_Throttle_Hold
     (A_Gross_Weight_of_Simulated_Aircraft  ,
      A_x_Acceleration_of_Simulated_Aircraft,
      A_Demand_x_Acceleration               ,
      An_Instance                           );

   put(Auto_Throttle_Hold.Get_Engine_Thrust_Demand(An_Instance)); put_line(" auto throttle ");

   pass:=abs(Auto_Throttle_Hold.Get_Engine_Thrust_Demand(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;






end EXECUTE_Auto_Throttle;

