-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Attitude_Latency;
with Angle_Types;
with Class_Test_Result_File;

procedure EXECUTE_Atitude_latency is

   An_Instance : Attitude_Latency.Instance;

   An_Integration_Constant : Float := 1.0/60.0;

   --| Set_Latency, method is used when a latency test is to be carried out.
   A_Simulated_Aircraft_Attitude_Angle   :Angle_Types.Degrees;
   A_Predefined_Latency_Step_Input       :Angle_Types.Degrees;
   A_Predefined_Attitude_Angle           :Angle_Types.Degrees;
   A_Predefined_Latency_Step_Input_Valid :Boolean;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin


   --| Set_Latency, method is used when a latency test is to be carried out.
   A_Simulated_Aircraft_Attitude_Angle := 12.6739;
   Attitude_Latency.Set_Latency(A_Simulated_Aircraft_Attitude_Angle,
                                An_Instance                        );

   --Attitude_Latency.Assign_Latency(A_Predefined_Latency_Step_Input,
   --                         An_Instance                    );

   --Attitude_Latency.Assign_Attitude_Angle(A_Predefined_Attitude_Angle,
   --                                An_Instance                );
   --Attitude_Latency.Assign_Latency_Valid(A_Predefined_Latency_Step_Input_Valid,
   --                               An_Instance                          );

   put( Attitude_Latency.Get_Attitude_Angle(An_Instance));

   Pass := abs(Attitude_Latency.Get_Attitude_Angle(An_Instance) - 13.6739) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   if Attitude_Latency.Get_Latency_Valid(An_Instance) then
      put_line(" attitude latency true ");
   end if;

   put(Attitude_Latency.Get_Latency_Step_Input(An_Instance));

   put_line("------------- CONSTRAINT -------------------");
   --| Set_Latency, method is used when a latency test is to be carried out.
   A_Simulated_Aircraft_Attitude_Angle := 1000.0;
   Attitude_Latency.Set_Latency(A_Simulated_Aircraft_Attitude_Angle,
                                An_Instance                        );
   put( Attitude_Latency.Get_Attitude_Angle(An_Instance));

   Pass := abs(Attitude_Latency.Get_Attitude_Angle(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("------------- END -------------------");
   --| Set_Latency, method is used when a latency test is to be carried out.
   A_Simulated_Aircraft_Attitude_Angle := 0.0;
   Attitude_Latency.Set_Latency(A_Simulated_Aircraft_Attitude_Angle,
                                An_Instance                        );
   put( Attitude_Latency.Get_Attitude_Angle(An_Instance));

   Pass := abs(Attitude_Latency.Get_Attitude_Angle(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;



end EXECUTE_Atitude_latency;

