-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Altitude_Hold;
with Length_Types;
with Class_Test_Result_File;


procedure EXECUTE_Altitude_Hold is

   An_Instance : Altitude_Hold.Instance;

   An_Integration_Constant : Float := 1.0/60.0;


   A_Pressure_Altitude_of_Simulated_Aircraft :Length_Types.Feet;
   A_Demand_Pressure_Altitude                :Length_Types.Feet;
   A_Predefined_Rate_of_Climb_Demanded       :Length_Types.Feet;
   A_Predefined_Rate_of_Climb_Hold           :Boolean;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Pressure_Altitude_of_Simulated_Aircraft := 1763.98;
   A_Demand_Pressure_Altitude                := 1765.34;
   Altitude_Hold.Set_Altitude_Hold
     (A_Pressure_Altitude_of_Simulated_Aircraft,
      A_Demand_Pressure_Altitude               ,
      An_Instance                              );

   --Altitude_Hold.Assign_Altitude_Hold
   --        (A_Predefined_Rate_of_Climb_Demanded,
   --         A_Predefined_Rate_of_Climb_Hold   ,
   --         An_Instance                        );

   put(Altitude_Hold.Get_Rate_of_Climb_Demand(An_Instance )); Put_line(" ROC ");

   Pass := abs(Altitude_Hold.Get_Rate_of_Climb_Demand(An_Instance ) - 6.8) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);

   if Altitude_Hold.Get_Rate_of_Climb_Hold(An_Instance ) then
      put_line(" ROC true ");
   end if;

   put_line(" ------------------- CONSTRAINT --------------------");
   A_Pressure_Altitude_of_Simulated_Aircraft := 10000.0;
   A_Demand_Pressure_Altitude                := 10000.0;
   Altitude_Hold.Set_Altitude_Hold
     (A_Pressure_Altitude_of_Simulated_Aircraft,
      A_Demand_Pressure_Altitude               ,
      An_Instance                              );

   --Altitude_Hold.Assign_Altitude_Hold
   --        (A_Predefined_Rate_of_Climb_Demanded,
   --         A_Predefined_Rate_of_Climb_Hold   ,
   --         An_Instance                        );

   put(Altitude_Hold.Get_Rate_of_Climb_Demand(An_Instance )); Put_line(" ROC ");

   Pass := abs(Altitude_Hold.Get_Rate_of_Climb_Demand(An_Instance )) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);

   put_line(" ------------------- END --------------------");
   A_Pressure_Altitude_of_Simulated_Aircraft := 0.0;
   A_Demand_Pressure_Altitude                := 0.0;
   Altitude_Hold.Set_Altitude_Hold
     (A_Pressure_Altitude_of_Simulated_Aircraft,
      A_Demand_Pressure_Altitude               ,
      An_Instance                              );

   --Altitude_Hold.Assign_Altitude_Hold
   --        (A_Predefined_Rate_of_Climb_Demanded,
   --         A_Predefined_Rate_of_Climb_Hold   ,
   --         An_Instance                        );

   put(Altitude_Hold.Get_Rate_of_Climb_Demand(An_Instance )); Put_line(" ROC ");

   Pass := abs(Altitude_Hold.Get_Rate_of_Climb_Demand(An_Instance )) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);

end EXECUTE_Altitude_Hold;

