-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Winds;

with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Class_Test_Result_File;


procedure EXECUTE_Winds is
    An_Instance                : Winds.Instance;

    A_Predefined_Surface_Wind_Velocity                   :Length_Types.Feet_per_Sec;
    A_Predefined_Surface_Wind_Altitude                   :Length_Types.Feet;
    A_Predefined_Surface_Wind_Direction                  :Angle_Types.Degrees;
    A_Predefined_Cruise_Wind_Velocity                    :Length_Types.Feet_per_Sec;
    A_Predefined_Cruise_Wind_Altitude                    :Length_Types.Feet;
    A_Predefined_Cruise_Wind_Direction                   :Angle_Types.Degrees;
    A_Predefined_Cross_Wind_Valid                        :Boolean;
    A_Predefined_Cross_Wind_Velocity                     :Length_Types.Feet_per_Sec;
    A_Predefined_Cross_Wind_Altitude                     :Length_Types.Feet;
    A_Runway_Threshold_Heading                           :Angle_Types.Radians;
    An_Aircraft_Geometric_Altitude                       :Length_Types.Feet;
    A_Predefined_Wind_Direction                          :Angle_Types.Degrees;
    A_Predefined_Wind_Velocity                           : Length_Types.Feet_per_Sec;
    A_Steady_State_Wind_Velocity_Earth_Axis              :Coordinate_Types.Cartesian;
    A_Steady_State_Wind_Increment_in_Velocity_Earth_Axis :Coordinate_Types.Cartesian;
    A_Wind_Gust_Velocity_Earth_Axis                      :Coordinate_Types.Cartesian;
    A_Microburst_Velocity_Earth_Axis                     :Coordinate_Types.Cartesian;
    A_Wind_Shear_Velocity_Earth_Axis                     :Coordinate_Types.Cartesian;
    A_Predefined_Wind_Velocity_Earth_Axis                :Coordinate_Types.Cartesian;
    An_Aircraft_Yaw_Angle                                :Angle_Types.Radians;

    pass : boolean := false;
    A_Tolerance : Float := 0.001;

begin

    A_Predefined_Surface_Wind_Velocity                   := 54.36;
    A_Predefined_Surface_Wind_Altitude                   := 5000.0;
    A_Predefined_Surface_Wind_Direction                  := 35.21;
    A_Predefined_Cruise_Wind_Velocity                    := 85.47;
    A_Predefined_Cruise_Wind_Altitude                    := 7500.0;
    A_Predefined_Cruise_Wind_Direction                   := -62.3;
    A_Predefined_Cross_Wind_Valid                        := false;
    A_Predefined_Cross_Wind_Velocity                     := 63.02;
    A_Predefined_Cross_Wind_Altitude                     := 35000.0;
    A_Runway_Threshold_Heading                           := 41.3*3.142/180.0;
    An_Aircraft_Geometric_Altitude                       := 6000.0;
    A_Steady_State_Wind_Velocity_Earth_Axis              := (23.2,5.68,0.9);
    A_Steady_State_Wind_Increment_in_Velocity_Earth_Axis := (1.0e-7,1.01e-7,2.03e-7);
    A_Wind_Gust_Velocity_Earth_Axis                      := (3.2,0.68,0.1);
    A_Microburst_Velocity_Earth_Axis                     := (0.2,0.8,0.0);
    A_Wind_Shear_Velocity_Earth_Axis                     := (15.36,7.59,1.25);
    An_Aircraft_Yaw_Angle                                := 14.69*3.142/180.0;

    Winds.Assign_Surface_Wind_Altitude
        (A_Predefined_Surface_Wind_Altitude,
         An_Instance                      );

    Winds.Assign_Surface_Wind_Direction
        (A_Predefined_Surface_Wind_Direction,
         An_Instance                       );

    Winds.Assign_Cruise_Wind_Velocity
        (A_Predefined_Cruise_Wind_Velocity,
         An_Instance                     );

    Winds.Assign_Cruise_Wind_Altitude
        (A_Predefined_Cruise_Wind_Altitude ,
         An_Instance                     );

    Winds.Assign_Cruise_Wind_Direction
        (A_Predefined_Cruise_Wind_Direction,
         An_Instance                      );

    Winds.Assign_Cross_Wind_Valid(A_Predefined_Cross_Wind_Valid ,
                                      An_Instance                 );

    Winds.Assign_Cross_Wind_Velocity
        (A_Predefined_Cross_Wind_Velocity ,
         An_Instance                    );

    Winds.Assign_Cross_Wind_Altitude
        (A_Predefined_Cross_Wind_Altitude,
         An_Instance                    );

    Winds.Set_Cross_Wind_Direction (A_Runway_Threshold_Heading,
                                        An_Instance              );

    pass := abs(Winds.Get_Cross_Wind_Direction (An_Instance) - 2.29191444) <= A_Tolerance;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Cross_Wind_Direction (An_Instance));
    put_line(" Get_Cross_Wind_Direction ");

    Winds.Assign_Surface_Wind_Velocity
        (A_Predefined_Surface_Wind_Velocity,
         An_Instance                      );

    --| If the aircraft is in the surface or cruise wind region then skip calculation wind velocity
    --| and wind direction based on slope, but use the Assign_Wind_Velocity and Assign_Wind_Direction
    --| procedures to set the wind velocity and wind direction to the respective regions velocity and
    --| direction.
    Winds.Set_Velocity_Slope (An_Instance);

    pass := abs(Winds.Get_Velocity_Slope (An_Instance) - 0.012444) <= A_Tolerance;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Velocity_Slope (An_Instance));
    put_line(" Get_Velocity_Slope ");

    Winds.Set_Direction_Slope (An_Instance );

    pass := abs(Winds.Get_Direction_Slope (An_Instance) - (-0.039004)) <= A_Tolerance;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Direction_Slope (An_Instance));
    put_line(" Get_Direction_Slope ");

    Winds.Set_Wind_Direction (An_Aircraft_Geometric_Altitude,
                                  An_Instance                  );

    pass := abs(Winds.Get_Wind_Direction (An_Instance) - (-3.794)) <= A_Tolerance;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Direction (An_Instance));
    put_line(" Get_Wind_Direction ");

    Winds.Set_Wind_Velocity (An_Aircraft_Geometric_Altitude,
                                 An_Instance                  );

    pass := abs(Winds.Get_Wind_Velocity (An_Instance) - 66.804) <= A_Tolerance;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Velocity (An_Instance));
    put_line(" Get_Wind_Velocity ");

    --| This procedure will sum the wind velocities generated by the atmospheric phenomenon of
    --| 1. A_Steady_State_Wind
    --| 2. A_Steady_State_Winds_Increments
    --| 3. A_Wind_Gust
    --| 4. A_Microburst and
    --| 5. A_Wind_Shear
    Winds.Set_Wind_Velocity_Earth_Axis
        (A_Steady_State_Wind_Velocity_Earth_Axis             ,
         A_Steady_State_Wind_Increment_in_Velocity_Earth_Axis,
         A_Wind_Gust_Velocity_Earth_Axis                      ,
         A_Microburst_Velocity_Earth_Axis                    ,
         A_Wind_Shear_Velocity_Earth_Axis                    ,
         An_Instance                                        );

    pass := abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).x - (-4.4399999)) <= A_Tolerance and
            abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).y - 3.39) <= A_Tolerance and
            abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).z - 0.45) <= A_Tolerance;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).x);   put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).y);
    put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).z);   put_line(" Get_Wind_Velocity_Earth_Axis ");

    Winds.Set_Display_Winds
        (An_Aircraft_Yaw_Angle                             ,
         A_Steady_State_Wind_Velocity_Earth_Axis           ,
         A_Wind_Gust_Velocity_Earth_Axis                    ,
         A_Microburst_Velocity_Earth_Axis                   ,
         A_Wind_Shear_Velocity_Earth_Axis                  ,
         An_Instance                                        );

    pass := abs(Winds.Get_Display_Head_Wind_Velocity (An_Instance) - (-25.7481372)) <= A_Tolerance and
            abs(Winds.Get_Display_Cross_Wind_Velocity (An_Instance) - (-61.642582)) <= A_Tolerance;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Display_Head_Wind_Velocity (An_Instance));
    put_line(" Get_Display_Head_Wind_Velocity ");

    put(Winds.Get_Display_Cross_Wind_Velocity (An_Instance));
    put_line(" Get_Display_Cross_Wind_Velocity ");


    put_line("------------------ CONSTRAINT ---------------------");

    A_Predefined_Surface_Wind_Velocity                   := 1000.0;
    A_Predefined_Surface_Wind_Altitude                   := 100000.0;
    A_Predefined_Surface_Wind_Direction                  := 1000.0;
    A_Predefined_Cruise_Wind_Velocity                    := 1000.0;
    A_Predefined_Cruise_Wind_Altitude                    := 100000.0;
    A_Predefined_Cruise_Wind_Direction                   := 1000.0;
    A_Predefined_Cross_Wind_Valid                        := false;
    A_Predefined_Cross_Wind_Velocity                     := 1000.0;
    A_Predefined_Cross_Wind_Altitude                     := 350000.0;
    A_Runway_Threshold_Heading                           := 1000.0;
    An_Aircraft_Geometric_Altitude                       := 600000.0;
    A_Steady_State_Wind_Velocity_Earth_Axis              := (1000.0,1000.0,1000.0);
    A_Steady_State_Wind_Increment_in_Velocity_Earth_Axis := (1000.0,1000.0,1000.0);
    A_Wind_Gust_Velocity_Earth_Axis                      := (1000.0,1000.0,1000.0);
    A_Microburst_Velocity_Earth_Axis                     := (1000.0,1000.0,1000.0);
    A_Wind_Shear_Velocity_Earth_Axis                     := (1000.0,1000.0,1000.0);
    An_Aircraft_Yaw_Angle                                := 1000.0;

    Winds.Assign_Surface_Wind_Altitude
        (A_Predefined_Surface_Wind_Altitude,
         An_Instance                      );

    Winds.Assign_Surface_Wind_Direction
        (A_Predefined_Surface_Wind_Direction,
         An_Instance                       );

    Winds.Assign_Cruise_Wind_Velocity
        (A_Predefined_Cruise_Wind_Velocity,
         An_Instance                     );

    Winds.Assign_Cruise_Wind_Altitude
        (A_Predefined_Cruise_Wind_Altitude ,
         An_Instance                     );

    Winds.Assign_Cruise_Wind_Direction
        (A_Predefined_Cruise_Wind_Direction,
         An_Instance                      );

    Winds.Assign_Cross_Wind_Valid(A_Predefined_Cross_Wind_Valid ,
                                      An_Instance                 );

    Winds.Assign_Cross_Wind_Velocity
        (A_Predefined_Cross_Wind_Velocity ,
         An_Instance                    );

    Winds.Assign_Cross_Wind_Altitude
        (A_Predefined_Cross_Wind_Altitude,
         An_Instance                    );

    Winds.Set_Cross_Wind_Direction (A_Runway_Threshold_Heading,
                                        An_Instance              );

    pass := abs(Winds.Get_Cross_Wind_Direction (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Cross_Wind_Direction (An_Instance));
    put_line(" Get_Cross_Wind_Direction ");

    Winds.Assign_Surface_Wind_Velocity
        (A_Predefined_Surface_Wind_Velocity,
         An_Instance                      );

    --| If the aircraft is in the surface or cruise wind region then skip calculation wind velocity
    --| and wind direction based on slope, but use the Assign_Wind_Velocity and Assign_Wind_Direction
    --| procedures to set the wind velocity and wind direction to the respective regions velocity and
    --| direction.
    Winds.Set_Velocity_Slope (An_Instance);

    pass := abs(Winds.Get_Velocity_Slope (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Velocity_Slope (An_Instance));
    put_line(" Get_Velocity_Slope ");

    Winds.Set_Direction_Slope (An_Instance );

    pass := abs(Winds.Get_Direction_Slope (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Direction_Slope (An_Instance));
    put_line(" Get_Direction_Slope ");

    Winds.Set_Wind_Direction (An_Aircraft_Geometric_Altitude,
                                  An_Instance                  );

    pass := abs(Winds.Get_Wind_Direction (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Direction (An_Instance));
    put_line(" Get_Wind_Direction ");

    Winds.Set_Wind_Velocity (An_Aircraft_Geometric_Altitude,
                                 An_Instance                  );

    pass := abs(Winds.Get_Wind_Velocity (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Velocity (An_Instance));
    put_line(" Get_Wind_Velocity ");

    --| This procedure will sum the wind velocities generated by the atmospheric phenomenon of
    --| 1. A_Steady_State_Wind
    --| 2. A_Steady_State_Winds_Increments
    --| 3. A_Wind_Gust
    --| 4. A_Microburst and
    --| 5. A_Wind_Shear
    Winds.Set_Wind_Velocity_Earth_Axis
        (A_Steady_State_Wind_Velocity_Earth_Axis             ,
         A_Steady_State_Wind_Increment_in_Velocity_Earth_Axis,
         A_Wind_Gust_Velocity_Earth_Axis                      ,
         A_Microburst_Velocity_Earth_Axis                    ,
         A_Wind_Shear_Velocity_Earth_Axis                    ,
         An_Instance                                        );

    pass := abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).x) >= 0.0 and
            abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).y) >= 0.0 and
            abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).z) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).x);   put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).y);
    put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).z);   put_line(" Get_Wind_Velocity_Earth_Axis ");

    Winds.Set_Display_Winds
        (An_Aircraft_Yaw_Angle                             ,
         A_Steady_State_Wind_Velocity_Earth_Axis           ,
         A_Wind_Gust_Velocity_Earth_Axis                    ,
         A_Microburst_Velocity_Earth_Axis                   ,
         A_Wind_Shear_Velocity_Earth_Axis                  ,
         An_Instance                                        );

    pass := abs(Winds.Get_Display_Head_Wind_Velocity (An_Instance)) >= 0.0 and
            abs(Winds.Get_Display_Cross_Wind_Velocity (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Display_Head_Wind_Velocity (An_Instance));
    put_line(" Get_Display_Head_Wind_Velocity ");

    put(Winds.Get_Display_Cross_Wind_Velocity (An_Instance));
    put_line(" Get_Display_Cross_Wind_Velocity ");

 put_line("-------------------- END --------------------");

    A_Predefined_Surface_Wind_Velocity                   := 0.0;
    A_Predefined_Surface_Wind_Altitude                   := 0.0;
    A_Predefined_Surface_Wind_Direction                  := 0.0;
    A_Predefined_Cruise_Wind_Velocity                    := 0.0;
    A_Predefined_Cruise_Wind_Altitude                    := 0.0;
    A_Predefined_Cruise_Wind_Direction                   := 0.0;
    A_Predefined_Cross_Wind_Valid                        := false;
    A_Predefined_Cross_Wind_Velocity                     := 0.0;
    A_Predefined_Cross_Wind_Altitude                     := 0.0;
    A_Runway_Threshold_Heading                           := 0.0;
    An_Aircraft_Geometric_Altitude                       := 0.0;
    A_Steady_State_Wind_Velocity_Earth_Axis              := (0.0,0.0,0.0);
    A_Steady_State_Wind_Increment_in_Velocity_Earth_Axis := (0.0,0.0,0.0);
    A_Wind_Gust_Velocity_Earth_Axis                      := (0.0,0.0,0.0);
    A_Microburst_Velocity_Earth_Axis                     := (0.0,0.0,0.0);
    A_Wind_Shear_Velocity_Earth_Axis                     := (0.0,0.0,0.0);
    An_Aircraft_Yaw_Angle                                := 0.0;

    Winds.Assign_Surface_Wind_Altitude
        (A_Predefined_Surface_Wind_Altitude,
         An_Instance                      );

    Winds.Assign_Surface_Wind_Direction
        (A_Predefined_Surface_Wind_Direction,
         An_Instance                       );

    Winds.Assign_Cruise_Wind_Velocity
        (A_Predefined_Cruise_Wind_Velocity,
         An_Instance                     );

    Winds.Assign_Cruise_Wind_Altitude
        (A_Predefined_Cruise_Wind_Altitude ,
         An_Instance                     );

    Winds.Assign_Cruise_Wind_Direction
        (A_Predefined_Cruise_Wind_Direction,
         An_Instance                      );

    Winds.Assign_Cross_Wind_Valid(A_Predefined_Cross_Wind_Valid ,
                                      An_Instance                 );

    Winds.Assign_Cross_Wind_Velocity
        (A_Predefined_Cross_Wind_Velocity ,
         An_Instance                    );

    Winds.Assign_Cross_Wind_Altitude
        (A_Predefined_Cross_Wind_Altitude,
         An_Instance                    );

    Winds.Set_Cross_Wind_Direction (A_Runway_Threshold_Heading,
                                        An_Instance              );

    pass := abs(Winds.Get_Cross_Wind_Direction (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Cross_Wind_Direction (An_Instance));
    put_line(" Get_Cross_Wind_Direction ");

    Winds.Assign_Surface_Wind_Velocity
        (A_Predefined_Surface_Wind_Velocity,
         An_Instance                      );

    --| If the aircraft is in the surface or cruise wind region then skip calculation wind velocity
    --| and wind direction based on slope, but use the Assign_Wind_Velocity and Assign_Wind_Direction
    --| procedures to set the wind velocity and wind direction to the respective regions velocity and
    --| direction.
    Winds.Set_Velocity_Slope (An_Instance);

    pass := abs(Winds.Get_Velocity_Slope (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Velocity_Slope (An_Instance));
    put_line(" Get_Velocity_Slope ");

    Winds.Set_Direction_Slope (An_Instance );

    pass := abs(Winds.Get_Direction_Slope (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Direction_Slope (An_Instance));
    put_line(" Get_Direction_Slope ");

    Winds.Set_Wind_Direction (An_Aircraft_Geometric_Altitude,
                                  An_Instance                  );

    pass := abs(Winds.Get_Wind_Direction (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Direction (An_Instance));
    put_line(" Get_Wind_Direction ");

    Winds.Set_Wind_Velocity (An_Aircraft_Geometric_Altitude,
                                 An_Instance                  );

    pass := abs(Winds.Get_Wind_Velocity (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Velocity (An_Instance));
    put_line(" Get_Wind_Velocity ");

    --| This procedure will sum the wind velocities generated by the atmospheric phenomenon of
    --| 1. A_Steady_State_Wind
    --| 2. A_Steady_State_Winds_Increments
    --| 3. A_Wind_Gust
    --| 4. A_Microburst and
    --| 5. A_Wind_Shear
    Winds.Set_Wind_Velocity_Earth_Axis
        (A_Steady_State_Wind_Velocity_Earth_Axis             ,
         A_Steady_State_Wind_Increment_in_Velocity_Earth_Axis,
         A_Wind_Gust_Velocity_Earth_Axis                      ,
         A_Microburst_Velocity_Earth_Axis                    ,
         A_Wind_Shear_Velocity_Earth_Axis                    ,
         An_Instance                                        );

    pass := abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).x) >= 0.0 and
            abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).y) >= 0.0 and
            abs(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).z) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).x);   put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).y);
    put(Winds.Get_Wind_Velocity_Earth_Axis (An_Instance).z);   put_line(" Get_Wind_Velocity_Earth_Axis ");

    Winds.Set_Display_Winds
        (An_Aircraft_Yaw_Angle                             ,
         A_Steady_State_Wind_Velocity_Earth_Axis           ,
         A_Wind_Gust_Velocity_Earth_Axis                    ,
         A_Microburst_Velocity_Earth_Axis                   ,
         A_Wind_Shear_Velocity_Earth_Axis                  ,
         An_Instance                                        );

    pass := abs(Winds.Get_Display_Head_Wind_Velocity (An_Instance)) >= 0.0 and
            abs(Winds.Get_Display_Cross_Wind_Velocity (An_Instance)) >= 0.0;
    Class_Test_Result_File.Report_Case_Status(pass);
    pass := false;

    put(Winds.Get_Display_Head_Wind_Velocity (An_Instance));
    put_line(" Get_Display_Head_Wind_Velocity ");

    put(Winds.Get_Display_Cross_Wind_Velocity (An_Instance));
    put_line(" Get_Display_Cross_Wind_Velocity ");



end EXECUTE_Winds;
