-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Wind_Shear;
with Coordinate_Types;
with Angle_Types;
with Lat_Long_Types;
with Interpolation_Table.Singly_Indexed;
with Length_Types;
with Class_Test_Result_File;


procedure EXECUTE_Wind_Shear is
    An_Instance                : Wind_Shear.Instance;

    A_File_Path : string := "c:\jpats\ada_code\mkii\data_tables\wind_shear_db\";

    A_Predefined_Wind_Shear_Intensity                : Float;
    A_Predefined_Wind_Shear_Wind_Factor              : Float;
    A_Predefined_Wind_Shear_Magnitude                : Float;
    An_Aircraft_Latitude                             : Lat_Long_Types.Latitude_Degrees;
    An_Aircraft_Last_Pass_Latitude                   : Lat_Long_Types.Latitude_Degrees;
    An_Aircraft_Longitude                            : Lat_Long_Types.Longitude_Degrees;
    An_Aircraft_Last_Pass_Longitude                  : Lat_Long_Types.Longitude_Degrees;
    A_Yaw_Angle                                      : Angle_Types.Radians;
    A_Predefined_Wind_Shear_Lagged_Longitudinal_Wind : Length_Types.Feet_per_Sec;
    A_Predefined_Wind_Shear_Lagged_Lateral_Wind      : Length_Types.Feet_per_Sec;
    A_Predefined_Wind_Shear_Lagged_Vertical_Wind     : Length_Types.Feet_per_Sec;
    A_Predefined_Aircraft_x_Distance_over_Wind_Shear : Length_Types.Feet;
    A_Predefined_Wind_Shear_Velocity_Earth_Axis      : Coordinate_Types.Cartesian;
    A_Predefined_Wind_Shear_Turbulence_Intensity     : Float;


    WSM_1_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_1_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_1_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSM_2_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_2_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_2_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSM_3_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_3_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_3_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSM_4_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_4_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_4_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSM_5_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_5_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_5_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSM_6_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_6_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_6_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSM_7_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_7_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_7_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSM_8_xV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_8_yV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSM_8_zV_Table : Interpolation_Table.Singly_Indexed.Instance;

    WSMxV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSMyV_Table : Interpolation_Table.Singly_Indexed.Instance;
    WSMzV_Table : Interpolation_Table.Singly_Indexed.Instance;


    Pass : Boolean := False;
    A_Tolerance : Float := 0.000_1;

begin

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_1_xV.csv",WSM_1_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_1_yV.csv",WSM_1_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_1_zV.csv",WSM_1_zV_Table);

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_2_xV.csv",WSM_2_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_2_yV.csv",WSM_2_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_2_zV.csv",WSM_2_zV_Table);

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_3_xV.csv",WSM_3_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_3_yV.csv",WSM_3_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_3_zV.csv",WSM_3_zV_Table);

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_4_xV.csv",WSM_4_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_4_yV.csv",WSM_4_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_4_zV.csv",WSM_4_zV_Table);

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_5_xV.csv",WSM_5_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_5_yV.csv",WSM_5_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_5_zV.csv",WSM_5_zV_Table);

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_6_xV.csv",WSM_6_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_6_yV.csv",WSM_6_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_6_zV.csv",WSM_6_zV_Table);

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_7_xV.csv",WSM_7_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_7_yV.csv",WSM_7_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_7_zV.csv",WSM_7_zV_Table);

    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_8_xV.csv",WSM_8_xV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_8_yV.csv",WSM_8_yV_Table);
    Interpolation_Table.Singly_Indexed.Read_ASCII(A_File_Path & "WSM#_8_zV.csv",WSM_8_zV_Table);

    A_Predefined_Wind_Shear_Intensity                := 0.0;
    A_Predefined_Wind_Shear_Wind_Factor              := 0.0;
    A_Predefined_Wind_Shear_Magnitude                := 1.0;
    An_Aircraft_Latitude                             := 45.0002;
    An_Aircraft_Last_Pass_Latitude                   := 45.0;
    An_Aircraft_Longitude                            := 30.0;
    An_Aircraft_Last_Pass_Longitude                  := 30.0001;
    A_Yaw_Angle                                      := 25.0*3.142/180.0;
    WSMxV_Table                                      := WSM_2_xV_Table;
    WSMyV_Table                                      := WSM_2_yV_Table;
    WSMzV_Table                                      := WSM_2_zV_Table;
    A_Predefined_Wind_Shear_Lagged_Longitudinal_Wind := 0.0;
    A_Predefined_Wind_Shear_Lagged_Lateral_Wind      := 0.0;
    A_Predefined_Wind_Shear_Lagged_Vertical_Wind     := 0.0;
    A_Predefined_Aircraft_x_Distance_over_Wind_Shear := 5500.0;
    A_Predefined_Wind_Shear_Velocity_Earth_Axis      := (0.0,0.0,0.0);
    A_Predefined_Wind_Shear_Turbulence_Intensity     := 0.0;


    Wind_Shear.Assign_Magnitude(A_Predefined_Wind_Shear_Magnitude,
                               An_Instance );

    Wind_Shear.Assign_Aircraft_x_Distance_over_Wind_Shear
        (A_Predefined_Aircraft_x_Distance_over_Wind_Shear,
         An_Instance                                     );

    Wind_Shear.Set_Velocity_Earth_Axis
        (An_Aircraft_Latitude            ,
         An_Aircraft_Last_Pass_Latitude  ,
         An_Aircraft_Longitude           ,
         An_Aircraft_Last_Pass_Longitude ,
         A_Yaw_Angle                     ,
         WSMxV_Table                     ,
         WSMyV_Table                     ,
         WSMzV_Table                     ,
         An_Instance                    );


      pass:=abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).x - (-0.24180717)) <= A_Tolerance and
            abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).y - (-0.66447671)) <= A_Tolerance and
            abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).z - (-1.0)) <= A_Tolerance;

     Class_Test_Result_File.Report_Case_Status(pass);
     pass := false;

     put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).x); put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).y);
     put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).z); put_line( " Velocity_Earth_Axis ");


     put_line("---------------- CONSTRAINT ---------------------");

    A_Predefined_Wind_Shear_Intensity                := 1000.0;
    A_Predefined_Wind_Shear_Wind_Factor              := 1000.0;
    A_Predefined_Wind_Shear_Magnitude                := 1000.0;
    An_Aircraft_Latitude                             := 45.0002;
    An_Aircraft_Last_Pass_Latitude                   := 45.0;
    An_Aircraft_Longitude                            := 30.0;
    An_Aircraft_Last_Pass_Longitude                  := 30.0001;
    A_Yaw_Angle                                      := 1000.0;
    WSMxV_Table                                      := WSM_2_xV_Table;
    WSMyV_Table                                      := WSM_2_yV_Table;
    WSMzV_Table                                      := WSM_2_zV_Table;
    A_Predefined_Wind_Shear_Lagged_Longitudinal_Wind := 1000.0;
    A_Predefined_Wind_Shear_Lagged_Lateral_Wind      := 1000.0;
    A_Predefined_Wind_Shear_Lagged_Vertical_Wind     := 1000.0;
    A_Predefined_Aircraft_x_Distance_over_Wind_Shear := 100000.0;
    A_Predefined_Wind_Shear_Velocity_Earth_Axis      := (1000.0,1000.0,1000.0);
    A_Predefined_Wind_Shear_Turbulence_Intensity     := 1000.0;


    Wind_Shear.Assign_Magnitude(A_Predefined_Wind_Shear_Magnitude,
                               An_Instance );

    Wind_Shear.Assign_Aircraft_x_Distance_over_Wind_Shear
        (A_Predefined_Aircraft_x_Distance_over_Wind_Shear,
         An_Instance                                     );

    Wind_Shear.Set_Velocity_Earth_Axis
        (An_Aircraft_Latitude            ,
         An_Aircraft_Last_Pass_Latitude  ,
         An_Aircraft_Longitude           ,
         An_Aircraft_Last_Pass_Longitude ,
         A_Yaw_Angle                     ,
         WSMxV_Table                     ,
         WSMyV_Table                     ,
         WSMzV_Table                     ,
         An_Instance                    );


      pass:=abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).x) >= 0.0 and
            abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).y) >= 0.0 and
            abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).z) >= 0.0 ;

     Class_Test_Result_File.Report_Case_Status(pass);
     pass := false;

     put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).x); put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).y);
     put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).z); put_line( " Velocity_Earth_Axis ");


     put_line("---------------- END ---------------------");

    A_Predefined_Wind_Shear_Intensity                := 0.0;
    A_Predefined_Wind_Shear_Wind_Factor              := 0.0;
    A_Predefined_Wind_Shear_Magnitude                := 0.0;
    An_Aircraft_Latitude                             := 0.0;
    An_Aircraft_Last_Pass_Latitude                   := 0.0;
    An_Aircraft_Longitude                            := 0.0;
    An_Aircraft_Last_Pass_Longitude                  := 0.0;
    A_Yaw_Angle                                      := 0.0;
    WSMxV_Table                                      := WSM_2_xV_Table;
    WSMyV_Table                                      := WSM_2_yV_Table;
    WSMzV_Table                                      := WSM_2_zV_Table;
    A_Predefined_Wind_Shear_Lagged_Longitudinal_Wind := 0.0;
    A_Predefined_Wind_Shear_Lagged_Lateral_Wind      := 0.0;
    A_Predefined_Wind_Shear_Lagged_Vertical_Wind     := 0.0;
    A_Predefined_Aircraft_x_Distance_over_Wind_Shear := 0.0;
    A_Predefined_Wind_Shear_Velocity_Earth_Axis      := (0.0,0.0,0.0);
    A_Predefined_Wind_Shear_Turbulence_Intensity     := 0.0;


    Wind_Shear.Assign_Magnitude(A_Predefined_Wind_Shear_Magnitude,
                               An_Instance );

    Wind_Shear.Assign_Aircraft_x_Distance_over_Wind_Shear
        (A_Predefined_Aircraft_x_Distance_over_Wind_Shear,
         An_Instance                                     );

    Wind_Shear.Set_Velocity_Earth_Axis
        (An_Aircraft_Latitude            ,
         An_Aircraft_Last_Pass_Latitude  ,
         An_Aircraft_Longitude           ,
         An_Aircraft_Last_Pass_Longitude ,
         A_Yaw_Angle                     ,
         WSMxV_Table                     ,
         WSMyV_Table                     ,
         WSMzV_Table                     ,
         An_Instance                    );


      pass:=abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).x) >= 0.0 and
            abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).y) >= 0.0 and
            abs(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).z) >= 0.0 ;

     Class_Test_Result_File.Report_Case_Status(pass);
     pass := false;

     put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).x); put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).y);
     put(Wind_Shear.Get_Velocity_Earth_Axis(An_Instance).z); put_line( " Velocity_Earth_Axis ");



end EXECUTE_Wind_Shear;
