-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Wind_Gust;

with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Class_Test_Result_File;


procedure EXECUTE_Wind_Gust is
    An_Instance                : Wind_Gust.Instance;

    A_Predefined_Wind_Gust_Counter             : Float;
    A_Predefined_Wind_Gust_Random_Counter      : Float;
    A_Predefined_New_Wind_Gust_Output          : Float;
    A_Predefined_Wind_Gust_Output              : Float;
    A_Predefined_Desired_Wind_Gust_Velocity    : Length_Types.Feet_per_Sec;
    A_Geometric_Altitude                       : Length_Types.Feet;
    A_Wind_Velocity                            : Length_Types.Feet_per_Sec;
    A_Wind_Direction                           : Angle_Types.Radians;
    An_Integration_Constant                    : Float;
    A_Predefined_Wind_Gust_Velocity_Earth_Axis : Coordinate_Types.Cartesian;
    A_Predefined_Wind_Gust_Direction           : Angle_Types.Radians;
    A_Predefined_Wind_Training_Direction       : Angle_Types.Radians;
    Pass : Boolean := False;
    A_Tolerance : Float := 0.000_1;

begin

    A_Predefined_Wind_Gust_Counter             := 0.0;
    A_Predefined_Wind_Gust_Random_Counter      := 0.0;
    A_Predefined_New_Wind_Gust_Output          := 0.0;
    A_Predefined_Wind_Gust_Output              := 0.0;
    A_Predefined_Desired_Wind_Gust_Velocity    := 115.69;
    A_Geometric_Altitude                       := 2530.0;
    A_Wind_Velocity                            := 56.3;
    A_Wind_Direction                           := 0.689;
    An_Integration_Constant                    := 1.0/60.0;
    A_Predefined_Wind_Gust_Velocity_Earth_Axis := (0.0,0.0,0.0);
    A_Predefined_Wind_Gust_Direction           := 0.231;
    A_Predefined_Wind_Training_Direction       := 25.6*3.142/180.0;


    Wind_Gust.Assign_Wind_Gust_Timer
        (A_Predefined_Wind_Gust_Counter       ,
         A_Predefined_Wind_Gust_Random_Counter,
         An_Instance                          );
    Wind_Gust.Assign_New_Wind_Gust_Output (A_Predefined_New_Wind_Gust_Output,
                                           An_Instance                      );

    Wind_Gust.Assign_Wind_Gust_Output (A_Predefined_Wind_Gust_Output,
                                       An_Instance                  );

    Wind_Gust.Assign_Desired_Wind_Gust_Velocity
        (A_Predefined_Desired_Wind_Gust_Velocity,
         An_Instance                            );

    Wind_Gust.Assign_Direction
        (A_Predefined_Wind_Gust_Direction,
         An_Instance                     );

    Wind_Gust.Assign_Wind_Training_Direction
        (A_Predefined_Wind_Training_Direction,
         An_Instance                         );

    Wind_Gust.Set_Velocity_Earth_Axis_and_Direction
        (A_Geometric_Altitude   ,
         A_Wind_Velocity        ,
         A_Wind_Direction       ,
         An_Integration_Constant,
         An_Instance            );


    Pass := abs(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).x - (-1.83910394)) <= A_Tolerance and
            abs(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).y - (-0.51387858)) <= A_Tolerance;

    Class_Test_Result_File.Report_Case_Status(Pass);
    Pass := False;

    put(Wind_Gust.Get_Wind_Gust_Counter (An_Instance));
    put_line(" Get_Wind_Gust_Counter ");
    put(Wind_Gust.Get_Wind_Gust_Random_Counter (An_Instance));
    put_line(" Get_Wind_Gust_Random_Counter ");
    put(Wind_Gust.Get_New_Wind_Gust_Output (An_Instance));
    put_line(" Get_New_Wind_Gust_Output ");
    put(Wind_Gust.Get_Wind_Gust_Output (An_Instance));
    put_line(" Get_Wind_Gust_Output ");

    put(Wind_Gust.Get_Wind_Gust_Velocity (An_Instance));  put_line(" Get_Wind_Gust_Velocity ");
    put(Wind_Gust.Get_Direction (An_Instance)*180.0/3.142);
    put_line(" Get_Direction ");
    put(Wind_Gust.Get_Wind_Training_Direction (An_Instance)*180.0/3.142);
    put_line(" Get_Wind_Training_Direction ");

Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).x);Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).y);
Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).z);       Put_Line(" Local_Velocity ");

put_line("------------------ CONSTRAINT ---------------------");

    A_Predefined_Wind_Gust_Counter             := 1000.0;
    A_Predefined_Wind_Gust_Random_Counter      := 1000.0;
    A_Predefined_New_Wind_Gust_Output          := 1000.0;
    A_Predefined_Wind_Gust_Output              := 1000.0;
    A_Predefined_Desired_Wind_Gust_Velocity    := 1000.0;
    A_Geometric_Altitude                       := 100000.0;
    A_Wind_Velocity                            := 1000.0;
    A_Wind_Direction                           := 1000.0;
    An_Integration_Constant                    := 1.0/60.0;
    A_Predefined_Wind_Gust_Velocity_Earth_Axis := (1000.0,1000.0,1000.0);
    A_Predefined_Wind_Gust_Direction           := 1000.0;
    A_Predefined_Wind_Training_Direction       := 1000.0;


    Wind_Gust.Assign_Wind_Gust_Timer
        (A_Predefined_Wind_Gust_Counter       ,
         A_Predefined_Wind_Gust_Random_Counter,
         An_Instance                          );
    Wind_Gust.Assign_New_Wind_Gust_Output (A_Predefined_New_Wind_Gust_Output,
                                           An_Instance                      );

    Wind_Gust.Assign_Wind_Gust_Output (A_Predefined_Wind_Gust_Output,
                                       An_Instance                  );

    Wind_Gust.Assign_Desired_Wind_Gust_Velocity
        (A_Predefined_Desired_Wind_Gust_Velocity,
         An_Instance                            );

    Wind_Gust.Assign_Direction
        (A_Predefined_Wind_Gust_Direction,
         An_Instance                     );

    Wind_Gust.Assign_Wind_Training_Direction
        (A_Predefined_Wind_Training_Direction,
         An_Instance                         );

    Wind_Gust.Set_Velocity_Earth_Axis_and_Direction
        (A_Geometric_Altitude   ,
         A_Wind_Velocity        ,
         A_Wind_Direction       ,
         An_Integration_Constant,
         An_Instance            );


    Pass := abs(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).x) >= 0.0 and
            abs(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).y) >= 0.0;

    Class_Test_Result_File.Report_Case_Status(Pass);
    Pass := False;

    put(Wind_Gust.Get_Wind_Gust_Counter (An_Instance));
    put_line(" Get_Wind_Gust_Counter ");
    put(Wind_Gust.Get_Wind_Gust_Random_Counter (An_Instance));
    put_line(" Get_Wind_Gust_Random_Counter ");
    put(Wind_Gust.Get_New_Wind_Gust_Output (An_Instance));
    put_line(" Get_New_Wind_Gust_Output ");
    put(Wind_Gust.Get_Wind_Gust_Output (An_Instance));
    put_line(" Get_Wind_Gust_Output ");

    put(Wind_Gust.Get_Wind_Gust_Velocity (An_Instance));  put_line(" Get_Wind_Gust_Velocity ");
    put(Wind_Gust.Get_Direction (An_Instance)*180.0/3.142);
    put_line(" Get_Direction ");
    put(Wind_Gust.Get_Wind_Training_Direction (An_Instance)*180.0/3.142);
    put_line(" Get_Wind_Training_Direction ");

Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).x);Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).y);
Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).z);       Put_Line(" Local_Velocity ");


put_line("------------------ END ---------------------");

    A_Predefined_Wind_Gust_Counter             := 0.0;
    A_Predefined_Wind_Gust_Random_Counter      := 0.0;
    A_Predefined_New_Wind_Gust_Output          := 0.0;
    A_Predefined_Wind_Gust_Output              := 0.0;
    A_Predefined_Desired_Wind_Gust_Velocity    := 0.0;
    A_Geometric_Altitude                       := 0.0;
    A_Wind_Velocity                            := 0.0;
    A_Wind_Direction                           := 0.0;
    An_Integration_Constant                    := 0.0;
    A_Predefined_Wind_Gust_Velocity_Earth_Axis := (0.0,0.0,00.0);
    A_Predefined_Wind_Gust_Direction           := 0.0;
    A_Predefined_Wind_Training_Direction       := 0.0;


    Wind_Gust.Assign_Wind_Gust_Timer
        (A_Predefined_Wind_Gust_Counter       ,
         A_Predefined_Wind_Gust_Random_Counter,
         An_Instance                          );
    Wind_Gust.Assign_New_Wind_Gust_Output (A_Predefined_New_Wind_Gust_Output,
                                           An_Instance                      );

    Wind_Gust.Assign_Wind_Gust_Output (A_Predefined_Wind_Gust_Output,
                                       An_Instance                  );

    Wind_Gust.Assign_Desired_Wind_Gust_Velocity
        (A_Predefined_Desired_Wind_Gust_Velocity,
         An_Instance                            );

    Wind_Gust.Assign_Direction
        (A_Predefined_Wind_Gust_Direction,
         An_Instance                     );

    Wind_Gust.Assign_Wind_Training_Direction
        (A_Predefined_Wind_Training_Direction,
         An_Instance                         );

    Wind_Gust.Set_Velocity_Earth_Axis_and_Direction
        (A_Geometric_Altitude   ,
         A_Wind_Velocity        ,
         A_Wind_Direction       ,
         An_Integration_Constant,
         An_Instance            );


    Pass := abs(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).x) >= 0.0 and
            abs(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).y) >= 0.0;

    Class_Test_Result_File.Report_Case_Status(Pass);
    Pass := False;

    put(Wind_Gust.Get_Wind_Gust_Counter (An_Instance));
    put_line(" Get_Wind_Gust_Counter ");
    put(Wind_Gust.Get_Wind_Gust_Random_Counter (An_Instance));
    put_line(" Get_Wind_Gust_Random_Counter ");
    put(Wind_Gust.Get_New_Wind_Gust_Output (An_Instance));
    put_line(" Get_New_Wind_Gust_Output ");
    put(Wind_Gust.Get_Wind_Gust_Output (An_Instance));
    put_line(" Get_Wind_Gust_Output ");

    put(Wind_Gust.Get_Wind_Gust_Velocity (An_Instance));  put_line(" Get_Wind_Gust_Velocity ");
    put(Wind_Gust.Get_Direction (An_Instance)*180.0/3.142);
    put_line(" Get_Direction ");
    put(Wind_Gust.Get_Wind_Training_Direction (An_Instance)*180.0/3.142);
    put_line(" Get_Wind_Training_Direction ");

Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).x);Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).y);
Put(Wind_Gust.Get_Velocity_Earth_Axis(An_Instance).z);       Put_Line(" Local_Velocity ");



end EXECUTE_Wind_Gust;
