-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Turbulence;

with Angle_Types;
with Coordinate_Types;
with Length_Types;

with Class_Test_Result_File;


procedure EXECUTE_Turb is
    An_Instance                : Turbulence.Instance;


    A_Predefined_Rough_Air_Intensity  : float;
    A_Wind_Shear_Turbulence_Intensity : float;
    A_Radar_Turbulence_Intensity      : float;
    An_Aircraft_Geometric_Altitude    :Length_Types.Feet;
    An_Integration_Constant           : float;
    A_True_Airspeed                   :Length_Types.Feet_per_Sec;
    An_Angle_of_Attack                :Angle_Types.Degrees;
    A_Side_Slip_Angle                 :Angle_Types.Degrees;
    A_Tail_Bumper_Fuselage_Station                                     :Length_Types.Feet;
    A_Simulated_Aircraft_Fuselage_Station_of_Current_Center_of_Gravity :Length_Types.Feet;
    A_Wing_Span                                                        :Length_Types.Feet;
    A_Predefined_Turbulence_State_Vector   : Coordinate_Types.Array_Type(1..11);
    A_Predefined_Turbulence_Seed_Value : integer;
    A_Predefined_XNP   :float;
    A_Predefined_XINTQ :float;
    A_Predefined_XNQ   :float;
    A_Predefined_XINTR :float;
    A_Predefined_XNR   :float;

    Pass : Boolean := False;
    A_Tolerance : Float := 0.000_1;

begin

    A_Predefined_Rough_Air_Intensity  :=  25.0;
    A_Wind_Shear_Turbulence_Intensity :=  10.0;
    A_Radar_Turbulence_Intensity      :=  0.0;
    An_Aircraft_Geometric_Altitude    :=  6521.0;
    An_Integration_Constant           :=  1.0/60.0;
    A_True_Airspeed                   :=  250.2;
    An_Angle_of_Attack                :=  12.5* 22.0/7.0 / 180.0;
    A_Side_Slip_Angle                 :=  2.5 * 22.0/7.0 / 180.0;
    A_Tail_Bumper_Fuselage_Station    :=  21.833;
    A_Wing_Span                       :=  33.215;
    A_Simulated_Aircraft_Fuselage_Station_of_Current_Center_of_Gravity :=  13.695;
    A_Predefined_XNP    :=  0.0;
    A_Predefined_XINTQ :=  0.0;
    A_Predefined_XNQ    :=  0.0;
    A_Predefined_XINTR  :=  0.0;
    A_Predefined_XNR    :=  0.0;



    A_Predefined_Turbulence_State_Vector := (0.0,0.0,0.0,0.0,0.0,
                                             0.0,0.0,0.0,0.0,0.0,0.0);
    Turbulence.Assign_Turbulence_State_Vector
        (A_Predefined_Turbulence_State_Vector,
         An_Instance                          );

    Turbulence.Assign_Attribiutes(A_Predefined_XNP  ,
                                 A_Predefined_XINTQ ,
                                 A_Predefined_XNQ   ,
                                 A_Predefined_XINTR ,
                                 A_Predefined_XNR   ,
                                 An_Instance     );

    Turbulence.Set_Turbulence_Matrix(An_Instance );

    Turbulence.Assign_Rough_Air_Intensity (A_Predefined_Rough_Air_Intensity ,
                                          An_Instance                      );

     put(Turbulence.Get_Rough_Air_Intensity (An_Instance ));

    --| A_Radar_Turbulence_Intensity = 0.0 for JPATS as JPATS does not have weather radar.
    Turbulence.Set_Total_Turbulence_Intensity
        (A_Wind_Shear_Turbulence_Intensity ,
         A_Radar_Turbulence_Intensity      ,
         An_Instance                       );

    put(Turbulence.Get_Total_Turbulence_Intensity (An_Instance) );

    Turbulence.Set_Turbulence_Scale_Length (An_Aircraft_Geometric_Altitude ,
                                           An_Instance                    );

    put(Turbulence.Get_Turbulence_Scale_Length (An_Instance ));

    Turbulence.Set_RMS_Intensity (An_Aircraft_Geometric_Altitude,
                                 An_Integration_Constant        ,
                                 An_Instance                    );

    put(Turbulence.Get_RMS_Intensity (An_Instance ).x); put(Turbulence.Get_RMS_Intensity (An_Instance ).y);

    Turbulence.Set_Mean_Forward_Speed (A_True_Airspeed ,
                                      An_Instance     );

    put(Turbulence.Get_Mean_Forward_Speed (An_Instance ));

    Turbulence.Assign_Turbulence_State_Vector
        (A_Predefined_Turbulence_State_Vector,
         An_Instance                         );


    Turbulence.Set_Turbulence_State_Vector
        (An_Integration_Constant ,
         An_Instance             );


    Turbulence.Set_Turbulence_Velocity_Body_Axis_to_Compute
        (An_Angle_of_Attack,
         A_Side_Slip_Angle ,
         An_Instance        );

    --| This method will be used to compute Turbulence velocity until it has completely resided, when
    --| an active Turbulence is switched OFF by the instructor.
    --Turbulence.Set_Turbulence_Velocity_Body_Axis_to_Decay(An_Instance );
   new_line;
    put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).x);put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).y);
     put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).z);put_line ( "  Get_Turbulence_Velocity_Body_Axis " );

    Turbulence.Set_Turbulence_Angular_Rate_Body_Axis_to_Compute
        (A_Tail_Bumper_Fuselage_Station                                    ,
         A_Simulated_Aircraft_Fuselage_Station_of_Current_Center_of_Gravity,
         A_Wing_Span                                                       ,
         An_Integration_Constant                                            ,
         An_Instance                                                        );

   -- Turbulence.Set_Turbulence_Angular_Rate_Body_Axis_to_Decay(An_Instance );

    put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).roll); put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).pitch);
    put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).yaw); put_line ( "  Get_Turbulence_Angular_Rate_Body_Axis " );


    if abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).x) <= 10.0 and
       abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).y) <= 10.0 and
       abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).z) <= 10.0 and 
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).roll) <= 1.0 and
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).pitch) <= 1.0 and
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).yaw) <= 1.0 then
           pass := True;
    else
        pass := false;
    end if;
    
    Class_Test_Result_File.Report_Case_status(pass);
    pass:=false;
    
    put_line("------------------ CONSTRAINT -----------------");

    A_Predefined_Rough_Air_Intensity  :=  100.0;
    A_Wind_Shear_Turbulence_Intensity :=  100.0;
    A_Radar_Turbulence_Intensity      :=  100.0;
    An_Aircraft_Geometric_Altitude    :=  100000.0;
    An_Integration_Constant           :=  1.0/60.0;
    A_True_Airspeed                   :=  1000.0;
    An_Angle_of_Attack                :=  1000.0;
    A_Side_Slip_Angle                 := 1000.0;
    A_Tail_Bumper_Fuselage_Station    := 100.0;
    A_Wing_Span                       := 100.0;
    A_Simulated_Aircraft_Fuselage_Station_of_Current_Center_of_Gravity :=  100.0;
    A_Predefined_XNP    :=  10.0;
    A_Predefined_XINTQ :=  10.0;
    A_Predefined_XNQ    :=  10.0;
    A_Predefined_XINTR  := 10.0;
    A_Predefined_XNR    :=  10.0;



    A_Predefined_Turbulence_State_Vector := (10.0,10.0,10.0,10.0,10.0,
                                             10.0,10.0,10.0,10.0,10.0,10.0);
    Turbulence.Assign_Turbulence_State_Vector
        (A_Predefined_Turbulence_State_Vector,
         An_Instance                          );

    Turbulence.Assign_Attribiutes(A_Predefined_XNP  ,
                                 A_Predefined_XINTQ ,
                                 A_Predefined_XNQ   ,
                                 A_Predefined_XINTR ,
                                 A_Predefined_XNR   ,
                                 An_Instance     );

    Turbulence.Set_Turbulence_Matrix(An_Instance );

    Turbulence.Assign_Rough_Air_Intensity (A_Predefined_Rough_Air_Intensity ,
                                          An_Instance                      );

     put(Turbulence.Get_Rough_Air_Intensity (An_Instance ));

    --| A_Radar_Turbulence_Intensity = 0.0 for JPATS as JPATS does not have weather radar.
    Turbulence.Set_Total_Turbulence_Intensity
        (A_Wind_Shear_Turbulence_Intensity ,
         A_Radar_Turbulence_Intensity      ,
         An_Instance                       );

    put(Turbulence.Get_Total_Turbulence_Intensity (An_Instance) );

    Turbulence.Set_Turbulence_Scale_Length (An_Aircraft_Geometric_Altitude ,
                                           An_Instance                    );

    put(Turbulence.Get_Turbulence_Scale_Length (An_Instance ));

    Turbulence.Set_RMS_Intensity (An_Aircraft_Geometric_Altitude,
                                 An_Integration_Constant        ,
                                 An_Instance                    );

    put(Turbulence.Get_RMS_Intensity (An_Instance ).x); put(Turbulence.Get_RMS_Intensity (An_Instance ).y);

    Turbulence.Set_Mean_Forward_Speed (A_True_Airspeed ,
                                      An_Instance     );

    put(Turbulence.Get_Mean_Forward_Speed (An_Instance ));

    Turbulence.Assign_Turbulence_State_Vector
        (A_Predefined_Turbulence_State_Vector,
         An_Instance                         );


    Turbulence.Set_Turbulence_State_Vector
        (An_Integration_Constant ,
         An_Instance             );


    Turbulence.Set_Turbulence_Velocity_Body_Axis_to_Compute
        (An_Angle_of_Attack,
         A_Side_Slip_Angle ,
         An_Instance        );

    --| This method will be used to compute Turbulence velocity until it has completely resided, when
    --| an active Turbulence is switched OFF by the instructor.
    --Turbulence.Set_Turbulence_Velocity_Body_Axis_to_Decay(An_Instance );
   new_line;
    put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).x);put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).y);
     put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).z);put_line ( "  Get_Turbulence_Velocity_Body_Axis " );

    Turbulence.Set_Turbulence_Angular_Rate_Body_Axis_to_Compute
        (A_Tail_Bumper_Fuselage_Station                                    ,
         A_Simulated_Aircraft_Fuselage_Station_of_Current_Center_of_Gravity,
         A_Wing_Span                                                       ,
         An_Integration_Constant                                            ,
         An_Instance                                                        );

   -- Turbulence.Set_Turbulence_Angular_Rate_Body_Axis_to_Decay(An_Instance );

    put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).roll); put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).pitch);
    put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).yaw); put_line ( "  Get_Turbulence_Angular_Rate_Body_Axis " );


    if abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).x) >= 0.0 and
       abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).y) >= 0.0 and
       abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).z) >= 0.0 and 
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).roll) >= 0.0 and
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).pitch)>= 0.0 and
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).yaw) >= 0.0 then
           pass := True;
    else
        pass := false;
    end if;
    
    Class_Test_Result_File.Report_Case_status(pass);
    pass:=false;
    
    
    put_line("------------------ END -----------------");

    A_Predefined_Rough_Air_Intensity  :=  0.0;
    A_Wind_Shear_Turbulence_Intensity :=  0.0;
    A_Radar_Turbulence_Intensity      :=  0.0;
    An_Aircraft_Geometric_Altitude    :=  0.0;
    An_Integration_Constant           :=  0.0;
    A_True_Airspeed                   :=  0.0;
    An_Angle_of_Attack                :=  0.0;
    A_Side_Slip_Angle                 := 0.0;
    A_Tail_Bumper_Fuselage_Station    := 0.0;
    A_Wing_Span                       := 0.0;
    A_Simulated_Aircraft_Fuselage_Station_of_Current_Center_of_Gravity :=  0.0;
    A_Predefined_XNP    :=  0.0;
    A_Predefined_XINTQ :=  0.0;
    A_Predefined_XNQ    :=  0.0;
    A_Predefined_XINTR  := 0.0;
    A_Predefined_XNR    :=  0.0;



    A_Predefined_Turbulence_State_Vector := (0.0,0.0,0.0,0.0,0.0,
                                             0.0,0.0,0.0,0.0,0.0,0.0);
    Turbulence.Assign_Turbulence_State_Vector
        (A_Predefined_Turbulence_State_Vector,
         An_Instance                          );

    Turbulence.Assign_Attribiutes(A_Predefined_XNP  ,
                                 A_Predefined_XINTQ ,
                                 A_Predefined_XNQ   ,
                                 A_Predefined_XINTR ,
                                 A_Predefined_XNR   ,
                                 An_Instance     );

    Turbulence.Set_Turbulence_Matrix(An_Instance );

    Turbulence.Assign_Rough_Air_Intensity (A_Predefined_Rough_Air_Intensity ,
                                          An_Instance                      );

     put(Turbulence.Get_Rough_Air_Intensity (An_Instance ));

    --| A_Radar_Turbulence_Intensity = 0.0 for JPATS as JPATS does not have weather radar.
    Turbulence.Set_Total_Turbulence_Intensity
        (A_Wind_Shear_Turbulence_Intensity ,
         A_Radar_Turbulence_Intensity      ,
         An_Instance                       );

    put(Turbulence.Get_Total_Turbulence_Intensity (An_Instance) );

    Turbulence.Set_Turbulence_Scale_Length (An_Aircraft_Geometric_Altitude ,
                                           An_Instance                    );

    put(Turbulence.Get_Turbulence_Scale_Length (An_Instance ));

    Turbulence.Set_RMS_Intensity (An_Aircraft_Geometric_Altitude,
                                 An_Integration_Constant        ,
                                 An_Instance                    );

    put(Turbulence.Get_RMS_Intensity (An_Instance ).x); put(Turbulence.Get_RMS_Intensity (An_Instance ).y);

    Turbulence.Set_Mean_Forward_Speed (A_True_Airspeed ,
                                      An_Instance     );

    put(Turbulence.Get_Mean_Forward_Speed (An_Instance ));

    Turbulence.Assign_Turbulence_State_Vector
        (A_Predefined_Turbulence_State_Vector,
         An_Instance                         );


    Turbulence.Set_Turbulence_State_Vector
        (An_Integration_Constant ,
         An_Instance             );


    Turbulence.Set_Turbulence_Velocity_Body_Axis_to_Compute
        (An_Angle_of_Attack,
         A_Side_Slip_Angle ,
         An_Instance        );

    --| This method will be used to compute Turbulence velocity until it has completely resided, when
    --| an active Turbulence is switched OFF by the instructor.
    --Turbulence.Set_Turbulence_Velocity_Body_Axis_to_Decay(An_Instance );
   new_line;
    put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).x);put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).y);
     put(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).z);put_line ( "  Get_Turbulence_Velocity_Body_Axis " );

    Turbulence.Set_Turbulence_Angular_Rate_Body_Axis_to_Compute
        (A_Tail_Bumper_Fuselage_Station                                    ,
         A_Simulated_Aircraft_Fuselage_Station_of_Current_Center_of_Gravity,
         A_Wing_Span                                                       ,
         An_Integration_Constant                                            ,
         An_Instance                                                        );

   -- Turbulence.Set_Turbulence_Angular_Rate_Body_Axis_to_Decay(An_Instance );

    put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).roll); put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).pitch);
    put(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).yaw); put_line ( "  Get_Turbulence_Angular_Rate_Body_Axis " );


    if abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).x) >= 0.0 and
       abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).y) >= 0.0 and
       abs(Turbulence.Get_Turbulence_Velocity_Body_Axis(An_Instance).z) >= 0.0 and 
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).roll) >= 0.0 and
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).pitch)>= 0.0 and
       abs(Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(An_Instance ).yaw) >= 0.0 then
           pass := True;
    else
        pass := false;
    end if;
    
    Class_Test_Result_File.Report_Case_status(pass);
    pass:=false;
    
    
    
    
    
end EXECUTE_Turb;
