-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Steady_State_Wind;

with Angle_Types;
with Length_Types;
with Class_Test_Result_File;


procedure EXECUTE_Steady_State is
    An_Instance                : Steady_State_Wind.Instance;

    A_Wind_Velocity  : Length_Types.Feet_per_Sec;
    A_Wind_Direction : Angle_Types.Degrees;

    Pass        : Boolean := False;
    A_Tolerance : Float  := 0.000_1;

begin
    A_Wind_Velocity  := 63.642;
    A_Wind_Direction := 56.3/180.0*3.142;

    for i in 1..2 loop
    Steady_State_Wind.Set_Increment_in_Velocity_Earth_Axis
        (A_Wind_Velocity ,
         A_Wind_Direction ,
         An_Instance   );

    Steady_State_Wind.Set_Velocity_Earth_Axis (A_Wind_Velocity ,
                                          A_Wind_Direction ,
                                          An_Instance );

    put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).x);  put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).y);
    put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).z);put_line(" Get_Velocity_Earth_Axis ");
    put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).x);  put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).y);
    put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).z);put_line(" Get_Increment_in_Velocity_Earth_Axis ");
    end loop;

    Pass := abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).x - 0.0) <= A_Tolerance and
            abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).y - 0.0) <= A_Tolerance and
            abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).z - 0.0) <= A_Tolerance and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).x - 35.3047) <= A_Tolerance and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).y - 52.9517) <= A_Tolerance and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).z - 0.0) <= A_Tolerance;

    Class_Test_Result_File.Report_Case_Status(Pass);
    Pass := False;

    A_Wind_Velocity  := 1000.0;
    A_Wind_Direction := 1000.0;

    for i in 1..2 loop
    Steady_State_Wind.Set_Increment_in_Velocity_Earth_Axis
        (A_Wind_Velocity ,
         A_Wind_Direction ,
         An_Instance   );

    Steady_State_Wind.Set_Velocity_Earth_Axis (A_Wind_Velocity ,
                                          A_Wind_Direction ,
                                          An_Instance );

    put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).x);  put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).y);
    put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).z);put_line(" Get_Velocity_Earth_Axis ");
    put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).x);  put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).y);
    put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).z);put_line(" Get_Increment_in_Velocity_Earth_Axis ");
    end loop;

    Pass := abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).x) >= 0.0 and
            abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).y) >= 0.0 and
            abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).z) >= 0.0 and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).x) >= 0.0 and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).y) >= 0.0 and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).z) >= 0.0;

    Class_Test_Result_File.Report_Case_Status(Pass);
    Pass := False;

    A_Wind_Velocity  := 0.0;
    A_Wind_Direction := 0.0;

    for i in 1..2 loop
    Steady_State_Wind.Set_Increment_in_Velocity_Earth_Axis
        (A_Wind_Velocity ,
         A_Wind_Direction ,
         An_Instance   );

    Steady_State_Wind.Set_Velocity_Earth_Axis (A_Wind_Velocity ,
                                          A_Wind_Direction ,
                                          An_Instance );

    put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).x);  put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).y);
    put(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).z);put_line(" Get_Velocity_Earth_Axis ");
    put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).x);  put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).y);
    put(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).z);put_line(" Get_Increment_in_Velocity_Earth_Axis ");
    end loop;

    Pass := abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).x) >= 0.0 and
            abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).y) >= 0.0 and
            abs(Steady_State_Wind.Get_Increment_in_Velocity_Earth_Axis (An_Instance).z) >= 0.0 and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).x) >= 0.0 and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).y) >= 0.0 and
            abs(Steady_State_Wind.Get_Velocity_Earth_Axis (An_Instance).z) >= 0.0;

    Class_Test_Result_File.Report_Case_Status(Pass);
    Pass := False;





end EXECUTE_Steady_State;
