-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with NASA_Microburst;
with Length_Types;
with Coordinate_Types;

with NASA_Microburst_Model;
with Class_Test_Result_File;

procedure EXECUTE_NASA_MB is
    An_Instance                : NASA_Microburst.Instance;

    An_Aircraft_x_Distance_from_Runway_Touchdown :Length_Types.Feet;
    An_Aircraft_y_Distance_from_Runway_Touchdown :Length_Types.Feet;
    A_Microburst_x_Initial_Velocity              :Length_Types.Feet_per_Sec;
    A_Microburst_y_Initial_Velocity              :Length_Types.Feet_per_Sec;
    A_Microburst_x_Center                        :Coordinate_Types.Array_Type(1..5);
    A_Microburst_y_Center                        :Coordinate_Types.Array_Type(1..5);
    A_Microburst_Radius                          :Coordinate_Types.Array_Type(1..5);
    A_Microburst_Altitude                        :Coordinate_Types.Array_Type(1..5);
    A_Flow_Velocity                              :Coordinate_Types.Array_Type(1..5);
    A_x_Distrotion_Factor                        :Coordinate_Types.Array_Type(1..5);
    A_y_Distrotion_Factor                        :Coordinate_Types.Array_Type(1..5);
    A_Geometric_Altitude                         :Length_Types.Feet;
    A_Microburst_Model                           :Nasa_Microburst_Model.Instance := NASA_Microburst_Model.Model_Array(5);
    Pass        : Boolean := False;
    A_Tolerance : Float   := 0.000_1;


begin

    An_Aircraft_x_Distance_from_Runway_Touchdown := 325.0;
    An_Aircraft_y_Distance_from_Runway_Touchdown := 1754.0;
    A_Microburst_x_Initial_Velocity              := NASA_Microburst_Model.Model_Array(5).An_Initial_x_Wind_Velocity;
    A_Microburst_y_Initial_Velocity              := NASA_Microburst_Model.Model_Array(5).An_Initial_y_Wind_Velocity;
    A_Microburst_x_Center                        := NASA_Microburst_Model.Model_Array(5).A_x_Center;
    A_Microburst_y_Center                        := NASA_Microburst_Model.Model_Array(5).A_y_Center;
    A_Microburst_Radius                          := NASA_Microburst_Model.Model_Array(5).A_Radius;
    A_Microburst_Altitude                        := NASA_Microburst_Model.Model_Array(5).An_Altitude;
    A_Flow_Velocity                              := NASA_Microburst_Model.Model_Array(5).A_Flow_Velocity;
    A_x_Distrotion_Factor                        := NASA_Microburst_Model.Model_Array(5).A_x_Distortion_Factor;
    A_y_Distrotion_Factor                        := NASA_Microburst_Model.Model_Array(5).A_y_Distortion_Factor;
    A_Geometric_Altitude                         := 1500.0;


    NASA_Microburst.Set_Local_Velocity
     (An_Aircraft_x_Distance_from_Runway_Touchdown,
      An_Aircraft_y_Distance_from_Runway_Touchdown,
      A_Microburst_Model                          ,
      A_Geometric_Altitude                        ,
      An_Instance                                 );

     Pass := abs(NASA_Microburst.Get_Local_Velocity(An_Instance).x - 0.97951) <= A_Tolerance and
             abs(NASA_Microburst.Get_Local_Velocity(An_Instance).y - (-6.56349)) <= A_Tolerance and
             abs(NASA_Microburst.Get_Local_Velocity(An_Instance).z - 0.0) <= A_Tolerance;

     Class_Test_Result_File.Report_Case_Status(Pass);
     Pass := False;

Put(NASA_Microburst.Get_Local_Velocity(An_Instance).x);Put(NASA_Microburst.Get_Local_Velocity(An_Instance).y);
Put(NASA_Microburst.Get_Local_Velocity(An_Instance).z);       Put_Line(" Local_Velocity ");


put_line("--------------------------- CONSTRAINT -------------------");

    An_Aircraft_x_Distance_from_Runway_Touchdown := 100000.0;
    An_Aircraft_y_Distance_from_Runway_Touchdown := 100000.0;
    A_Microburst_x_Initial_Velocity              := NASA_Microburst_Model.Model_Array(5).An_Initial_x_Wind_Velocity;
    A_Microburst_y_Initial_Velocity              := NASA_Microburst_Model.Model_Array(5).An_Initial_y_Wind_Velocity;
    A_Microburst_x_Center                        := NASA_Microburst_Model.Model_Array(5).A_x_Center;
    A_Microburst_y_Center                        := NASA_Microburst_Model.Model_Array(5).A_y_Center;
    A_Microburst_Radius                          := NASA_Microburst_Model.Model_Array(5).A_Radius;
    A_Microburst_Altitude                        := NASA_Microburst_Model.Model_Array(5).An_Altitude;
    A_Flow_Velocity                              := NASA_Microburst_Model.Model_Array(5).A_Flow_Velocity;
    A_x_Distrotion_Factor                        := NASA_Microburst_Model.Model_Array(5).A_x_Distortion_Factor;
    A_y_Distrotion_Factor                        := NASA_Microburst_Model.Model_Array(5).A_y_Distortion_Factor;
    A_Geometric_Altitude                         := 100000.0;

    NASA_Microburst.Set_Local_Velocity
     (An_Aircraft_x_Distance_from_Runway_Touchdown,
      An_Aircraft_y_Distance_from_Runway_Touchdown,
      A_Microburst_Model                          ,
      A_Geometric_Altitude                        ,
      An_Instance                                 );

     Pass := abs(NASA_Microburst.Get_Local_Velocity(An_Instance).x) >= 0.0 and
             abs(NASA_Microburst.Get_Local_Velocity(An_Instance).y) >= 0.0 and
             abs(NASA_Microburst.Get_Local_Velocity(An_Instance).z) >= 0.0;

     Class_Test_Result_File.Report_Case_Status(Pass);
     Pass := False;

Put(NASA_Microburst.Get_Local_Velocity(An_Instance).x);Put(NASA_Microburst.Get_Local_Velocity(An_Instance).y);
Put(NASA_Microburst.Get_Local_Velocity(An_Instance).z);       Put_Line(" Local_Velocity ");

put_line("--------------------------- END -------------------");

    An_Aircraft_x_Distance_from_Runway_Touchdown := 0.0;
    An_Aircraft_y_Distance_from_Runway_Touchdown := 0.0;
    A_Microburst_x_Initial_Velocity              := NASA_Microburst_Model.Model_Array(5).An_Initial_x_Wind_Velocity;
    A_Microburst_y_Initial_Velocity              := NASA_Microburst_Model.Model_Array(5).An_Initial_y_Wind_Velocity;
    A_Microburst_x_Center                        := NASA_Microburst_Model.Model_Array(5).A_x_Center;
    A_Microburst_y_Center                        := NASA_Microburst_Model.Model_Array(5).A_y_Center;
    A_Microburst_Radius                          := NASA_Microburst_Model.Model_Array(5).A_Radius;
    A_Microburst_Altitude                        := NASA_Microburst_Model.Model_Array(5).An_Altitude;
    A_Flow_Velocity                              := NASA_Microburst_Model.Model_Array(5).A_Flow_Velocity;
    A_x_Distrotion_Factor                        := NASA_Microburst_Model.Model_Array(5).A_x_Distortion_Factor;
    A_y_Distrotion_Factor                        := NASA_Microburst_Model.Model_Array(5).A_y_Distortion_Factor;
    A_Geometric_Altitude                         := 0.0;

    NASA_Microburst.Set_Local_Velocity
     (An_Aircraft_x_Distance_from_Runway_Touchdown,
      An_Aircraft_y_Distance_from_Runway_Touchdown,
      A_Microburst_Model                          ,
      A_Geometric_Altitude                        ,
      An_Instance                                 );

     Pass := abs(NASA_Microburst.Get_Local_Velocity(An_Instance).x) >= 0.0 and
             abs(NASA_Microburst.Get_Local_Velocity(An_Instance).y) >= 0.0 and
             abs(NASA_Microburst.Get_Local_Velocity(An_Instance).z) >= 0.0;

     Class_Test_Result_File.Report_Case_Status(Pass);
     Pass := False;

Put(NASA_Microburst.Get_Local_Velocity(An_Instance).x);Put(NASA_Microburst.Get_Local_Velocity(An_Instance).y);
Put(NASA_Microburst.Get_Local_Velocity(An_Instance).z);       Put_Line(" Local_Velocity ");

end EXECUTE_NASA_MB;
