-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with JPATS_Atmosphere;
with JPATS_Atmosphere.Microburst_Controller;
with JPATS_Atmosphere.Container;


procedure JPATS_Atmosphere.Container.EXECUTE_Microburst_Controller is

    An_Integration_Constant : Float := 1.0/60.0;

begin

    --| The domain classes under the microburst controller in the atmosphere
    --| body category are initialized by executing the following procedure.
    --| Predefined value is assigned to the attributes.
    JPATS_Atmosphere.Microburst_Controller.Initialize;

    --| The lookup tables required by the domain classes under the microburst
    --| controller in the atmosphere body category are parameterized by
    --| executing the following procedure.
    JPATS_Atmosphere.Microburst_Controller.Initialize_Tables;

    for i in 1..4 loop

        --| The next pass values of the attributes in the domain classes under
        --| the microburst controller in the atmosphere body category is computed
        --| during simulation.

        Container.This_IOS_Interface.The_NASA_Microburst_Activate := True;
        JPATS_Atmosphere.Microburst_Controller.Update (An_Integration_Constant);

        put (JPATS_Atmosphere.Get_Microburst_Radius_for_Display);

    end loop;
end JPATS_Atmosphere.Container.EXECUTE_Microburst_Controller;
