-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Microburst;
with Length_Types;
with Coordinate_Types;
with Normalized_Types;
with Class_Test_Result_File;


procedure EXECUTE_Microburst is
    An_Instance                : Microburst.Instance;
    A_Field_Pressure_Altitude  : Length_Types.Feet :=  6998.0;
    A_Field_Geometric_Altitude : Length_Types.Feet :=  7000.0;
    A_Geometric_Altitude       : Length_Types.Feet := 17000.0;

A_Predefined_Microburst_Intensity : float := 50.0;
A_Predefined_Microburst_Trigger : boolean:= TRUE;
A_Predefined_Microburst_Magnitude : float := 0.0;
A_Predefined_Aircraft_x_Distance_from_Touchdown : float := 0.0;
A_Predefined_Aircraft_y_Distance_from_Touchdown : float := 0.0;
A_Predefined_Microburst_Lagged_Velocity : coordinate_types.cartesian := (0.0,0.0,0.0);
A_Predefined_Microburst_Velocity_Earth_Axis : coordinate_types.cartesian := (0.0,0.0,0.0);
A_Predefined_Microburst_Delta_Temperature : float := 0.0;
A_Predefined_Microburst_Delta_Pressure : float := 0.0;
A_Predefined_Microburst_Display_Radius : float := 0.0;
A_Predefined_Roll_Moment_due_to_Microburst : float := 0.0;
A_Predefined_Microburst_Display_Top : float := 0.0;

An_Aircraft_Latitude        : long_float := 45.0;
An_Aircraft_Longitude       : long_float := 45.0;
A_Runway_Threshold_Latitude : long_float := 45.000_001;
A_Runway_Threshold_Longitude: long_float := 45.000_004;
A_Runway_Threshold_Heading  : float :=  Ada.Numerics.Pi/2.8;
A_Local_Microburst_Velocity : coordinate_types.cartesian := (8.47,1.5,0.2);
A_Microburst_Temperature_Change : float := 0.1678;

Pass : Boolean := False;
A_Tolerance : Float := 0.000_1;

begin

    put(cos(A_Runway_Threshold_Heading));
    put(sin(A_Runway_Threshold_Heading)); put_line(" cos and sin ");
Microburst.Assign_Intensity(A_Predefined_Microburst_Intensity,
                            An_Instance );
Microburst.Assign_Trigger(A_Predefined_Microburst_Trigger,
                          An_Instance           );
Microburst.Assign_Magnitude(A_Predefined_Microburst_Magnitude,
                            An_Instance );
Microburst.Assign_Aircraft_Distance_from_Runway_Touchdown
        (A_Predefined_Aircraft_x_Distance_from_Touchdown,
         A_Predefined_Aircraft_y_Distance_from_Touchdown,
         An_Instance               );
Microburst.Assign_Lagged_Velocity(A_Predefined_Microburst_Lagged_Velocity,
                                  An_Instance       );
Microburst.Assign_Velocity_Earth_Axis(A_Predefined_Microburst_Velocity_Earth_Axis,
                                      An_Instance           );
Microburst.Assign_Delta_Temperature(A_Predefined_Microburst_Delta_Temperature,
                                    An_Instance         );
Microburst.Assign_Delta_Pressure(A_Predefined_Microburst_Delta_Pressure,
                                 An_Instance      );
Microburst.Assign_Radius_for_Display(A_Predefined_Microburst_Display_Radius,
                                     An_Instance      );
Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_Roll_Moment_due_to_Microburst,
         An_Instance          );
Microburst.Assign_Top_for_Display(A_Predefined_Microburst_Display_Top,
                                  An_Instance   );


Put(Microburst.Get_Intensity (An_Instance));         Put_Line(" Intensity ");
--Put(Microburst.Get_Tigger (An_Instance)) ;            Put_Line(" Tigger ");

Microburst.Set_Magnitude(An_Instance);
--Put(Microburst.Get_Magnitude (An_Instance));        Put_Line(" Magnitude ");

Microburst.Set_Aircraft_Distance_from_Runway_Touchdown
        (An_Aircraft_Latitude        ,
         An_Aircraft_Longitude       ,
         A_Runway_Threshold_Latitude  ,
         A_Runway_Threshold_Longitude,
         A_Runway_Threshold_Heading ,
         An_Instance           );
Put(Microburst.Get_Aircraft_x_Distance_from_Runway_Touchdown (An_Instance)); Put_Line(" Aircraft_x_Distance_from_Runway_Touchdown ");
Put(Microburst.Get_Aircraft_y_Distance_from_Runway_Touchdown (An_Instance)); Put_Line(" Aircraft_y_Distance_from_Runway_Touchdown ");

Microburst.Set_Velocity_Earth_Axis
        (A_Runway_Threshold_Heading ,
         A_Local_Microburst_Velocity ,
         An_Instance           );

Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).x);Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).y);
Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).z);   Put_Line(" Velocity_Earth_Axis ");
Put(Microburst.Get_Lagged_Wind_Velocity (An_Instance).x);  Put(Microburst.Get_Lagged_Wind_Velocity(An_Instance).y);
Put(Microburst.Get_Lagged_Wind_Velocity (An_Instance).z);  Put_Line(" Lagged_Wind_Velocity ");

Microburst.Set_Delta_Temperature (A_Microburst_Temperature_Change,
                                     An_Instance           );

pass:=abs(Microburst.Get_Aircraft_x_Distance_from_Runway_Touchdown (An_Instance) - 0.72823878) <= A_Tolerance and
      abs(Microburst.Get_Aircraft_y_Distance_from_Runway_Touchdown (An_Instance) - 0.05393575) <= A_Tolerance and
      abs(Microburst.Get_Velocity_Earth_Axis(An_Instance).x - (-0.23354193)) <= A_Tolerance and
      abs(Microburst.Get_Velocity_Earth_Axis(An_Instance).y - 0.66742652) <= A_Tolerance and
      abs(Microburst.Get_Lagged_Wind_Velocity(An_Instance).x - 0.5) <= A_Tolerance and
      abs(Microburst.Get_Lagged_Wind_Velocity(An_Instance).y - 0.5) <= A_Tolerance and
      abs(Microburst.Get_Delta_Temperature(An_Instance) - 0.01678) <= A_Tolerance;

Put(Microburst.Get_Delta_Temperature (An_Instance));    Put_Line(" Delta_Temperature ");
Put(Microburst.Get_Delta_Pressure (An_Instance));       Put_Line(" Delta_Pressure ");
Put(Microburst.Get_Roll_Moment_due_to_Microburst(An_Instance)); Put_Line(" Roll_Moment_due_to_Microburst ");
Put(Microburst.Get_Radius_for_Display (An_Instance));    Put_Line(" Radius_for_Display  ");
Put(Microburst.Get_Top_for_Display (An_Instance));       Put_Line(" Top_for_Display ");

Class_Test_Result_File.Report_Case_Status(Pass);
Pass := false;

put_line(" ----------------- CONSTRAINT ----------------");
    A_Field_Pressure_Altitude   := 100000.0;
    A_Field_Geometric_Altitude  := 100000.0;
    A_Geometric_Altitude        := 100000.0;

A_Predefined_Microburst_Intensity  := 1000.0;
A_Predefined_Microburst_Trigger := TRUE;
A_Predefined_Microburst_Magnitude  := 1000.0;
A_Predefined_Aircraft_x_Distance_from_Touchdown  :=  1000.0;
A_Predefined_Aircraft_y_Distance_from_Touchdown  := 1000.0;
A_Predefined_Microburst_Lagged_Velocity  := ( 1000.0, 1000.0, 1000.0);
A_Predefined_Microburst_Velocity_Earth_Axis  := ( 1000.0,1000.0,1000.0);
A_Predefined_Microburst_Delta_Temperature  := 1000.0;
A_Predefined_Microburst_Delta_Pressure  := 1000.0;
A_Predefined_Microburst_Display_Radius  := 1000.0;
A_Predefined_Roll_Moment_due_to_Microburst  := 1000.0;
A_Predefined_Microburst_Display_Top  := 1000.0;

A_Runway_Threshold_Heading   :=  Ada.Numerics.Pi/1000.0;
A_Local_Microburst_Velocity  := (1000.0,1000.0,1000.0);
A_Microburst_Temperature_Change  := 1000.0;
Microburst.Assign_Intensity(A_Predefined_Microburst_Intensity,
                            An_Instance );
Microburst.Assign_Trigger(A_Predefined_Microburst_Trigger,
                          An_Instance           );
Microburst.Assign_Magnitude(A_Predefined_Microburst_Magnitude,
                            An_Instance );
Microburst.Assign_Aircraft_Distance_from_Runway_Touchdown
        (A_Predefined_Aircraft_x_Distance_from_Touchdown,
         A_Predefined_Aircraft_y_Distance_from_Touchdown,
         An_Instance               );
Microburst.Assign_Lagged_Velocity(A_Predefined_Microburst_Lagged_Velocity,
                                  An_Instance       );
Microburst.Assign_Velocity_Earth_Axis(A_Predefined_Microburst_Velocity_Earth_Axis,
                                      An_Instance           );
Microburst.Assign_Delta_Temperature(A_Predefined_Microburst_Delta_Temperature,
                                    An_Instance         );
Microburst.Assign_Delta_Pressure(A_Predefined_Microburst_Delta_Pressure,
                                 An_Instance      );
Microburst.Assign_Radius_for_Display(A_Predefined_Microburst_Display_Radius,
                                     An_Instance      );
Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_Roll_Moment_due_to_Microburst,
         An_Instance          );
Microburst.Assign_Top_for_Display(A_Predefined_Microburst_Display_Top,
                                  An_Instance   );


Microburst.Set_Magnitude(An_Instance);
--Put(Microburst.Get_Magnitude (An_Instance));        Put_Line(" Magnitude ");

Microburst.Set_Aircraft_Distance_from_Runway_Touchdown
        (An_Aircraft_Latitude        ,
         An_Aircraft_Longitude       ,
         A_Runway_Threshold_Latitude  ,
         A_Runway_Threshold_Longitude,
         A_Runway_Threshold_Heading ,
         An_Instance           );
Put(Microburst.Get_Aircraft_x_Distance_from_Runway_Touchdown (An_Instance)); Put_Line(" Aircraft_x_Distance_from_Runway_Touchdown ");
Put(Microburst.Get_Aircraft_y_Distance_from_Runway_Touchdown (An_Instance)); Put_Line(" Aircraft_y_Distance_from_Runway_Touchdown ");

Microburst.Set_Velocity_Earth_Axis
        (A_Runway_Threshold_Heading ,
         A_Local_Microburst_Velocity ,
         An_Instance           );

Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).x);Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).y);
Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).z);   Put_Line(" Velocity_Earth_Axis ");
Put(Microburst.Get_Lagged_Wind_Velocity (An_Instance).x);  Put(Microburst.Get_Lagged_Wind_Velocity(An_Instance).y);
Put(Microburst.Get_Lagged_Wind_Velocity (An_Instance).z);  Put_Line(" Lagged_Wind_Velocity ");

Microburst.Set_Delta_Temperature (A_Microburst_Temperature_Change,
                                     An_Instance           );

pass:=abs(Microburst.Get_Aircraft_x_Distance_from_Runway_Touchdown (An_Instance)) >= 0.0 and
      abs(Microburst.Get_Aircraft_y_Distance_from_Runway_Touchdown (An_Instance)) >= 0.0 and
      abs(Microburst.Get_Velocity_Earth_Axis(An_Instance).x ) >= 0.0 and
      abs(Microburst.Get_Velocity_Earth_Axis(An_Instance).y ) >= 0.0 and
      abs(Microburst.Get_Lagged_Wind_Velocity(An_Instance).x) >= 0.0 and
      abs(Microburst.Get_Lagged_Wind_Velocity(An_Instance).y) >= 0.0 and
      abs(Microburst.Get_Delta_Temperature(An_Instance)) >= 0.0;

Put(Microburst.Get_Delta_Temperature (An_Instance));    Put_Line(" Delta_Temperature ");
Put(Microburst.Get_Delta_Pressure (An_Instance));       Put_Line(" Delta_Pressure ");
Put(Microburst.Get_Roll_Moment_due_to_Microburst(An_Instance)); Put_Line(" Roll_Moment_due_to_Microburst ");
Put(Microburst.Get_Radius_for_Display (An_Instance));    Put_Line(" Radius_for_Display  ");
Put(Microburst.Get_Top_for_Display (An_Instance));       Put_Line(" Top_for_Display ");

Class_Test_Result_File.Report_Case_Status(Pass);
Pass := false;

put_line(" ----------------- END ----------------");
    A_Field_Pressure_Altitude   := 0.0;
    A_Field_Geometric_Altitude  := 0.0;
    A_Geometric_Altitude        := 0.0;

A_Predefined_Microburst_Intensity  := 0.0;
A_Predefined_Microburst_Trigger := TRUE;
A_Predefined_Microburst_Magnitude  := 0.0;
A_Predefined_Aircraft_x_Distance_from_Touchdown  :=  0.0;
A_Predefined_Aircraft_y_Distance_from_Touchdown  := 0.0;
A_Predefined_Microburst_Lagged_Velocity  := ( 0.0, 0.0, 0.0);
A_Predefined_Microburst_Velocity_Earth_Axis  := ( 0.0,0.0,0.0);
A_Predefined_Microburst_Delta_Temperature  := 0.0;
A_Predefined_Microburst_Delta_Pressure  := 0.0;
A_Predefined_Microburst_Display_Radius  := 0.0;
A_Predefined_Roll_Moment_due_to_Microburst  := 0.0;
A_Predefined_Microburst_Display_Top  := 0.0;

An_Aircraft_Latitude         := 0.0;
An_Aircraft_Longitude        := 0.0;
A_Runway_Threshold_Latitude  := 0.0;
A_Runway_Threshold_Longitude := 0.0;
A_Runway_Threshold_Heading   :=  0.0;
A_Local_Microburst_Velocity  := (0.0,0.0,0.0);
A_Microburst_Temperature_Change  := 0.0;
Microburst.Assign_Intensity(A_Predefined_Microburst_Intensity,
                            An_Instance );
Microburst.Assign_Trigger(A_Predefined_Microburst_Trigger,
                          An_Instance           );
Microburst.Assign_Magnitude(A_Predefined_Microburst_Magnitude,
                            An_Instance );
Microburst.Assign_Aircraft_Distance_from_Runway_Touchdown
        (A_Predefined_Aircraft_x_Distance_from_Touchdown,
         A_Predefined_Aircraft_y_Distance_from_Touchdown,
         An_Instance               );
Microburst.Assign_Lagged_Velocity(A_Predefined_Microburst_Lagged_Velocity,
                                  An_Instance       );
Microburst.Assign_Velocity_Earth_Axis(A_Predefined_Microburst_Velocity_Earth_Axis,
                                      An_Instance           );
Microburst.Assign_Delta_Temperature(A_Predefined_Microburst_Delta_Temperature,
                                    An_Instance         );
Microburst.Assign_Delta_Pressure(A_Predefined_Microburst_Delta_Pressure,
                                 An_Instance      );
Microburst.Assign_Radius_for_Display(A_Predefined_Microburst_Display_Radius,
                                     An_Instance      );
Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_Roll_Moment_due_to_Microburst,
         An_Instance          );
Microburst.Assign_Top_for_Display(A_Predefined_Microburst_Display_Top,
                                  An_Instance   );


Microburst.Set_Magnitude(An_Instance);
--Put(Microburst.Get_Magnitude (An_Instance));        Put_Line(" Magnitude ");

Microburst.Set_Aircraft_Distance_from_Runway_Touchdown
        (An_Aircraft_Latitude        ,
         An_Aircraft_Longitude       ,
         A_Runway_Threshold_Latitude  ,
         A_Runway_Threshold_Longitude,
         A_Runway_Threshold_Heading ,
         An_Instance           );
Put(Microburst.Get_Aircraft_x_Distance_from_Runway_Touchdown (An_Instance)); Put_Line(" Aircraft_x_Distance_from_Runway_Touchdown ");
Put(Microburst.Get_Aircraft_y_Distance_from_Runway_Touchdown (An_Instance)); Put_Line(" Aircraft_y_Distance_from_Runway_Touchdown ");

Microburst.Set_Velocity_Earth_Axis
        (A_Runway_Threshold_Heading ,
         A_Local_Microburst_Velocity ,
         An_Instance           );

Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).x);Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).y);
Put(Microburst.Get_Velocity_Earth_Axis (An_Instance).z);   Put_Line(" Velocity_Earth_Axis ");
Put(Microburst.Get_Lagged_Wind_Velocity (An_Instance).x);  Put(Microburst.Get_Lagged_Wind_Velocity(An_Instance).y);
Put(Microburst.Get_Lagged_Wind_Velocity (An_Instance).z);  Put_Line(" Lagged_Wind_Velocity ");

Microburst.Set_Delta_Temperature (A_Microburst_Temperature_Change,
                                     An_Instance           );

pass:=abs(Microburst.Get_Aircraft_x_Distance_from_Runway_Touchdown (An_Instance)) >= 0.0 and
      abs(Microburst.Get_Aircraft_y_Distance_from_Runway_Touchdown (An_Instance)) >= 0.0 and
      abs(Microburst.Get_Velocity_Earth_Axis(An_Instance).x ) >= 0.0 and
      abs(Microburst.Get_Velocity_Earth_Axis(An_Instance).y ) >= 0.0 and
      abs(Microburst.Get_Lagged_Wind_Velocity(An_Instance).x) >= 0.0 and
      abs(Microburst.Get_Lagged_Wind_Velocity(An_Instance).y) >= 0.0 and
      abs(Microburst.Get_Delta_Temperature(An_Instance)) >= 0.0;

Put(Microburst.Get_Delta_Temperature (An_Instance));    Put_Line(" Delta_Temperature ");
Put(Microburst.Get_Delta_Pressure (An_Instance));       Put_Line(" Delta_Pressure ");
Put(Microburst.Get_Roll_Moment_due_to_Microburst(An_Instance)); Put_Line(" Roll_Moment_due_to_Microburst ");
Put(Microburst.Get_Radius_for_Display (An_Instance));    Put_Line(" Radius_for_Display  ");
Put(Microburst.Get_Top_for_Display (An_Instance));       Put_Line(" Top_for_Display ");

Class_Test_Result_File.Report_Case_Status(Pass);
Pass := false;






end EXECUTE_Microburst;
