-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Free_Air;
with Length_Types;
with Normalized_Types;
with Temperature_Types;
with Class_Test_Result_File;


procedure EXECUTE_Free_Air is
    An_Instance                : Free_Air.Instance;
          A_Field_Pressure_Altitude  : Length_Types.Feet :=  6998.0;
    A_Field_Geometric_Altitude : Length_Types.Feet :=  7000.0;
    A_Geometric_Altitude       : Length_Types.Feet := 17000.0;
    A_Standard_Day_Ambient_Temperature_at_Altitude : Temperature_Types.Rankine := 458.11;
    A_Sealevel_Temperature     : Temperature_Types.Rankine := 518.688;
    A_Lapse_Rate : Temperature_Types.Rankine;
    A_Microburst_Temperature_Change  : Temperature_Types.Rankine := 0.0;
    A_Microburst_Pressure_Change     :float := 0.0;

    A_Predefined_Sealevel_Pressure_in_Inches_of_Hg  :float := 29.92;
    A_Predefined_Pressure_Altitude  : float := 16986.0;
    A_Predefined_Atmosphere_Ratio   : float :=1.0;
    A_Predefined_Sealevel_Temperature  :float := 518.688;
    A_Predefined_Lapse_Rate  :float := -0.003_566_16;
    A_Predefined_Ambient_Temperature  :float := 408.11;
    A_Predefined_Ambient_Temperature_Ratio  :float := 1.0;
    A_Predefined_Ambient_Pressure:float := 101325.0;
    A_Predefined_Ambient_Pressure_Ratio:float := 1.0;
    A_Predefined_Air_Density_at_Altitude:float := 1.2250;

    Pass : Boolean := False;
    A_Tolerance : Float := 0.000_1;

begin

    Free_Air.Assign_Sealevel_Pressure
        (A_Predefined_Sealevel_Pressure_in_Inches_of_Hg,
         An_Instance                                   );
    Free_Air.Assign_Pressure_Altitude(A_Predefined_Pressure_Altitude,
                                       An_Instance);
    Free_Air.Assign_Atmosphere_Ratio

        (A_Predefined_Atmosphere_Ratio,
         An_Instance);
    Free_Air.Assign_Sealevel_Temperature(A_Predefined_Sealevel_Temperature,
                                          An_Instance);
    Free_Air.Assign_Lapse_Rate(A_Predefined_Lapse_Rate,
                                An_Instance);
    Free_Air.Assign_Ambient_Temperature(A_Predefined_Ambient_Temperature,
                                         An_Instance );
    Free_Air.Assign_Ambient_Temperature_Ratio
        (A_Predefined_Ambient_Temperature_Ratio,
         An_Instance);
    Free_Air.Assign_Ambient_Pressure(A_Predefined_Ambient_Pressure,
                                      An_Instance);
   -- Free_Air.Assign_Ambient_Pressure_Ratio(A_Predefined_Ambient_Pressure_Ratio,

   --                                         An_Instance );
   -- Free_Air.Assign_Air_Density_at_Altitude
   --     (A_Predefined_Air_Density_at_Altitude,
   --      An_Instance);

        Free_Air.Set_Sealevel_Pressure_based_on_Altitude (A_Field_Pressure_Altitude ,
                                        A_Field_Geometric_Altitude,
                                        An_Instance               );
        Put_Line(" Sealevel Pressure "); put( Free_Air.Get_Sealevel_Pressure (An_Instance)); Put_Line(" ");

        Free_Air.Set_Pressure_Altitude
            (A_Geometric_Altitude                          ,
             A_Standard_Day_Ambient_Temperature_at_Altitude,
             An_Instance                                   );
        Put_Line(" Pressure Altitude "); put( Free_Air.Get_Pressure_Altitude (An_Instance)); Put_Line(" ");

        Free_Air.Set_Atmosphere_Ratio(An_Instance);
        Put_Line(" Atmosphere_Ratio "); put( Free_Air.Get_Atmosphere_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Sealevel_Temperature (An_Instance);
        Put_Line(" Sealevel_Temperature "); put( Free_Air.Get_Sealevel_Temperature (An_Instance)); Put_Line(" ");

        Free_Air.Set_Lapse_Rate (An_Instance);
        Put_Line(" Lapse_Rate "); put( Free_Air.Get_Lapse_Rate (An_Instance)); Put_Line(" ");

        A_Lapse_Rate:=Free_Air.Get_Lapse_Rate(An_Instance);
        Free_Air.Set_Ambient_Temperature
            (A_Lapse_Rate                   ,
             A_Microburst_Temperature_Change,
             An_Instance                    );
        Put_Line(" Ambient_Temperature "); put( Free_Air.Get_Ambient_Temperature (An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Temperature_Ratio
            (A_Sealevel_Temperature,
                An_Instance);
       Put_Line(" Ambient_Temperature_Ratio "); put( Free_Air.Get_Ambient_Temperature_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Pressure(A_Microburst_Pressure_Change,
                                      An_Instance);
        Put_Line(" Ambient_Pressure "); put( Free_Air.Get_Ambient_Pressure(An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Pressure_Ratio(An_Instance);
        Put_Line(" Ambient_Pressure_Ratio "); put( Free_Air.Get_Ambient_Pressure_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Air_Density_at_Altitude (An_Instance);
        Put_Line(" Air_Density_at_Altitude "); put( Free_Air.Get_Air_Density_at_Altitude (An_Instance)); Put_Line(" ");

        Pass:= abs(Free_Air.Get_Sealevel_Pressure (An_Instance) - 29.92215077) <= A_Tolerance and
               abs(Free_Air.Get_Pressure_Altitude (An_Instance) - 19082.7718) <= A_Tolerance and
               abs(Free_Air.get_Atmosphere_Ratio (An_Instance) - 0.868779926) <= A_Tolerance and
               abs(Free_Air.Get_Sealevel_Temperature (An_Instance) - 476.16221748) <= A_Tolerance and
               abs(Free_Air.get_Lapse_Rate (An_Instance) - (-0.00356616)) <= A_Tolerance and
               abs(Free_Air.Get_Ambient_Temperature (An_Instance) - 408.11) <= A_Tolerance and
               abs(Free_Air.Get_Ambient_Temperature_Ratio (An_Instance) - 0.78681211) <= A_Tolerance and
               abs(Free_Air.Get_Ambient_Pressure_Ratio (An_Instance) - 0.47747924) <= A_Tolerance and
               abs(Free_Air.Get_Air_Density_at_Altitude (An_Instance) - 0.00144271) <= A_Tolerance;

        Class_Test_Result_File.Report_Case_Status(Pass);
        Pass := False;

        put_line("------------------ CONSTRAINT ------------------------");


    A_Field_Pressure_Altitude  :=  100000.0;
    A_Field_Geometric_Altitude := 100000.0;
    A_Geometric_Altitude       := 100000.0;
    A_Standard_Day_Ambient_Temperature_at_Altitude := 1000.0;
    A_Sealevel_Temperature     :=  1000.0;
    A_Microburst_Temperature_Change  := 1000.0;
    A_Microburst_Pressure_Change     :=  1000.0;

    A_Predefined_Sealevel_Pressure_in_Inches_of_Hg :=  1000.0;
    A_Predefined_Pressure_Altitude  :=  100000.0;
    A_Predefined_Atmosphere_Ratio   :=10.0;
    A_Predefined_Sealevel_Temperature  :=  1000.0;
    A_Predefined_Lapse_Rate  := 10.0;
    A_Predefined_Ambient_Temperature  := 1000.0;
    A_Predefined_Ambient_Temperature_Ratio  := 10.0;
    A_Predefined_Ambient_Pressure :=  100000.0;
    A_Predefined_Ambient_Pressure_Ratio := 10.0;
    A_Predefined_Air_Density_at_Altitude := 10.0;

    Free_Air.Assign_Sealevel_Pressure
        (A_Predefined_Sealevel_Pressure_in_Inches_of_Hg,
         An_Instance                                   );
    Free_Air.Assign_Pressure_Altitude(A_Predefined_Pressure_Altitude,
                                       An_Instance);
    Free_Air.Assign_Atmosphere_Ratio
        (A_Predefined_Atmosphere_Ratio,
         An_Instance);
    Free_Air.Assign_Sealevel_Temperature(A_Predefined_Sealevel_Temperature,
                                          An_Instance);
    Free_Air.Assign_Lapse_Rate(A_Predefined_Lapse_Rate,
                                An_Instance);
    Free_Air.Assign_Ambient_Temperature(A_Predefined_Ambient_Temperature,
                                         An_Instance );
    Free_Air.Assign_Ambient_Temperature_Ratio
        (A_Predefined_Ambient_Temperature_Ratio,
         An_Instance);
    Free_Air.Assign_Ambient_Pressure(A_Predefined_Ambient_Pressure,
                                      An_Instance);
   -- Free_Air.Assign_Ambient_Pressure_Ratio(A_Predefined_Ambient_Pressure_Ratio,
   --                                         An_Instance );
   -- Free_Air.Assign_Air_Density_at_Altitude
   --     (A_Predefined_Air_Density_at_Altitude,
   --      An_Instance);

        Free_Air.Set_Sealevel_Pressure_based_on_Altitude (A_Field_Pressure_Altitude ,
                                        A_Field_Geometric_Altitude,
                                        An_Instance               );
        Put_Line(" Sealevel Pressure "); put( Free_Air.Get_Sealevel_Pressure (An_Instance)); Put_Line(" ");

        Free_Air.Set_Pressure_Altitude
            (A_Geometric_Altitude                          ,
             A_Standard_Day_Ambient_Temperature_at_Altitude,
             An_Instance                                   );
        Put_Line(" Pressure Altitude "); put( Free_Air.Get_Pressure_Altitude (An_Instance)); Put_Line(" ");

        Free_Air.Set_Atmosphere_Ratio(An_Instance);
        Put_Line(" Atmosphere_Ratio "); put( Free_Air.Get_Atmosphere_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Sealevel_Temperature (An_Instance);
        Put_Line(" Sealevel_Temperature "); put( Free_Air.Get_Sealevel_Temperature (An_Instance)); Put_Line(" ");

        Free_Air.Set_Lapse_Rate (An_Instance);
        Put_Line(" Lapse_Rate "); put( Free_Air.Get_Lapse_Rate (An_Instance)); Put_Line(" ");

        A_Lapse_Rate:=Free_Air.Get_Lapse_Rate(An_Instance);
        Free_Air.Set_Ambient_Temperature
            (A_Lapse_Rate                   ,
             A_Microburst_Temperature_Change,
             An_Instance                    );
        Put_Line(" Ambient_Temperature "); put( Free_Air.Get_Ambient_Temperature (An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Temperature_Ratio
            (A_Sealevel_Temperature,
                An_Instance);
       Put_Line(" Ambient_Temperature_Ratio "); put( Free_Air.Get_Ambient_Temperature_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Pressure(A_Microburst_Pressure_Change,
                                      An_Instance);
        Put_Line(" Ambient_Pressure "); put( Free_Air.Get_Ambient_Pressure(An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Pressure_Ratio(An_Instance);
        Put_Line(" Ambient_Pressure_Ratio "); put( Free_Air.Get_Ambient_Pressure_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Air_Density_at_Altitude (An_Instance);
        Put_Line(" Air_Density_at_Altitude "); put( Free_Air.Get_Air_Density_at_Altitude (An_Instance)); Put_Line(" ");

        Pass:= abs(Free_Air.Get_Sealevel_Pressure (An_Instance)) >= 0.0 and
               abs(Free_Air.Get_Pressure_Altitude (An_Instance)) >= 0.0 and
               abs(Free_Air.get_Atmosphere_Ratio (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Sealevel_Temperature (An_Instance)) >= 0.0  and
               abs(Free_Air.get_Lapse_Rate (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Ambient_Temperature (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Ambient_Temperature_Ratio (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Ambient_Pressure_Ratio (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Air_Density_at_Altitude (An_Instance)) >= 0.0 ;

        Class_Test_Result_File.Report_Case_Status(Pass);
        Pass := False;

        put_line("------------------ END ------------------------");


    A_Field_Pressure_Altitude  :=  0.0;
    A_Field_Geometric_Altitude := 0.0;
    A_Geometric_Altitude       := 0.0;
    A_Standard_Day_Ambient_Temperature_at_Altitude := 0.0;
    A_Sealevel_Temperature     :=  0.0;
    A_Microburst_Temperature_Change  := 00.0;
    A_Microburst_Pressure_Change     :=  0.0;

    A_Predefined_Sealevel_Pressure_in_Inches_of_Hg  :=  0.0;
    A_Predefined_Pressure_Altitude  :=  0.0;
    A_Predefined_Atmosphere_Ratio :=0.0;
    A_Predefined_Sealevel_Temperature  :=  0.0;
    A_Predefined_Lapse_Rate := 0.0;
    A_Predefined_Ambient_Temperature  := 0.0;
    A_Predefined_Ambient_Temperature_Ratio := 0.0;
    A_Predefined_Ambient_Pressure :=  0.0;
    A_Predefined_Ambient_Pressure_Ratio:= 0.0;
    A_Predefined_Air_Density_at_Altitude := 0.0;

    Free_Air.Assign_Sealevel_Pressure
        (A_Predefined_Sealevel_Pressure_in_Inches_of_Hg,
         An_Instance                                   );
    Free_Air.Assign_Pressure_Altitude(A_Predefined_Pressure_Altitude,
                                       An_Instance);
    Free_Air.Assign_Atmosphere_Ratio
        (A_Predefined_Atmosphere_Ratio,
         An_Instance);
    Free_Air.Assign_Sealevel_Temperature(A_Predefined_Sealevel_Temperature,
                                          An_Instance);
    Free_Air.Assign_Lapse_Rate(A_Predefined_Lapse_Rate,
                                An_Instance);
    Free_Air.Assign_Ambient_Temperature(A_Predefined_Ambient_Temperature,
                                         An_Instance );
    Free_Air.Assign_Ambient_Temperature_Ratio
        (A_Predefined_Ambient_Temperature_Ratio,
         An_Instance);
    Free_Air.Assign_Ambient_Pressure(A_Predefined_Ambient_Pressure,
                                      An_Instance);
   -- Free_Air.Assign_Ambient_Pressure_Ratio(A_Predefined_Ambient_Pressure_Ratio,
   --                                         An_Instance );
   -- Free_Air.Assign_Air_Density_at_Altitude
   --     (A_Predefined_Air_Density_at_Altitude,
   --      An_Instance);

        Free_Air.Set_Sealevel_Pressure_based_on_Altitude (A_Field_Pressure_Altitude ,
                                        A_Field_Geometric_Altitude,
                                        An_Instance               );
        Put_Line(" Sealevel Pressure "); put( Free_Air.Get_Sealevel_Pressure (An_Instance)); Put_Line(" ");

        Free_Air.Set_Pressure_Altitude
            (A_Geometric_Altitude                          ,
             A_Standard_Day_Ambient_Temperature_at_Altitude,
             An_Instance                                   );
        Put_Line(" Pressure Altitude "); put( Free_Air.Get_Pressure_Altitude (An_Instance)); Put_Line(" ");

        Free_Air.Set_Atmosphere_Ratio(An_Instance);
        Put_Line(" Atmosphere_Ratio "); put( Free_Air.Get_Atmosphere_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Sealevel_Temperature (An_Instance);
        Put_Line(" Sealevel_Temperature "); put( Free_Air.Get_Sealevel_Temperature (An_Instance)); Put_Line(" ");

        Free_Air.Set_Lapse_Rate (An_Instance);
        Put_Line(" Lapse_Rate "); put( Free_Air.Get_Lapse_Rate (An_Instance)); Put_Line(" ");

        A_Lapse_Rate:=Free_Air.Get_Lapse_Rate(An_Instance);
        Free_Air.Set_Ambient_Temperature
            (A_Lapse_Rate                   ,
             A_Microburst_Temperature_Change,
             An_Instance                    );
        Put_Line(" Ambient_Temperature "); put( Free_Air.Get_Ambient_Temperature (An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Temperature_Ratio
            (A_Sealevel_Temperature,
                An_Instance);
       Put_Line(" Ambient_Temperature_Ratio "); put( Free_Air.Get_Ambient_Temperature_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Pressure(A_Microburst_Pressure_Change,
                                      An_Instance);
        Put_Line(" Ambient_Pressure "); put( Free_Air.Get_Ambient_Pressure(An_Instance)); Put_Line(" ");

        Free_Air.Set_Ambient_Pressure_Ratio(An_Instance);
        Put_Line(" Ambient_Pressure_Ratio "); put( Free_Air.Get_Ambient_Pressure_Ratio (An_Instance)); Put_Line(" ");

        Free_Air.Set_Air_Density_at_Altitude (An_Instance);
        Put_Line(" Air_Density_at_Altitude "); put( Free_Air.Get_Air_Density_at_Altitude (An_Instance)); Put_Line(" ");

        Pass:= abs(Free_Air.Get_Sealevel_Pressure (An_Instance)) >= 0.0 and
               abs(Free_Air.Get_Pressure_Altitude (An_Instance)) >= 0.0 and
               abs(Free_Air.get_Atmosphere_Ratio (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Sealevel_Temperature (An_Instance)) >= 0.0  and
               abs(Free_Air.get_Lapse_Rate (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Ambient_Temperature (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Ambient_Temperature_Ratio (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Ambient_Pressure_Ratio (An_Instance)) >= 0.0  and
               abs(Free_Air.Get_Air_Density_at_Altitude (An_Instance)) >= 0.0 ;

        Class_Test_Result_File.Report_Case_Status(Pass);
        Pass := False;







end EXECUTE_Free_Air;
