-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Length_Types;
with Coordinate_Types;
with DFW_Microburst;
with DFW_Microburst_Model;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Singly_Indexed;
with Normalized_Types;
with Class_Test_Result_File;


procedure EXECUTE_DFW_Microburst is
    An_Instance                : DFW_Microburst.Instance;

    An_Aircraft_Geometric_Altitude       : Length_Types.Feet := 1000.0;

A_Predefined_Aircraft_Radial_Distance_from_Microburst_Center : float:= 0.0;
A_Predefined_Aircraft_Angle_wrt_Microburst_Center            : float:= 0.0;
A_Predefined_Aircraft_x_Distance_Through_Model               : float:= 0.0;
A_Predefined_DFW_Microburst_Velocity                         : Coordinate_Types.Cartesian:= (0.0,0.0,0.0);
A_Predefined_DFW_Model_Local_Pressure                        : float:= 0.0;
A_Predefined_DFW_Model_Local_Temperature                     : float:= 0.0;
A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst         : float:= 0.0;

An_Aircraft_x_Distance_from_Runway_Touchdown     : float:= 5000.0;
An_Aircraft_y_Distance_from_Runway_Touchdown    : float:=  2500.0;
A_Microburst_x_Center                           : float:=  DFW_Microburst_Model.A_x_position(5);
A_Microburst_y_Center                           : float:=  DFW_Microburst_Model.A_y_position(5);
A_Microburst_Radius                             : float:= DFW_Microburst_Model.A_Radius_for_Display;
DFW_MB_Velocity_Sector_Table          : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Horizontal_Sector_1_Table      : Interpolation_Table.Doubly_Indexed.Instance;
DFW_MB_Horizontal_Sector_2_Table      : Interpolation_Table.Doubly_Indexed.Instance;
DFW_MB_Vertical_Sector_1_Table        : Interpolation_Table.Doubly_Indexed.Instance;
DFW_MB_Vertical_Sector_2_Table        : Interpolation_Table.Doubly_Indexed.Instance;
DFW_MB_Secondary_Wind_Direction_Table : Interpolation_Table.Doubly_Indexed.Instance;
DFW_MB_Basic_Wind_Direction_1_Table   : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Basic_Wind_Direction_2_Table   : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Direction_Sector_Table         : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Local_Pressure_1_Table           : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Local_Temperature_1_Table        : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Local_Pressure_2_Table           : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Local_Temperature_2_Table        : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Local_Pressure_Table           : Interpolation_Table.Singly_Indexed.Instance;
DFW_MB_Local_Temperature_Table        : Interpolation_Table.Singly_Indexed.Instance;

DFW_MB_Roll_Moment_due_to_Microburst_Table : Interpolation_Table.Singly_Indexed.Instance;

An_Aircraft_Height_Above_Local_Terrain : float;
A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center: float ;
A_Predefined_x_Distance_Between_Aircraft_and_Microburst_Center :Length_Types.Feet:=0.0;
A_Predefined_y_Distance_Between_Aircraft_and_Microburst_Center :Length_Types.Feet:=0.0;

Pass : Boolean := False;
A_Tolerance : Float := 0.000_5;

begin
Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Velocity_Sector.csv",DFW_MB_Velocity_Sector_Table );
        put_line(" complete parameterizing DFW_MB_Velocity_Sector_Table ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Basic_Wind_Direction_1.csv",DFW_MB_Basic_Wind_Direction_1_Table );
        put_line(" complete parameterizing DFW_MB_Basic_Wind_Direction_1 ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Basic_Wind_Direction_2.csv" ,DFW_MB_Basic_Wind_Direction_2_Table);
        put_line(" complete parameterizing DFW_MB_Basic_Wind_Direction_2 ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Direction_Sector.csv",DFW_MB_Direction_Sector_Table );
        put_line(" complete parameterizing DFW_MB_Direction_Sector ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Local_Pressure_1.csv",DFW_MB_Local_Pressure_1_Table );
        put_line(" complete parameterizing DFW_MB_Local_Pressure_1 ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Local_Temperature_1.csv",DFW_MB_Local_Temperature_1_Table );
        put_line(" complete parameterizing DFW_MB_Local_Temperature_1 ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Local_Pressure_2.csv",DFW_MB_Local_Pressure_2_Table );
        put_line(" complete parameterizing DFW_MB_Local_Pressure_2 ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Local_Temperature_2.csv",DFW_MB_Local_Temperature_2_Table );
        put_line(" complete parameterizing DFW_MB_Local_Temperature_2 ");

Interpolation_Table.Singly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Roll_Moment_due_to_Microburst.csv" ,DFW_MB_Roll_Moment_due_to_Microburst_Table);
        put_line(" complete parameterizing DFW_MB_Roll_Moment_due_to_Microburst ");

Interpolation_Table.Doubly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Secondary_Wind_Direction.csv" ,DFW_MB_Secondary_Wind_Direction_Table);
        put_line(" complete parameterizing DFW_MB_Secondary_Wind_Direction ");

Interpolation_Table.Doubly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Horizontal_Sector_1.csv",DFW_MB_Horizontal_Sector_1_Table );
        put_line(" complete parameterizing DFW_MB_Horizontal_Sector_1 ");

Interpolation_Table.Doubly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Horizontal_Sector_2.csv",DFW_MB_Horizontal_Sector_2_Table );
        put_line(" complete parameterizing DFW_MB_Horizontal_Sector_2 ");

Interpolation_Table.Doubly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Vertical_Sector_1.csv",DFW_MB_Vertical_Sector_1_Table );
        put_line(" complete parameterizing DFW_MB_Vertical_Sector_1 ");

Interpolation_Table.Doubly_Indexed.Read_ASCII
         ("c:\Jpats\Ada_code\Mkii\Data_Tables\DFW_Microburst_DB\DFW_MB_Vertical_Sector_2.csv",DFW_MB_Vertical_Sector_2_Table );
        put_line(" complete parameterizing DFW_MB_Vertical_Sector_2 ");

DFW_Microburst.Assign_Position
        (A_Predefined_Aircraft_Radial_Distance_from_Microburst_Center ,
         A_Predefined_Aircraft_Angle_wrt_Microburst_Center            ,
         A_Predefined_x_Distance_Between_Aircraft_and_Microburst_Center,
         A_Predefined_y_Distance_Between_Aircraft_and_Microburst_Center,
         An_Instance                                                 );
DFW_Microburst.Assign_Aircraft_x_Distance_Through_Model
        (A_Predefined_Aircraft_x_Distance_Through_Model,
         An_Instance                                   );
DFW_Microburst.Assign_Local_Velocity
        (A_Predefined_DFW_Microburst_Velocity,
         An_Instance                          );
DFW_Microburst.Assign_Local_Pressure
        (A_Predefined_DFW_Model_Local_Pressure,
         An_Instance                          );
DFW_Microburst.Assign_Local_Temperature
        (A_Predefined_DFW_Model_Local_Temperature,
         An_Instance                             );
DFW_Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst,
         An_Instance                                         );

    for i in 1..1 loop
DFW_Microburst.Set_Position
        (An_Aircraft_x_Distance_from_Runway_Touchdown,
         An_Aircraft_y_Distance_from_Runway_Touchdown,
         A_Microburst_x_Center                       ,
         A_Microburst_y_Center                       ,
         A_Microburst_Radius                         ,
         An_Instance                                 );
put(DFW_Microburst.Get_Radial_Distance_to_Aircraft (An_Instance));          Put_Line(" Radial_Distance_to_Aircraft ");
put(DFW_Microburst.Get_Aircraft_x_Distance_Through_Model (An_Instance));    Put_Line(" Aircraft_x_Distance_Through_Model ");
put(DFW_Microburst.Get_Aircraft_Angle_wrt_Microburst_Center (An_Instance)); Put_Line(" Aircraft_Angle_wrt_Microburst_Center ");

DFW_Microburst.Set_Local_Velocity
        (A_Microburst_Radius                   ,
         An_Aircraft_Geometric_Altitude        ,
         DFW_MB_Velocity_Sector_Table         ,
         DFW_MB_Horizontal_Sector_1_Table     ,
         DFW_MB_Horizontal_Sector_2_Table     ,
         DFW_MB_Vertical_Sector_1_Table       ,
         DFW_MB_Vertical_Sector_2_Table       ,
         DFW_MB_Secondary_Wind_Direction_Table,
         DFW_MB_Basic_Wind_Direction_1_Table  ,
         DFW_MB_Basic_Wind_Direction_2_Table  ,
         DFW_MB_Direction_Sector_Table        ,
         An_Instance                          );
put(DFW_Microburst.Get_Local_Velocity(An_Instance).x);put(DFW_Microburst.Get_Local_Velocity(An_Instance).y);
put(DFW_Microburst.Get_Local_Velocity(An_Instance).z);  Put_Line(" Local_Velocity ");

--if (JPATS_Atmosphere.Get_DFW_Microburst_Aircraft_x_Distance_Through_Model <= 6250.0) then
if (A_Predefined_Aircraft_x_Distance_Through_Model <= 6250.0) then
    DFW_MB_Local_Pressure_Table    := DFW_MB_Local_Pressure_1_Table;
    DFW_MB_Local_Temperature_Table := DFW_MB_Local_Temperature_1_Table;
else
    DFW_MB_Local_Pressure_Table    := DFW_MB_Local_Pressure_2_Table;
    DFW_MB_Local_Temperature_Table := DFW_MB_Local_Temperature_2_Table;
end if;


DFW_Microburst.Set_Local_Pressure
        (DFW_MB_Local_Pressure_Table,
         An_Instance                );
put(DFW_Microburst.Get_Local_Pressure (An_Instance));  Put_Line(" Local_Pressure ");

DFW_Microburst.Set_Local_Temperature
        (DFW_MB_Local_Temperature_Table,
         An_Instance                   );
put(DFW_Microburst.Get_Local_Temperature (An_Instance)) ;Put_Line(" Local_Temperature ");

--An_Aircraft_Height_Above_Local_Terrain := JPATS_Simulated_Aircraft.Get_Aircraft_Height_Above_Local_Terrain;
--A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center := JPATS_Atmosphere.Get_y_Distance_Between_Aircraft_and_DFW_Microburst_Center;
An_Aircraft_Height_Above_Local_Terrain := An_Aircraft_Geometric_Altitude;
A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center := 0.0;
if (An_Aircraft_Height_Above_Local_Terrain > 430.0                    and
    An_Aircraft_Height_Above_Local_Terrain < 830.0                    and
    A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center > -100.0  and
    A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center <  500.0) then
DFW_Microburst.Set_Roll_Moment_due_to_Microburst
        (DFW_MB_Roll_Moment_due_to_Microburst_Table,
         An_Instance                               );
else
DFW_Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst,
         An_Instance                                         );
end if;


end loop;


pass := abs(DFW_Microburst.Get_Local_Velocity(An_Instance).x - (-3.53036778)) <= A_Tolerance and
        abs(DFW_Microburst.Get_Local_Velocity(An_Instance).y - (-3.40824497)) <= A_Tolerance and
        abs(DFW_Microburst.Get_Local_Velocity(An_Instance).z - 3.45137) <= A_Tolerance and
        abs(DFW_Microburst.Get_Radial_Distance_to_Aircraft(An_Instance) - 1272.56843) <= A_Tolerance and
        abs(DFW_Microburst.Get_Aircraft_Angle_wrt_Microburst_Center(An_Instance) - 0.81490631) <= A_Tolerance;

 Class_Test_Result_File.Report_Case_Status(Pass);
 Pass:= False;

 put_line("---------------- CONSTRAINT -----------------");

A_Predefined_Aircraft_Radial_Distance_from_Microburst_Center := 1000.0;
A_Predefined_Aircraft_Angle_wrt_Microburst_Center            := 1000.0;
A_Predefined_Aircraft_x_Distance_Through_Model               := 1000.0;
A_Predefined_DFW_Microburst_Velocity                         := (1000.0,1000.0,1000.0);
A_Predefined_DFW_Model_Local_Pressure                        := 1000.0;
A_Predefined_DFW_Model_Local_Temperature                     := 1000.0;
A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst         := 1000.0;

An_Aircraft_x_Distance_from_Runway_Touchdown     := 10000.0;
An_Aircraft_y_Distance_from_Runway_Touchdown    :=  10000.0;
A_Microburst_x_Center                           :=  DFW_Microburst_Model.A_x_position(5);
A_Microburst_y_Center                           :=  DFW_Microburst_Model.A_y_position(5);
A_Microburst_Radius                             := DFW_Microburst_Model.A_Radius_for_Display;
A_Predefined_x_Distance_Between_Aircraft_and_Microburst_Center :=1000.0;
A_Predefined_y_Distance_Between_Aircraft_and_Microburst_Center :=1000.0;

DFW_Microburst.Assign_Position
        (A_Predefined_Aircraft_Radial_Distance_from_Microburst_Center ,
         A_Predefined_Aircraft_Angle_wrt_Microburst_Center            ,
         A_Predefined_x_Distance_Between_Aircraft_and_Microburst_Center,
         A_Predefined_y_Distance_Between_Aircraft_and_Microburst_Center,
         An_Instance                                                 );
DFW_Microburst.Assign_Aircraft_x_Distance_Through_Model
        (A_Predefined_Aircraft_x_Distance_Through_Model,
         An_Instance                                   );
DFW_Microburst.Assign_Local_Velocity
        (A_Predefined_DFW_Microburst_Velocity,
         An_Instance                          );
DFW_Microburst.Assign_Local_Pressure
        (A_Predefined_DFW_Model_Local_Pressure,
         An_Instance                          );
DFW_Microburst.Assign_Local_Temperature
        (A_Predefined_DFW_Model_Local_Temperature,
         An_Instance                             );
DFW_Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst,
         An_Instance                                         );

DFW_Microburst.Set_Position
        (An_Aircraft_x_Distance_from_Runway_Touchdown,
         An_Aircraft_y_Distance_from_Runway_Touchdown,
         A_Microburst_x_Center                       ,
         A_Microburst_y_Center                       ,
         A_Microburst_Radius                         ,
         An_Instance                                 );
put(DFW_Microburst.Get_Radial_Distance_to_Aircraft (An_Instance));          Put_Line(" Radial_Distance_to_Aircraft ");
put(DFW_Microburst.Get_Aircraft_x_Distance_Through_Model (An_Instance));    Put_Line(" Aircraft_x_Distance_Through_Model ");
put(DFW_Microburst.Get_Aircraft_Angle_wrt_Microburst_Center (An_Instance)); Put_Line(" Aircraft_Angle_wrt_Microburst_Center ");

DFW_Microburst.Set_Local_Velocity
        (A_Microburst_Radius                   ,
         An_Aircraft_Geometric_Altitude        ,
         DFW_MB_Velocity_Sector_Table         ,
         DFW_MB_Horizontal_Sector_1_Table     ,
         DFW_MB_Horizontal_Sector_2_Table     ,
         DFW_MB_Vertical_Sector_1_Table       ,
         DFW_MB_Vertical_Sector_2_Table       ,
         DFW_MB_Secondary_Wind_Direction_Table,
         DFW_MB_Basic_Wind_Direction_1_Table  ,
         DFW_MB_Basic_Wind_Direction_2_Table  ,
         DFW_MB_Direction_Sector_Table        ,
         An_Instance                          );
put(DFW_Microburst.Get_Local_Velocity(An_Instance).x);put(DFW_Microburst.Get_Local_Velocity(An_Instance).y);
put(DFW_Microburst.Get_Local_Velocity(An_Instance).z);  Put_Line(" Local_Velocity ");

--if (JPATS_Atmosphere.Get_DFW_Microburst_Aircraft_x_Distance_Through_Model <= 6250.0) then
if (A_Predefined_Aircraft_x_Distance_Through_Model <= 6250.0) then
    DFW_MB_Local_Pressure_Table    := DFW_MB_Local_Pressure_1_Table;
    DFW_MB_Local_Temperature_Table := DFW_MB_Local_Temperature_1_Table;
else
    DFW_MB_Local_Pressure_Table    := DFW_MB_Local_Pressure_2_Table;
    DFW_MB_Local_Temperature_Table := DFW_MB_Local_Temperature_2_Table;
end if;


DFW_Microburst.Set_Local_Pressure
        (DFW_MB_Local_Pressure_Table,
         An_Instance                );
put(DFW_Microburst.Get_Local_Pressure (An_Instance));  Put_Line(" Local_Pressure ");

DFW_Microburst.Set_Local_Temperature
        (DFW_MB_Local_Temperature_Table,
         An_Instance                   );
put(DFW_Microburst.Get_Local_Temperature (An_Instance)) ;Put_Line(" Local_Temperature ");

--An_Aircraft_Height_Above_Local_Terrain := JPATS_Simulated_Aircraft.Get_Aircraft_Height_Above_Local_Terrain;
--A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center := JPATS_Atmosphere.Get_y_Distance_Between_Aircraft_and_DFW_Microburst_Center;
An_Aircraft_Height_Above_Local_Terrain := An_Aircraft_Geometric_Altitude;
A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center := 0.0;
if (An_Aircraft_Height_Above_Local_Terrain > 430.0                    and
    An_Aircraft_Height_Above_Local_Terrain < 830.0                    and
    A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center > -100.0  and
    A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center <  500.0) then
DFW_Microburst.Set_Roll_Moment_due_to_Microburst
        (DFW_MB_Roll_Moment_due_to_Microburst_Table,
         An_Instance                               );
else
DFW_Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst,
         An_Instance                                         );
end if;




pass := abs(DFW_Microburst.Get_Local_Velocity(An_Instance).x ) >= 0.0 and
        abs(DFW_Microburst.Get_Local_Velocity(An_Instance).y ) >= 0.0 and
        abs(DFW_Microburst.Get_Local_Velocity(An_Instance).z ) >= 0.0 and
        abs(DFW_Microburst.Get_Radial_Distance_to_Aircraft(An_Instance) ) >= 0.0 and
        abs(DFW_Microburst.Get_Aircraft_Angle_wrt_Microburst_Center(An_Instance) ) >= 0.0 ;

 Class_Test_Result_File.Report_Case_Status(Pass);
 Pass:= False;


 put_line("---------------- END -----------------");

A_Predefined_Aircraft_Radial_Distance_from_Microburst_Center := 0.0;
A_Predefined_Aircraft_Angle_wrt_Microburst_Center            := 0.0;
A_Predefined_Aircraft_x_Distance_Through_Model               := 0.0;
A_Predefined_DFW_Microburst_Velocity                         := (0.0,0.0,0.0);
A_Predefined_DFW_Model_Local_Pressure                        := 0.0;
A_Predefined_DFW_Model_Local_Temperature                     := 0.0;
A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst         := 0.0;

An_Aircraft_x_Distance_from_Runway_Touchdown     := 00.0;
An_Aircraft_y_Distance_from_Runway_Touchdown    :=  00.0;
A_Microburst_x_Center                           :=  DFW_Microburst_Model.A_x_position(5);
A_Microburst_y_Center                           :=  DFW_Microburst_Model.A_y_position(5);
A_Microburst_Radius                             := DFW_Microburst_Model.A_Radius_for_Display;
A_Predefined_x_Distance_Between_Aircraft_and_Microburst_Center :=0.0;
A_Predefined_y_Distance_Between_Aircraft_and_Microburst_Center :=0.0;

DFW_Microburst.Assign_Position
        (A_Predefined_Aircraft_Radial_Distance_from_Microburst_Center ,
         A_Predefined_Aircraft_Angle_wrt_Microburst_Center            ,
         A_Predefined_x_Distance_Between_Aircraft_and_Microburst_Center,
         A_Predefined_y_Distance_Between_Aircraft_and_Microburst_Center,
         An_Instance                                                 );
DFW_Microburst.Assign_Aircraft_x_Distance_Through_Model
        (A_Predefined_Aircraft_x_Distance_Through_Model,
         An_Instance                                   );
DFW_Microburst.Assign_Local_Velocity
        (A_Predefined_DFW_Microburst_Velocity,
         An_Instance                          );
DFW_Microburst.Assign_Local_Pressure
        (A_Predefined_DFW_Model_Local_Pressure,
         An_Instance                          );
DFW_Microburst.Assign_Local_Temperature
        (A_Predefined_DFW_Model_Local_Temperature,
         An_Instance                             );
DFW_Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst,
         An_Instance                                         );

DFW_Microburst.Set_Position
        (An_Aircraft_x_Distance_from_Runway_Touchdown,
         An_Aircraft_y_Distance_from_Runway_Touchdown,
         A_Microburst_x_Center                       ,
         A_Microburst_y_Center                       ,
         A_Microburst_Radius                         ,
         An_Instance                                 );
put(DFW_Microburst.Get_Radial_Distance_to_Aircraft (An_Instance));          Put_Line(" Radial_Distance_to_Aircraft ");
put(DFW_Microburst.Get_Aircraft_x_Distance_Through_Model (An_Instance));    Put_Line(" Aircraft_x_Distance_Through_Model ");
put(DFW_Microburst.Get_Aircraft_Angle_wrt_Microburst_Center (An_Instance)); Put_Line(" Aircraft_Angle_wrt_Microburst_Center ");

DFW_Microburst.Set_Local_Velocity
        (A_Microburst_Radius                   ,
         An_Aircraft_Geometric_Altitude        ,
         DFW_MB_Velocity_Sector_Table         ,
         DFW_MB_Horizontal_Sector_1_Table     ,
         DFW_MB_Horizontal_Sector_2_Table     ,
         DFW_MB_Vertical_Sector_1_Table       ,
         DFW_MB_Vertical_Sector_2_Table       ,
         DFW_MB_Secondary_Wind_Direction_Table,
         DFW_MB_Basic_Wind_Direction_1_Table  ,
         DFW_MB_Basic_Wind_Direction_2_Table  ,
         DFW_MB_Direction_Sector_Table        ,
         An_Instance                          );
put(DFW_Microburst.Get_Local_Velocity(An_Instance).x);put(DFW_Microburst.Get_Local_Velocity(An_Instance).y);
put(DFW_Microburst.Get_Local_Velocity(An_Instance).z);  Put_Line(" Local_Velocity ");

--if (JPATS_Atmosphere.Get_DFW_Microburst_Aircraft_x_Distance_Through_Model <= 6250.0) then
if (A_Predefined_Aircraft_x_Distance_Through_Model <= 6250.0) then
    DFW_MB_Local_Pressure_Table    := DFW_MB_Local_Pressure_1_Table;
    DFW_MB_Local_Temperature_Table := DFW_MB_Local_Temperature_1_Table;
else
    DFW_MB_Local_Pressure_Table    := DFW_MB_Local_Pressure_2_Table;
    DFW_MB_Local_Temperature_Table := DFW_MB_Local_Temperature_2_Table;
end if;


DFW_Microburst.Set_Local_Pressure
        (DFW_MB_Local_Pressure_Table,
         An_Instance                );
put(DFW_Microburst.Get_Local_Pressure (An_Instance));  Put_Line(" Local_Pressure ");

DFW_Microburst.Set_Local_Temperature
        (DFW_MB_Local_Temperature_Table,
         An_Instance                   );
put(DFW_Microburst.Get_Local_Temperature (An_Instance)) ;Put_Line(" Local_Temperature ");

--An_Aircraft_Height_Above_Local_Terrain := JPATS_Simulated_Aircraft.Get_Aircraft_Height_Above_Local_Terrain;
--A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center := JPATS_Atmosphere.Get_y_Distance_Between_Aircraft_and_DFW_Microburst_Center;
An_Aircraft_Height_Above_Local_Terrain := An_Aircraft_Geometric_Altitude;
A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center := 0.0;
if (An_Aircraft_Height_Above_Local_Terrain > 430.0                    and
    An_Aircraft_Height_Above_Local_Terrain < 830.0                    and
    A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center > -100.0  and
    A_y_Distance_Between_Aircraft_and_DFW_Microburst_Center <  500.0) then
DFW_Microburst.Set_Roll_Moment_due_to_Microburst
        (DFW_MB_Roll_Moment_due_to_Microburst_Table,
         An_Instance                               );
else
DFW_Microburst.Assign_Roll_Moment_due_to_Microburst
        (A_Predefined_DFW_Model_Roll_Moment_due_to_Microburst,
         An_Instance                                         );
end if;




pass := abs(DFW_Microburst.Get_Local_Velocity(An_Instance).x ) >= 0.0 and
        abs(DFW_Microburst.Get_Local_Velocity(An_Instance).y ) >= 0.0 and
        abs(DFW_Microburst.Get_Local_Velocity(An_Instance).z ) >= 0.0 and
        abs(DFW_Microburst.Get_Radial_Distance_to_Aircraft(An_Instance) ) >= 0.0 and
        abs(DFW_Microburst.Get_Aircraft_Angle_wrt_Microburst_Center(An_Instance) ) >= 0.0 ;

 Class_Test_Result_File.Report_Case_Status(Pass);
 Pass:= False;


end EXECUTE_DFW_Microburst;
